/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.stage;

import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.agent.task.connection.EventSupplier;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.stage.PipeTaskStage;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskExtractorStage
extends PipeTaskStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskExtractorStage.class);
    private final PipeExtractor pipeExtractor;

    public PipeTaskExtractorStage(String pipeName, long creationTime, PipeParameters extractorParameters, int regionId, PipeTaskMeta pipeTaskMeta) {
        this.pipeExtractor = StorageEngine.getInstance().getAllDataRegionIds().contains(new DataRegionId(regionId)) ? PipeDataNodeAgent.plugin().dataRegion().reflectExtractor(extractorParameters) : PipeDataNodeAgent.plugin().schemaRegion().reflectExtractor(extractorParameters);
        try {
            this.pipeExtractor.validate(new PipeParameterValidator(extractorParameters));
            PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskExtractorRuntimeEnvironment(pipeName, creationTime, regionId, pipeTaskMeta));
            this.pipeExtractor.customize(extractorParameters, (PipeExtractorRuntimeConfiguration)runtimeConfiguration);
        }
        catch (Exception e) {
            try {
                this.pipeExtractor.close();
            }
            catch (Exception closeException) {
                LOGGER.warn("Failed to close extractor after failed to initialize extractor. Ignore this exception.", (Throwable)closeException);
            }
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
    }

    public void createSubtask() throws PipeException {
    }

    public void startSubtask() throws PipeException {
        try {
            this.pipeExtractor.start();
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
    }

    public void stopSubtask() throws PipeException {
    }

    public void dropSubtask() throws PipeException {
        try {
            this.pipeExtractor.close();
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
    }

    public EventSupplier getEventSupplier() {
        return () -> ((PipeExtractor)this.pipeExtractor).supply();
    }
}

