/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.config;

import io.swagger.config.Scanner;
import io.swagger.config.ScannerFactory;
import io.swagger.config.SwaggerConfig;
import io.swagger.jaxrs.config.DefaultJaxrsScanner;
import io.swagger.jaxrs.config.SwaggerConfigLocator;
import io.swagger.jaxrs.config.SwaggerScannerLocator;
import io.swagger.jaxrs.config.WebXMLReader;
import io.swagger.models.Swagger;
import javax.servlet.ServletConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerContextService {
    private static Logger LOGGER = LoggerFactory.getLogger(SwaggerContextService.class);
    public static final String CONFIG_ID_KEY = "swagger.config.id";
    public static final String CONFIG_ID_PREFIX = "swagger.config.id.";
    public static final String CONFIG_ID_DEFAULT = "swagger.config.id.default";
    public static final String SCANNER_ID_KEY = "swagger.scanner.id";
    public static final String SCANNER_ID_PREFIX = "swagger.scanner.id.";
    public static final String SCANNER_ID_DEFAULT = "swagger.scanner.id.default";
    public static final String CONTEXT_ID_KEY = "swagger.context.id";
    public static final String USE_PATH_BASED_CONFIG = "swagger.use.path.based.config";
    private ServletConfig sc;
    private String configId;
    private SwaggerConfig swaggerConfig;
    private String scannerId;
    private Scanner scanner;
    private String contextId;
    private String basePath;
    private boolean usePathBasedConfig = false;

    public boolean isUsePathBasedConfig() {
        return this.usePathBasedConfig;
    }

    public void setUsePathBasedConfig(boolean usePathBasedConfig) {
        this.usePathBasedConfig = usePathBasedConfig;
    }

    public void setBasePath(String basePath) {
        this.basePath = SwaggerContextService.normalizeBasePath(basePath);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setScannerId(String scannerId) {
        this.scannerId = scannerId;
    }

    public void setScanner(Scanner scanner) {
        this.scanner = scanner;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public void setSwaggerConfig(SwaggerConfig swaggerConfig) {
        this.swaggerConfig = swaggerConfig;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public void setSc(ServletConfig sc) {
        this.sc = sc;
    }

    public SwaggerContextService withServletConfig(ServletConfig sc) {
        if (SwaggerContextService.isServletConfigAvailable(sc)) {
            this.sc = sc;
        }
        return this;
    }

    public static boolean isServletConfigAvailable(ServletConfig sc) {
        if (sc == null) {
            return false;
        }
        try {
            sc.getInitParameter("test");
        }
        catch (Exception e) {
            LOGGER.info("Exception caught testing servletConfig. see https://github.com/swagger-api/swagger-core/issues/1691 ", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public SwaggerContextService withBasePath(String basePath) {
        this.basePath = SwaggerContextService.normalizeBasePath(basePath);
        return this;
    }

    public SwaggerContextService withPathBasedConfig(boolean usePathBasedConfig) {
        this.usePathBasedConfig = usePathBasedConfig;
        return this;
    }

    public SwaggerContextService withConfigId(String configId) {
        this.configId = configId;
        return this;
    }

    public SwaggerContextService withSwaggerConfig(SwaggerConfig swaggerConfig) {
        this.swaggerConfig = swaggerConfig;
        return this;
    }

    public SwaggerContextService withScannerId(String scannerId) {
        this.scannerId = scannerId;
        return this;
    }

    public SwaggerContextService withContextId(String contextId) {
        this.contextId = contextId;
        return this;
    }

    public SwaggerContextService withScanner(Scanner scanner) {
        this.scanner = scanner;
        return this;
    }

    public SwaggerContextService initConfig() {
        return this.initConfig(null);
    }

    public SwaggerContextService initConfig(Swagger swagger) {
        SwaggerConfig value;
        String configIdKey;
        if (this.configId != null) {
            configIdKey = CONFIG_ID_PREFIX + this.configId;
        } else if (this.contextId != null) {
            configIdKey = CONFIG_ID_PREFIX + this.contextId;
        } else if (SwaggerContextService.isServletConfigAvailable(this.sc)) {
            String string = configIdKey = this.sc.getInitParameter(CONFIG_ID_KEY) != null ? CONFIG_ID_PREFIX + this.sc.getInitParameter(CONFIG_ID_KEY) : null;
            if (configIdKey == null) {
                boolean usePathBasedConfig = Boolean.valueOf(this.sc.getInitParameter(USE_PATH_BASED_CONFIG));
                configIdKey = usePathBasedConfig && StringUtils.isNotBlank((CharSequence)this.basePath) ? CONFIG_ID_PREFIX + this.basePath : (this.sc.getInitParameter(CONTEXT_ID_KEY) != null ? CONFIG_ID_PREFIX + this.sc.getInitParameter(CONTEXT_ID_KEY) : CONFIG_ID_DEFAULT);
            }
        } else {
            configIdKey = this.isUsePathBasedConfig() && StringUtils.isNotBlank((CharSequence)this.basePath) ? CONFIG_ID_PREFIX + this.basePath : CONFIG_ID_DEFAULT;
        }
        SwaggerConfig swaggerConfig = value = this.swaggerConfig != null ? this.swaggerConfig : null;
        if (value == null && SwaggerContextService.isServletConfigAvailable(this.sc)) {
            value = new WebXMLReader(this.sc);
        }
        if (value != null) {
            SwaggerConfigLocator.getInstance().putConfig(configIdKey, value);
        }
        if (swagger != null) {
            SwaggerConfigLocator.getInstance().putSwagger(configIdKey, swagger);
        }
        return this;
    }

    private Object getConfigOrSwagger(boolean returnSwagger) {
        String configIdKey;
        if (this.configId != null) {
            configIdKey = CONFIG_ID_PREFIX + this.configId;
        } else if (this.contextId != null) {
            configIdKey = CONFIG_ID_PREFIX + this.contextId;
        } else if (SwaggerContextService.isServletConfigAvailable(this.sc)) {
            String string = configIdKey = this.sc.getInitParameter(CONFIG_ID_KEY) != null ? CONFIG_ID_PREFIX + this.sc.getInitParameter(CONFIG_ID_KEY) : null;
            if (configIdKey == null) {
                boolean usePathBasedConfig = Boolean.valueOf(this.sc.getInitParameter(USE_PATH_BASED_CONFIG));
                configIdKey = usePathBasedConfig && StringUtils.isNotBlank((CharSequence)this.basePath) ? CONFIG_ID_PREFIX + this.basePath : (this.sc.getInitParameter(CONTEXT_ID_KEY) != null ? CONFIG_ID_PREFIX + this.sc.getInitParameter(CONTEXT_ID_KEY) : CONFIG_ID_DEFAULT);
            }
        } else {
            configIdKey = CONFIG_ID_DEFAULT;
        }
        if (returnSwagger) {
            return SwaggerConfigLocator.getInstance().getSwagger(configIdKey);
        }
        return SwaggerConfigLocator.getInstance().getConfig(configIdKey);
    }

    public SwaggerConfig getConfig() {
        return (SwaggerConfig)this.getConfigOrSwagger(false);
    }

    public Swagger getSwagger() {
        Swagger value = (Swagger)this.getConfigOrSwagger(true);
        if (value == null && SwaggerContextService.isServletConfigAvailable(this.sc)) {
            value = (Swagger)this.sc.getServletContext().getAttribute("swagger");
        }
        if (value == null) {
            value = new Swagger();
        }
        return value;
    }

    public SwaggerContextService updateSwagger(Swagger swagger) {
        String configIdKey;
        if (this.configId != null) {
            configIdKey = CONFIG_ID_PREFIX + this.configId;
        } else if (this.contextId != null) {
            configIdKey = CONFIG_ID_PREFIX + this.contextId;
        } else if (SwaggerContextService.isServletConfigAvailable(this.sc)) {
            String string = configIdKey = this.sc.getInitParameter(CONFIG_ID_KEY) != null ? CONFIG_ID_PREFIX + this.sc.getInitParameter(CONFIG_ID_KEY) : null;
            if (configIdKey == null) {
                boolean usePathBasedConfig = Boolean.valueOf(this.sc.getInitParameter(USE_PATH_BASED_CONFIG));
                configIdKey = usePathBasedConfig && StringUtils.isNotBlank((CharSequence)this.basePath) ? CONFIG_ID_PREFIX + this.basePath : (this.sc.getInitParameter(CONTEXT_ID_KEY) != null ? CONFIG_ID_PREFIX + this.sc.getInitParameter(CONTEXT_ID_KEY) : CONFIG_ID_DEFAULT);
            }
        } else {
            configIdKey = this.isUsePathBasedConfig() && StringUtils.isNotBlank((CharSequence)this.basePath) ? CONFIG_ID_PREFIX + this.basePath : CONFIG_ID_DEFAULT;
        }
        if (swagger != null) {
            SwaggerConfigLocator.getInstance().putSwagger(configIdKey, swagger);
        }
        return this;
    }

    public SwaggerContextService initScanner() {
        String scannerIdKey;
        if (this.scannerId != null) {
            scannerIdKey = SCANNER_ID_PREFIX + this.scannerId;
        } else if (this.contextId != null) {
            scannerIdKey = SCANNER_ID_PREFIX + this.contextId;
        } else if (SwaggerContextService.isServletConfigAvailable(this.sc)) {
            String string = scannerIdKey = this.sc.getInitParameter(SCANNER_ID_KEY) != null ? SCANNER_ID_PREFIX + this.sc.getInitParameter(SCANNER_ID_KEY) : null;
            if (scannerIdKey == null) {
                boolean usePathBasedConfig = Boolean.valueOf(this.sc.getInitParameter(USE_PATH_BASED_CONFIG));
                scannerIdKey = usePathBasedConfig && StringUtils.isNotBlank((CharSequence)this.basePath) ? SCANNER_ID_PREFIX + this.basePath : (this.sc.getInitParameter(CONTEXT_ID_KEY) != null ? SCANNER_ID_PREFIX + this.sc.getInitParameter(CONTEXT_ID_KEY) : SCANNER_ID_DEFAULT);
            }
        } else {
            scannerIdKey = this.isUsePathBasedConfig() && StringUtils.isNotBlank((CharSequence)this.basePath) ? SCANNER_ID_PREFIX + this.basePath : SCANNER_ID_DEFAULT;
        }
        Scanner value = this.scanner != null ? this.scanner : new DefaultJaxrsScanner();
        ScannerFactory.setScanner((Scanner)value);
        if (SwaggerContextService.isServletConfigAvailable(this.sc)) {
            this.sc.getServletContext().setAttribute(scannerIdKey, (Object)value);
            String shouldPrettyPrint = this.sc.getInitParameter("swagger.pretty.print");
            if (shouldPrettyPrint != null) {
                value.setPrettyPrint(Boolean.parseBoolean(shouldPrettyPrint));
            }
        }
        SwaggerScannerLocator.getInstance().putScanner(scannerIdKey, value);
        return this;
    }

    public Scanner getScanner() {
        String scannerIdKey;
        Scanner value = null;
        if (this.scannerId != null) {
            scannerIdKey = SCANNER_ID_PREFIX + this.scannerId;
        } else if (this.contextId != null) {
            scannerIdKey = SCANNER_ID_PREFIX + this.contextId;
        } else if (SwaggerContextService.isServletConfigAvailable(this.sc)) {
            String string = scannerIdKey = this.sc.getInitParameter(SCANNER_ID_KEY) != null ? SCANNER_ID_PREFIX + this.sc.getInitParameter(SCANNER_ID_KEY) : null;
            if (scannerIdKey == null) {
                boolean usePathBasedConfig = Boolean.valueOf(this.sc.getInitParameter(USE_PATH_BASED_CONFIG));
                scannerIdKey = usePathBasedConfig && StringUtils.isNotBlank((CharSequence)this.basePath) ? SCANNER_ID_PREFIX + this.basePath : (this.sc.getInitParameter(CONTEXT_ID_KEY) != null ? SCANNER_ID_PREFIX + this.sc.getInitParameter(CONTEXT_ID_KEY) : SCANNER_ID_DEFAULT);
            }
            value = (Scanner)this.sc.getServletContext().getAttribute(scannerIdKey);
        } else {
            scannerIdKey = SCANNER_ID_DEFAULT;
        }
        if (value != null) {
            return value;
        }
        value = SwaggerScannerLocator.getInstance().getScanner(scannerIdKey);
        if (value != null) {
            return value;
        }
        return ScannerFactory.getScanner();
    }

    public static boolean isUsePathBasedConfigInitParamDefined(ServletConfig sc) {
        if (!SwaggerContextService.isServletConfigAvailable(sc)) {
            return false;
        }
        String key = sc.getInitParameter(USE_PATH_BASED_CONFIG);
        if (key != null) {
            return true;
        }
        return sc.getInitParameter(CONTEXT_ID_KEY) != null;
    }

    public static boolean isScannerIdInitParamDefined(ServletConfig sc) {
        if (!SwaggerContextService.isServletConfigAvailable(sc)) {
            return false;
        }
        String key = sc.getInitParameter(SCANNER_ID_KEY);
        if (key != null) {
            return true;
        }
        return sc.getInitParameter(CONTEXT_ID_KEY) != null;
    }

    public static String getScannerIdFromInitParam(ServletConfig sc) {
        if (!SwaggerContextService.isServletConfigAvailable(sc)) {
            return null;
        }
        String key = sc.getInitParameter(SCANNER_ID_KEY);
        if (key != null) {
            return key;
        }
        return sc.getInitParameter(CONTEXT_ID_KEY);
    }

    public static boolean isConfigIdInitParamDefined(ServletConfig sc) {
        if (!SwaggerContextService.isServletConfigAvailable(sc)) {
            return false;
        }
        String key = sc.getInitParameter(CONFIG_ID_KEY);
        if (key != null) {
            return true;
        }
        return sc.getInitParameter(CONTEXT_ID_KEY) != null;
    }

    public static String getConfigIdFromInitParam(ServletConfig sc) {
        if (!SwaggerContextService.isServletConfigAvailable(sc)) {
            return null;
        }
        String key = sc.getInitParameter(CONFIG_ID_KEY);
        if (key != null) {
            return key;
        }
        return sc.getInitParameter(CONTEXT_ID_KEY);
    }

    private static String normalizeBasePath(String basePath) {
        if (basePath == null) {
            return basePath;
        }
        String normalizedBasePath = basePath.trim();
        if (!normalizedBasePath.startsWith("/")) {
            normalizedBasePath = "/" + normalizedBasePath;
        }
        if (!normalizedBasePath.endsWith("/")) {
            normalizedBasePath = normalizedBasePath + "/";
        }
        return normalizedBasePath;
    }
}

