/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceCounterDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SessionDiagnosticsDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=865");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=866");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=867");
    private final NodeId sessionId;
    private final String sessionName;
    private final ApplicationDescription clientDescription;
    private final String serverUri;
    private final String endpointUrl;
    private final String[] localeIds;
    private final Double actualSessionTimeout;
    private final UInteger maxResponseMessageSize;
    private final DateTime clientConnectionTime;
    private final DateTime clientLastContactTime;
    private final UInteger currentSubscriptionsCount;
    private final UInteger currentMonitoredItemsCount;
    private final UInteger currentPublishRequestsInQueue;
    private final ServiceCounterDataType totalRequestCount;
    private final UInteger unauthorizedRequestCount;
    private final ServiceCounterDataType readCount;
    private final ServiceCounterDataType historyReadCount;
    private final ServiceCounterDataType writeCount;
    private final ServiceCounterDataType historyUpdateCount;
    private final ServiceCounterDataType callCount;
    private final ServiceCounterDataType createMonitoredItemsCount;
    private final ServiceCounterDataType modifyMonitoredItemsCount;
    private final ServiceCounterDataType setMonitoringModeCount;
    private final ServiceCounterDataType setTriggeringCount;
    private final ServiceCounterDataType deleteMonitoredItemsCount;
    private final ServiceCounterDataType createSubscriptionCount;
    private final ServiceCounterDataType modifySubscriptionCount;
    private final ServiceCounterDataType setPublishingModeCount;
    private final ServiceCounterDataType publishCount;
    private final ServiceCounterDataType republishCount;
    private final ServiceCounterDataType transferSubscriptionsCount;
    private final ServiceCounterDataType deleteSubscriptionsCount;
    private final ServiceCounterDataType addNodesCount;
    private final ServiceCounterDataType addReferencesCount;
    private final ServiceCounterDataType deleteNodesCount;
    private final ServiceCounterDataType deleteReferencesCount;
    private final ServiceCounterDataType browseCount;
    private final ServiceCounterDataType browseNextCount;
    private final ServiceCounterDataType translateBrowsePathsToNodeIdsCount;
    private final ServiceCounterDataType queryFirstCount;
    private final ServiceCounterDataType queryNextCount;
    private final ServiceCounterDataType registerNodesCount;
    private final ServiceCounterDataType unregisterNodesCount;

    public SessionDiagnosticsDataType(NodeId sessionId, String sessionName, ApplicationDescription clientDescription, String serverUri, String endpointUrl, String[] localeIds, Double actualSessionTimeout, UInteger maxResponseMessageSize, DateTime clientConnectionTime, DateTime clientLastContactTime, UInteger currentSubscriptionsCount, UInteger currentMonitoredItemsCount, UInteger currentPublishRequestsInQueue, ServiceCounterDataType totalRequestCount, UInteger unauthorizedRequestCount, ServiceCounterDataType readCount, ServiceCounterDataType historyReadCount, ServiceCounterDataType writeCount, ServiceCounterDataType historyUpdateCount, ServiceCounterDataType callCount, ServiceCounterDataType createMonitoredItemsCount, ServiceCounterDataType modifyMonitoredItemsCount, ServiceCounterDataType setMonitoringModeCount, ServiceCounterDataType setTriggeringCount, ServiceCounterDataType deleteMonitoredItemsCount, ServiceCounterDataType createSubscriptionCount, ServiceCounterDataType modifySubscriptionCount, ServiceCounterDataType setPublishingModeCount, ServiceCounterDataType publishCount, ServiceCounterDataType republishCount, ServiceCounterDataType transferSubscriptionsCount, ServiceCounterDataType deleteSubscriptionsCount, ServiceCounterDataType addNodesCount, ServiceCounterDataType addReferencesCount, ServiceCounterDataType deleteNodesCount, ServiceCounterDataType deleteReferencesCount, ServiceCounterDataType browseCount, ServiceCounterDataType browseNextCount, ServiceCounterDataType translateBrowsePathsToNodeIdsCount, ServiceCounterDataType queryFirstCount, ServiceCounterDataType queryNextCount, ServiceCounterDataType registerNodesCount, ServiceCounterDataType unregisterNodesCount) {
        this.sessionId = sessionId;
        this.sessionName = sessionName;
        this.clientDescription = clientDescription;
        this.serverUri = serverUri;
        this.endpointUrl = endpointUrl;
        this.localeIds = localeIds;
        this.actualSessionTimeout = actualSessionTimeout;
        this.maxResponseMessageSize = maxResponseMessageSize;
        this.clientConnectionTime = clientConnectionTime;
        this.clientLastContactTime = clientLastContactTime;
        this.currentSubscriptionsCount = currentSubscriptionsCount;
        this.currentMonitoredItemsCount = currentMonitoredItemsCount;
        this.currentPublishRequestsInQueue = currentPublishRequestsInQueue;
        this.totalRequestCount = totalRequestCount;
        this.unauthorizedRequestCount = unauthorizedRequestCount;
        this.readCount = readCount;
        this.historyReadCount = historyReadCount;
        this.writeCount = writeCount;
        this.historyUpdateCount = historyUpdateCount;
        this.callCount = callCount;
        this.createMonitoredItemsCount = createMonitoredItemsCount;
        this.modifyMonitoredItemsCount = modifyMonitoredItemsCount;
        this.setMonitoringModeCount = setMonitoringModeCount;
        this.setTriggeringCount = setTriggeringCount;
        this.deleteMonitoredItemsCount = deleteMonitoredItemsCount;
        this.createSubscriptionCount = createSubscriptionCount;
        this.modifySubscriptionCount = modifySubscriptionCount;
        this.setPublishingModeCount = setPublishingModeCount;
        this.publishCount = publishCount;
        this.republishCount = republishCount;
        this.transferSubscriptionsCount = transferSubscriptionsCount;
        this.deleteSubscriptionsCount = deleteSubscriptionsCount;
        this.addNodesCount = addNodesCount;
        this.addReferencesCount = addReferencesCount;
        this.deleteNodesCount = deleteNodesCount;
        this.deleteReferencesCount = deleteReferencesCount;
        this.browseCount = browseCount;
        this.browseNextCount = browseNextCount;
        this.translateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount;
        this.queryFirstCount = queryFirstCount;
        this.queryNextCount = queryNextCount;
        this.registerNodesCount = registerNodesCount;
        this.unregisterNodesCount = unregisterNodesCount;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public ApplicationDescription getClientDescription() {
        return this.clientDescription;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public String[] getLocaleIds() {
        return this.localeIds;
    }

    public Double getActualSessionTimeout() {
        return this.actualSessionTimeout;
    }

    public UInteger getMaxResponseMessageSize() {
        return this.maxResponseMessageSize;
    }

    public DateTime getClientConnectionTime() {
        return this.clientConnectionTime;
    }

    public DateTime getClientLastContactTime() {
        return this.clientLastContactTime;
    }

    public UInteger getCurrentSubscriptionsCount() {
        return this.currentSubscriptionsCount;
    }

    public UInteger getCurrentMonitoredItemsCount() {
        return this.currentMonitoredItemsCount;
    }

    public UInteger getCurrentPublishRequestsInQueue() {
        return this.currentPublishRequestsInQueue;
    }

    public ServiceCounterDataType getTotalRequestCount() {
        return this.totalRequestCount;
    }

    public UInteger getUnauthorizedRequestCount() {
        return this.unauthorizedRequestCount;
    }

    public ServiceCounterDataType getReadCount() {
        return this.readCount;
    }

    public ServiceCounterDataType getHistoryReadCount() {
        return this.historyReadCount;
    }

    public ServiceCounterDataType getWriteCount() {
        return this.writeCount;
    }

    public ServiceCounterDataType getHistoryUpdateCount() {
        return this.historyUpdateCount;
    }

    public ServiceCounterDataType getCallCount() {
        return this.callCount;
    }

    public ServiceCounterDataType getCreateMonitoredItemsCount() {
        return this.createMonitoredItemsCount;
    }

    public ServiceCounterDataType getModifyMonitoredItemsCount() {
        return this.modifyMonitoredItemsCount;
    }

    public ServiceCounterDataType getSetMonitoringModeCount() {
        return this.setMonitoringModeCount;
    }

    public ServiceCounterDataType getSetTriggeringCount() {
        return this.setTriggeringCount;
    }

    public ServiceCounterDataType getDeleteMonitoredItemsCount() {
        return this.deleteMonitoredItemsCount;
    }

    public ServiceCounterDataType getCreateSubscriptionCount() {
        return this.createSubscriptionCount;
    }

    public ServiceCounterDataType getModifySubscriptionCount() {
        return this.modifySubscriptionCount;
    }

    public ServiceCounterDataType getSetPublishingModeCount() {
        return this.setPublishingModeCount;
    }

    public ServiceCounterDataType getPublishCount() {
        return this.publishCount;
    }

    public ServiceCounterDataType getRepublishCount() {
        return this.republishCount;
    }

    public ServiceCounterDataType getTransferSubscriptionsCount() {
        return this.transferSubscriptionsCount;
    }

    public ServiceCounterDataType getDeleteSubscriptionsCount() {
        return this.deleteSubscriptionsCount;
    }

    public ServiceCounterDataType getAddNodesCount() {
        return this.addNodesCount;
    }

    public ServiceCounterDataType getAddReferencesCount() {
        return this.addReferencesCount;
    }

    public ServiceCounterDataType getDeleteNodesCount() {
        return this.deleteNodesCount;
    }

    public ServiceCounterDataType getDeleteReferencesCount() {
        return this.deleteReferencesCount;
    }

    public ServiceCounterDataType getBrowseCount() {
        return this.browseCount;
    }

    public ServiceCounterDataType getBrowseNextCount() {
        return this.browseNextCount;
    }

    public ServiceCounterDataType getTranslateBrowsePathsToNodeIdsCount() {
        return this.translateBrowsePathsToNodeIdsCount;
    }

    public ServiceCounterDataType getQueryFirstCount() {
        return this.queryFirstCount;
    }

    public ServiceCounterDataType getQueryNextCount() {
        return this.queryNextCount;
    }

    public ServiceCounterDataType getRegisterNodesCount() {
        return this.registerNodesCount;
    }

    public ServiceCounterDataType getUnregisterNodesCount() {
        return this.unregisterNodesCount;
    }

    protected SessionDiagnosticsDataType(SessionDiagnosticsDataTypeBuilder<?, ?> b) {
        super(b);
        this.sessionId = ((SessionDiagnosticsDataTypeBuilder)b).sessionId;
        this.sessionName = ((SessionDiagnosticsDataTypeBuilder)b).sessionName;
        this.clientDescription = ((SessionDiagnosticsDataTypeBuilder)b).clientDescription;
        this.serverUri = ((SessionDiagnosticsDataTypeBuilder)b).serverUri;
        this.endpointUrl = ((SessionDiagnosticsDataTypeBuilder)b).endpointUrl;
        this.localeIds = ((SessionDiagnosticsDataTypeBuilder)b).localeIds;
        this.actualSessionTimeout = ((SessionDiagnosticsDataTypeBuilder)b).actualSessionTimeout;
        this.maxResponseMessageSize = ((SessionDiagnosticsDataTypeBuilder)b).maxResponseMessageSize;
        this.clientConnectionTime = ((SessionDiagnosticsDataTypeBuilder)b).clientConnectionTime;
        this.clientLastContactTime = ((SessionDiagnosticsDataTypeBuilder)b).clientLastContactTime;
        this.currentSubscriptionsCount = ((SessionDiagnosticsDataTypeBuilder)b).currentSubscriptionsCount;
        this.currentMonitoredItemsCount = ((SessionDiagnosticsDataTypeBuilder)b).currentMonitoredItemsCount;
        this.currentPublishRequestsInQueue = ((SessionDiagnosticsDataTypeBuilder)b).currentPublishRequestsInQueue;
        this.totalRequestCount = ((SessionDiagnosticsDataTypeBuilder)b).totalRequestCount;
        this.unauthorizedRequestCount = ((SessionDiagnosticsDataTypeBuilder)b).unauthorizedRequestCount;
        this.readCount = ((SessionDiagnosticsDataTypeBuilder)b).readCount;
        this.historyReadCount = ((SessionDiagnosticsDataTypeBuilder)b).historyReadCount;
        this.writeCount = ((SessionDiagnosticsDataTypeBuilder)b).writeCount;
        this.historyUpdateCount = ((SessionDiagnosticsDataTypeBuilder)b).historyUpdateCount;
        this.callCount = ((SessionDiagnosticsDataTypeBuilder)b).callCount;
        this.createMonitoredItemsCount = ((SessionDiagnosticsDataTypeBuilder)b).createMonitoredItemsCount;
        this.modifyMonitoredItemsCount = ((SessionDiagnosticsDataTypeBuilder)b).modifyMonitoredItemsCount;
        this.setMonitoringModeCount = ((SessionDiagnosticsDataTypeBuilder)b).setMonitoringModeCount;
        this.setTriggeringCount = ((SessionDiagnosticsDataTypeBuilder)b).setTriggeringCount;
        this.deleteMonitoredItemsCount = ((SessionDiagnosticsDataTypeBuilder)b).deleteMonitoredItemsCount;
        this.createSubscriptionCount = ((SessionDiagnosticsDataTypeBuilder)b).createSubscriptionCount;
        this.modifySubscriptionCount = ((SessionDiagnosticsDataTypeBuilder)b).modifySubscriptionCount;
        this.setPublishingModeCount = ((SessionDiagnosticsDataTypeBuilder)b).setPublishingModeCount;
        this.publishCount = ((SessionDiagnosticsDataTypeBuilder)b).publishCount;
        this.republishCount = ((SessionDiagnosticsDataTypeBuilder)b).republishCount;
        this.transferSubscriptionsCount = ((SessionDiagnosticsDataTypeBuilder)b).transferSubscriptionsCount;
        this.deleteSubscriptionsCount = ((SessionDiagnosticsDataTypeBuilder)b).deleteSubscriptionsCount;
        this.addNodesCount = ((SessionDiagnosticsDataTypeBuilder)b).addNodesCount;
        this.addReferencesCount = ((SessionDiagnosticsDataTypeBuilder)b).addReferencesCount;
        this.deleteNodesCount = ((SessionDiagnosticsDataTypeBuilder)b).deleteNodesCount;
        this.deleteReferencesCount = ((SessionDiagnosticsDataTypeBuilder)b).deleteReferencesCount;
        this.browseCount = ((SessionDiagnosticsDataTypeBuilder)b).browseCount;
        this.browseNextCount = ((SessionDiagnosticsDataTypeBuilder)b).browseNextCount;
        this.translateBrowsePathsToNodeIdsCount = ((SessionDiagnosticsDataTypeBuilder)b).translateBrowsePathsToNodeIdsCount;
        this.queryFirstCount = ((SessionDiagnosticsDataTypeBuilder)b).queryFirstCount;
        this.queryNextCount = ((SessionDiagnosticsDataTypeBuilder)b).queryNextCount;
        this.registerNodesCount = ((SessionDiagnosticsDataTypeBuilder)b).registerNodesCount;
        this.unregisterNodesCount = ((SessionDiagnosticsDataTypeBuilder)b).unregisterNodesCount;
    }

    public static SessionDiagnosticsDataTypeBuilder<?, ?> builder() {
        return new SessionDiagnosticsDataTypeBuilderImpl();
    }

    public SessionDiagnosticsDataTypeBuilder<?, ?> toBuilder() {
        return new SessionDiagnosticsDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionDiagnosticsDataType)) {
            return false;
        }
        SessionDiagnosticsDataType other = (SessionDiagnosticsDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$actualSessionTimeout = this.getActualSessionTimeout();
        Double other$actualSessionTimeout = other.getActualSessionTimeout();
        if (this$actualSessionTimeout == null ? other$actualSessionTimeout != null : !((Object)this$actualSessionTimeout).equals(other$actualSessionTimeout)) {
            return false;
        }
        NodeId this$sessionId = this.getSessionId();
        NodeId other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        String this$sessionName = this.getSessionName();
        String other$sessionName = other.getSessionName();
        if (this$sessionName == null ? other$sessionName != null : !this$sessionName.equals(other$sessionName)) {
            return false;
        }
        ApplicationDescription this$clientDescription = this.getClientDescription();
        ApplicationDescription other$clientDescription = other.getClientDescription();
        if (this$clientDescription == null ? other$clientDescription != null : !((Object)this$clientDescription).equals(other$clientDescription)) {
            return false;
        }
        String this$serverUri = this.getServerUri();
        String other$serverUri = other.getServerUri();
        if (this$serverUri == null ? other$serverUri != null : !this$serverUri.equals(other$serverUri)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLocaleIds(), other.getLocaleIds())) {
            return false;
        }
        UInteger this$maxResponseMessageSize = this.getMaxResponseMessageSize();
        UInteger other$maxResponseMessageSize = other.getMaxResponseMessageSize();
        if (this$maxResponseMessageSize == null ? other$maxResponseMessageSize != null : !((Object)this$maxResponseMessageSize).equals(other$maxResponseMessageSize)) {
            return false;
        }
        DateTime this$clientConnectionTime = this.getClientConnectionTime();
        DateTime other$clientConnectionTime = other.getClientConnectionTime();
        if (this$clientConnectionTime == null ? other$clientConnectionTime != null : !((Object)this$clientConnectionTime).equals(other$clientConnectionTime)) {
            return false;
        }
        DateTime this$clientLastContactTime = this.getClientLastContactTime();
        DateTime other$clientLastContactTime = other.getClientLastContactTime();
        if (this$clientLastContactTime == null ? other$clientLastContactTime != null : !((Object)this$clientLastContactTime).equals(other$clientLastContactTime)) {
            return false;
        }
        UInteger this$currentSubscriptionsCount = this.getCurrentSubscriptionsCount();
        UInteger other$currentSubscriptionsCount = other.getCurrentSubscriptionsCount();
        if (this$currentSubscriptionsCount == null ? other$currentSubscriptionsCount != null : !((Object)this$currentSubscriptionsCount).equals(other$currentSubscriptionsCount)) {
            return false;
        }
        UInteger this$currentMonitoredItemsCount = this.getCurrentMonitoredItemsCount();
        UInteger other$currentMonitoredItemsCount = other.getCurrentMonitoredItemsCount();
        if (this$currentMonitoredItemsCount == null ? other$currentMonitoredItemsCount != null : !((Object)this$currentMonitoredItemsCount).equals(other$currentMonitoredItemsCount)) {
            return false;
        }
        UInteger this$currentPublishRequestsInQueue = this.getCurrentPublishRequestsInQueue();
        UInteger other$currentPublishRequestsInQueue = other.getCurrentPublishRequestsInQueue();
        if (this$currentPublishRequestsInQueue == null ? other$currentPublishRequestsInQueue != null : !((Object)this$currentPublishRequestsInQueue).equals(other$currentPublishRequestsInQueue)) {
            return false;
        }
        ServiceCounterDataType this$totalRequestCount = this.getTotalRequestCount();
        ServiceCounterDataType other$totalRequestCount = other.getTotalRequestCount();
        if (this$totalRequestCount == null ? other$totalRequestCount != null : !((Object)this$totalRequestCount).equals(other$totalRequestCount)) {
            return false;
        }
        UInteger this$unauthorizedRequestCount = this.getUnauthorizedRequestCount();
        UInteger other$unauthorizedRequestCount = other.getUnauthorizedRequestCount();
        if (this$unauthorizedRequestCount == null ? other$unauthorizedRequestCount != null : !((Object)this$unauthorizedRequestCount).equals(other$unauthorizedRequestCount)) {
            return false;
        }
        ServiceCounterDataType this$readCount = this.getReadCount();
        ServiceCounterDataType other$readCount = other.getReadCount();
        if (this$readCount == null ? other$readCount != null : !((Object)this$readCount).equals(other$readCount)) {
            return false;
        }
        ServiceCounterDataType this$historyReadCount = this.getHistoryReadCount();
        ServiceCounterDataType other$historyReadCount = other.getHistoryReadCount();
        if (this$historyReadCount == null ? other$historyReadCount != null : !((Object)this$historyReadCount).equals(other$historyReadCount)) {
            return false;
        }
        ServiceCounterDataType this$writeCount = this.getWriteCount();
        ServiceCounterDataType other$writeCount = other.getWriteCount();
        if (this$writeCount == null ? other$writeCount != null : !((Object)this$writeCount).equals(other$writeCount)) {
            return false;
        }
        ServiceCounterDataType this$historyUpdateCount = this.getHistoryUpdateCount();
        ServiceCounterDataType other$historyUpdateCount = other.getHistoryUpdateCount();
        if (this$historyUpdateCount == null ? other$historyUpdateCount != null : !((Object)this$historyUpdateCount).equals(other$historyUpdateCount)) {
            return false;
        }
        ServiceCounterDataType this$callCount = this.getCallCount();
        ServiceCounterDataType other$callCount = other.getCallCount();
        if (this$callCount == null ? other$callCount != null : !((Object)this$callCount).equals(other$callCount)) {
            return false;
        }
        ServiceCounterDataType this$createMonitoredItemsCount = this.getCreateMonitoredItemsCount();
        ServiceCounterDataType other$createMonitoredItemsCount = other.getCreateMonitoredItemsCount();
        if (this$createMonitoredItemsCount == null ? other$createMonitoredItemsCount != null : !((Object)this$createMonitoredItemsCount).equals(other$createMonitoredItemsCount)) {
            return false;
        }
        ServiceCounterDataType this$modifyMonitoredItemsCount = this.getModifyMonitoredItemsCount();
        ServiceCounterDataType other$modifyMonitoredItemsCount = other.getModifyMonitoredItemsCount();
        if (this$modifyMonitoredItemsCount == null ? other$modifyMonitoredItemsCount != null : !((Object)this$modifyMonitoredItemsCount).equals(other$modifyMonitoredItemsCount)) {
            return false;
        }
        ServiceCounterDataType this$setMonitoringModeCount = this.getSetMonitoringModeCount();
        ServiceCounterDataType other$setMonitoringModeCount = other.getSetMonitoringModeCount();
        if (this$setMonitoringModeCount == null ? other$setMonitoringModeCount != null : !((Object)this$setMonitoringModeCount).equals(other$setMonitoringModeCount)) {
            return false;
        }
        ServiceCounterDataType this$setTriggeringCount = this.getSetTriggeringCount();
        ServiceCounterDataType other$setTriggeringCount = other.getSetTriggeringCount();
        if (this$setTriggeringCount == null ? other$setTriggeringCount != null : !((Object)this$setTriggeringCount).equals(other$setTriggeringCount)) {
            return false;
        }
        ServiceCounterDataType this$deleteMonitoredItemsCount = this.getDeleteMonitoredItemsCount();
        ServiceCounterDataType other$deleteMonitoredItemsCount = other.getDeleteMonitoredItemsCount();
        if (this$deleteMonitoredItemsCount == null ? other$deleteMonitoredItemsCount != null : !((Object)this$deleteMonitoredItemsCount).equals(other$deleteMonitoredItemsCount)) {
            return false;
        }
        ServiceCounterDataType this$createSubscriptionCount = this.getCreateSubscriptionCount();
        ServiceCounterDataType other$createSubscriptionCount = other.getCreateSubscriptionCount();
        if (this$createSubscriptionCount == null ? other$createSubscriptionCount != null : !((Object)this$createSubscriptionCount).equals(other$createSubscriptionCount)) {
            return false;
        }
        ServiceCounterDataType this$modifySubscriptionCount = this.getModifySubscriptionCount();
        ServiceCounterDataType other$modifySubscriptionCount = other.getModifySubscriptionCount();
        if (this$modifySubscriptionCount == null ? other$modifySubscriptionCount != null : !((Object)this$modifySubscriptionCount).equals(other$modifySubscriptionCount)) {
            return false;
        }
        ServiceCounterDataType this$setPublishingModeCount = this.getSetPublishingModeCount();
        ServiceCounterDataType other$setPublishingModeCount = other.getSetPublishingModeCount();
        if (this$setPublishingModeCount == null ? other$setPublishingModeCount != null : !((Object)this$setPublishingModeCount).equals(other$setPublishingModeCount)) {
            return false;
        }
        ServiceCounterDataType this$publishCount = this.getPublishCount();
        ServiceCounterDataType other$publishCount = other.getPublishCount();
        if (this$publishCount == null ? other$publishCount != null : !((Object)this$publishCount).equals(other$publishCount)) {
            return false;
        }
        ServiceCounterDataType this$republishCount = this.getRepublishCount();
        ServiceCounterDataType other$republishCount = other.getRepublishCount();
        if (this$republishCount == null ? other$republishCount != null : !((Object)this$republishCount).equals(other$republishCount)) {
            return false;
        }
        ServiceCounterDataType this$transferSubscriptionsCount = this.getTransferSubscriptionsCount();
        ServiceCounterDataType other$transferSubscriptionsCount = other.getTransferSubscriptionsCount();
        if (this$transferSubscriptionsCount == null ? other$transferSubscriptionsCount != null : !((Object)this$transferSubscriptionsCount).equals(other$transferSubscriptionsCount)) {
            return false;
        }
        ServiceCounterDataType this$deleteSubscriptionsCount = this.getDeleteSubscriptionsCount();
        ServiceCounterDataType other$deleteSubscriptionsCount = other.getDeleteSubscriptionsCount();
        if (this$deleteSubscriptionsCount == null ? other$deleteSubscriptionsCount != null : !((Object)this$deleteSubscriptionsCount).equals(other$deleteSubscriptionsCount)) {
            return false;
        }
        ServiceCounterDataType this$addNodesCount = this.getAddNodesCount();
        ServiceCounterDataType other$addNodesCount = other.getAddNodesCount();
        if (this$addNodesCount == null ? other$addNodesCount != null : !((Object)this$addNodesCount).equals(other$addNodesCount)) {
            return false;
        }
        ServiceCounterDataType this$addReferencesCount = this.getAddReferencesCount();
        ServiceCounterDataType other$addReferencesCount = other.getAddReferencesCount();
        if (this$addReferencesCount == null ? other$addReferencesCount != null : !((Object)this$addReferencesCount).equals(other$addReferencesCount)) {
            return false;
        }
        ServiceCounterDataType this$deleteNodesCount = this.getDeleteNodesCount();
        ServiceCounterDataType other$deleteNodesCount = other.getDeleteNodesCount();
        if (this$deleteNodesCount == null ? other$deleteNodesCount != null : !((Object)this$deleteNodesCount).equals(other$deleteNodesCount)) {
            return false;
        }
        ServiceCounterDataType this$deleteReferencesCount = this.getDeleteReferencesCount();
        ServiceCounterDataType other$deleteReferencesCount = other.getDeleteReferencesCount();
        if (this$deleteReferencesCount == null ? other$deleteReferencesCount != null : !((Object)this$deleteReferencesCount).equals(other$deleteReferencesCount)) {
            return false;
        }
        ServiceCounterDataType this$browseCount = this.getBrowseCount();
        ServiceCounterDataType other$browseCount = other.getBrowseCount();
        if (this$browseCount == null ? other$browseCount != null : !((Object)this$browseCount).equals(other$browseCount)) {
            return false;
        }
        ServiceCounterDataType this$browseNextCount = this.getBrowseNextCount();
        ServiceCounterDataType other$browseNextCount = other.getBrowseNextCount();
        if (this$browseNextCount == null ? other$browseNextCount != null : !((Object)this$browseNextCount).equals(other$browseNextCount)) {
            return false;
        }
        ServiceCounterDataType this$translateBrowsePathsToNodeIdsCount = this.getTranslateBrowsePathsToNodeIdsCount();
        ServiceCounterDataType other$translateBrowsePathsToNodeIdsCount = other.getTranslateBrowsePathsToNodeIdsCount();
        if (this$translateBrowsePathsToNodeIdsCount == null ? other$translateBrowsePathsToNodeIdsCount != null : !((Object)this$translateBrowsePathsToNodeIdsCount).equals(other$translateBrowsePathsToNodeIdsCount)) {
            return false;
        }
        ServiceCounterDataType this$queryFirstCount = this.getQueryFirstCount();
        ServiceCounterDataType other$queryFirstCount = other.getQueryFirstCount();
        if (this$queryFirstCount == null ? other$queryFirstCount != null : !((Object)this$queryFirstCount).equals(other$queryFirstCount)) {
            return false;
        }
        ServiceCounterDataType this$queryNextCount = this.getQueryNextCount();
        ServiceCounterDataType other$queryNextCount = other.getQueryNextCount();
        if (this$queryNextCount == null ? other$queryNextCount != null : !((Object)this$queryNextCount).equals(other$queryNextCount)) {
            return false;
        }
        ServiceCounterDataType this$registerNodesCount = this.getRegisterNodesCount();
        ServiceCounterDataType other$registerNodesCount = other.getRegisterNodesCount();
        if (this$registerNodesCount == null ? other$registerNodesCount != null : !((Object)this$registerNodesCount).equals(other$registerNodesCount)) {
            return false;
        }
        ServiceCounterDataType this$unregisterNodesCount = this.getUnregisterNodesCount();
        ServiceCounterDataType other$unregisterNodesCount = other.getUnregisterNodesCount();
        return !(this$unregisterNodesCount == null ? other$unregisterNodesCount != null : !((Object)this$unregisterNodesCount).equals(other$unregisterNodesCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SessionDiagnosticsDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $actualSessionTimeout = this.getActualSessionTimeout();
        result = result * 59 + ($actualSessionTimeout == null ? 43 : ((Object)$actualSessionTimeout).hashCode());
        NodeId $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        String $sessionName = this.getSessionName();
        result = result * 59 + ($sessionName == null ? 43 : $sessionName.hashCode());
        ApplicationDescription $clientDescription = this.getClientDescription();
        result = result * 59 + ($clientDescription == null ? 43 : ((Object)$clientDescription).hashCode());
        String $serverUri = this.getServerUri();
        result = result * 59 + ($serverUri == null ? 43 : $serverUri.hashCode());
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLocaleIds());
        UInteger $maxResponseMessageSize = this.getMaxResponseMessageSize();
        result = result * 59 + ($maxResponseMessageSize == null ? 43 : ((Object)$maxResponseMessageSize).hashCode());
        DateTime $clientConnectionTime = this.getClientConnectionTime();
        result = result * 59 + ($clientConnectionTime == null ? 43 : ((Object)$clientConnectionTime).hashCode());
        DateTime $clientLastContactTime = this.getClientLastContactTime();
        result = result * 59 + ($clientLastContactTime == null ? 43 : ((Object)$clientLastContactTime).hashCode());
        UInteger $currentSubscriptionsCount = this.getCurrentSubscriptionsCount();
        result = result * 59 + ($currentSubscriptionsCount == null ? 43 : ((Object)$currentSubscriptionsCount).hashCode());
        UInteger $currentMonitoredItemsCount = this.getCurrentMonitoredItemsCount();
        result = result * 59 + ($currentMonitoredItemsCount == null ? 43 : ((Object)$currentMonitoredItemsCount).hashCode());
        UInteger $currentPublishRequestsInQueue = this.getCurrentPublishRequestsInQueue();
        result = result * 59 + ($currentPublishRequestsInQueue == null ? 43 : ((Object)$currentPublishRequestsInQueue).hashCode());
        ServiceCounterDataType $totalRequestCount = this.getTotalRequestCount();
        result = result * 59 + ($totalRequestCount == null ? 43 : ((Object)$totalRequestCount).hashCode());
        UInteger $unauthorizedRequestCount = this.getUnauthorizedRequestCount();
        result = result * 59 + ($unauthorizedRequestCount == null ? 43 : ((Object)$unauthorizedRequestCount).hashCode());
        ServiceCounterDataType $readCount = this.getReadCount();
        result = result * 59 + ($readCount == null ? 43 : ((Object)$readCount).hashCode());
        ServiceCounterDataType $historyReadCount = this.getHistoryReadCount();
        result = result * 59 + ($historyReadCount == null ? 43 : ((Object)$historyReadCount).hashCode());
        ServiceCounterDataType $writeCount = this.getWriteCount();
        result = result * 59 + ($writeCount == null ? 43 : ((Object)$writeCount).hashCode());
        ServiceCounterDataType $historyUpdateCount = this.getHistoryUpdateCount();
        result = result * 59 + ($historyUpdateCount == null ? 43 : ((Object)$historyUpdateCount).hashCode());
        ServiceCounterDataType $callCount = this.getCallCount();
        result = result * 59 + ($callCount == null ? 43 : ((Object)$callCount).hashCode());
        ServiceCounterDataType $createMonitoredItemsCount = this.getCreateMonitoredItemsCount();
        result = result * 59 + ($createMonitoredItemsCount == null ? 43 : ((Object)$createMonitoredItemsCount).hashCode());
        ServiceCounterDataType $modifyMonitoredItemsCount = this.getModifyMonitoredItemsCount();
        result = result * 59 + ($modifyMonitoredItemsCount == null ? 43 : ((Object)$modifyMonitoredItemsCount).hashCode());
        ServiceCounterDataType $setMonitoringModeCount = this.getSetMonitoringModeCount();
        result = result * 59 + ($setMonitoringModeCount == null ? 43 : ((Object)$setMonitoringModeCount).hashCode());
        ServiceCounterDataType $setTriggeringCount = this.getSetTriggeringCount();
        result = result * 59 + ($setTriggeringCount == null ? 43 : ((Object)$setTriggeringCount).hashCode());
        ServiceCounterDataType $deleteMonitoredItemsCount = this.getDeleteMonitoredItemsCount();
        result = result * 59 + ($deleteMonitoredItemsCount == null ? 43 : ((Object)$deleteMonitoredItemsCount).hashCode());
        ServiceCounterDataType $createSubscriptionCount = this.getCreateSubscriptionCount();
        result = result * 59 + ($createSubscriptionCount == null ? 43 : ((Object)$createSubscriptionCount).hashCode());
        ServiceCounterDataType $modifySubscriptionCount = this.getModifySubscriptionCount();
        result = result * 59 + ($modifySubscriptionCount == null ? 43 : ((Object)$modifySubscriptionCount).hashCode());
        ServiceCounterDataType $setPublishingModeCount = this.getSetPublishingModeCount();
        result = result * 59 + ($setPublishingModeCount == null ? 43 : ((Object)$setPublishingModeCount).hashCode());
        ServiceCounterDataType $publishCount = this.getPublishCount();
        result = result * 59 + ($publishCount == null ? 43 : ((Object)$publishCount).hashCode());
        ServiceCounterDataType $republishCount = this.getRepublishCount();
        result = result * 59 + ($republishCount == null ? 43 : ((Object)$republishCount).hashCode());
        ServiceCounterDataType $transferSubscriptionsCount = this.getTransferSubscriptionsCount();
        result = result * 59 + ($transferSubscriptionsCount == null ? 43 : ((Object)$transferSubscriptionsCount).hashCode());
        ServiceCounterDataType $deleteSubscriptionsCount = this.getDeleteSubscriptionsCount();
        result = result * 59 + ($deleteSubscriptionsCount == null ? 43 : ((Object)$deleteSubscriptionsCount).hashCode());
        ServiceCounterDataType $addNodesCount = this.getAddNodesCount();
        result = result * 59 + ($addNodesCount == null ? 43 : ((Object)$addNodesCount).hashCode());
        ServiceCounterDataType $addReferencesCount = this.getAddReferencesCount();
        result = result * 59 + ($addReferencesCount == null ? 43 : ((Object)$addReferencesCount).hashCode());
        ServiceCounterDataType $deleteNodesCount = this.getDeleteNodesCount();
        result = result * 59 + ($deleteNodesCount == null ? 43 : ((Object)$deleteNodesCount).hashCode());
        ServiceCounterDataType $deleteReferencesCount = this.getDeleteReferencesCount();
        result = result * 59 + ($deleteReferencesCount == null ? 43 : ((Object)$deleteReferencesCount).hashCode());
        ServiceCounterDataType $browseCount = this.getBrowseCount();
        result = result * 59 + ($browseCount == null ? 43 : ((Object)$browseCount).hashCode());
        ServiceCounterDataType $browseNextCount = this.getBrowseNextCount();
        result = result * 59 + ($browseNextCount == null ? 43 : ((Object)$browseNextCount).hashCode());
        ServiceCounterDataType $translateBrowsePathsToNodeIdsCount = this.getTranslateBrowsePathsToNodeIdsCount();
        result = result * 59 + ($translateBrowsePathsToNodeIdsCount == null ? 43 : ((Object)$translateBrowsePathsToNodeIdsCount).hashCode());
        ServiceCounterDataType $queryFirstCount = this.getQueryFirstCount();
        result = result * 59 + ($queryFirstCount == null ? 43 : ((Object)$queryFirstCount).hashCode());
        ServiceCounterDataType $queryNextCount = this.getQueryNextCount();
        result = result * 59 + ($queryNextCount == null ? 43 : ((Object)$queryNextCount).hashCode());
        ServiceCounterDataType $registerNodesCount = this.getRegisterNodesCount();
        result = result * 59 + ($registerNodesCount == null ? 43 : ((Object)$registerNodesCount).hashCode());
        ServiceCounterDataType $unregisterNodesCount = this.getUnregisterNodesCount();
        result = result * 59 + ($unregisterNodesCount == null ? 43 : ((Object)$unregisterNodesCount).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SessionDiagnosticsDataType(sessionId=" + this.getSessionId() + ", sessionName=" + this.getSessionName() + ", clientDescription=" + this.getClientDescription() + ", serverUri=" + this.getServerUri() + ", endpointUrl=" + this.getEndpointUrl() + ", localeIds=" + Arrays.deepToString(this.getLocaleIds()) + ", actualSessionTimeout=" + this.getActualSessionTimeout() + ", maxResponseMessageSize=" + this.getMaxResponseMessageSize() + ", clientConnectionTime=" + this.getClientConnectionTime() + ", clientLastContactTime=" + this.getClientLastContactTime() + ", currentSubscriptionsCount=" + this.getCurrentSubscriptionsCount() + ", currentMonitoredItemsCount=" + this.getCurrentMonitoredItemsCount() + ", currentPublishRequestsInQueue=" + this.getCurrentPublishRequestsInQueue() + ", totalRequestCount=" + this.getTotalRequestCount() + ", unauthorizedRequestCount=" + this.getUnauthorizedRequestCount() + ", readCount=" + this.getReadCount() + ", historyReadCount=" + this.getHistoryReadCount() + ", writeCount=" + this.getWriteCount() + ", historyUpdateCount=" + this.getHistoryUpdateCount() + ", callCount=" + this.getCallCount() + ", createMonitoredItemsCount=" + this.getCreateMonitoredItemsCount() + ", modifyMonitoredItemsCount=" + this.getModifyMonitoredItemsCount() + ", setMonitoringModeCount=" + this.getSetMonitoringModeCount() + ", setTriggeringCount=" + this.getSetTriggeringCount() + ", deleteMonitoredItemsCount=" + this.getDeleteMonitoredItemsCount() + ", createSubscriptionCount=" + this.getCreateSubscriptionCount() + ", modifySubscriptionCount=" + this.getModifySubscriptionCount() + ", setPublishingModeCount=" + this.getSetPublishingModeCount() + ", publishCount=" + this.getPublishCount() + ", republishCount=" + this.getRepublishCount() + ", transferSubscriptionsCount=" + this.getTransferSubscriptionsCount() + ", deleteSubscriptionsCount=" + this.getDeleteSubscriptionsCount() + ", addNodesCount=" + this.getAddNodesCount() + ", addReferencesCount=" + this.getAddReferencesCount() + ", deleteNodesCount=" + this.getDeleteNodesCount() + ", deleteReferencesCount=" + this.getDeleteReferencesCount() + ", browseCount=" + this.getBrowseCount() + ", browseNextCount=" + this.getBrowseNextCount() + ", translateBrowsePathsToNodeIdsCount=" + this.getTranslateBrowsePathsToNodeIdsCount() + ", queryFirstCount=" + this.getQueryFirstCount() + ", queryNextCount=" + this.getQueryNextCount() + ", registerNodesCount=" + this.getRegisterNodesCount() + ", unregisterNodesCount=" + this.getUnregisterNodesCount() + ")";
    }

    private static final class SessionDiagnosticsDataTypeBuilderImpl
    extends SessionDiagnosticsDataTypeBuilder<SessionDiagnosticsDataType, SessionDiagnosticsDataTypeBuilderImpl> {
        private SessionDiagnosticsDataTypeBuilderImpl() {
        }

        @Override
        protected SessionDiagnosticsDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public SessionDiagnosticsDataType build() {
            return new SessionDiagnosticsDataType(this);
        }
    }

    public static abstract class SessionDiagnosticsDataTypeBuilder<C extends SessionDiagnosticsDataType, B extends SessionDiagnosticsDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId sessionId;
        private String sessionName;
        private ApplicationDescription clientDescription;
        private String serverUri;
        private String endpointUrl;
        private String[] localeIds;
        private Double actualSessionTimeout;
        private UInteger maxResponseMessageSize;
        private DateTime clientConnectionTime;
        private DateTime clientLastContactTime;
        private UInteger currentSubscriptionsCount;
        private UInteger currentMonitoredItemsCount;
        private UInteger currentPublishRequestsInQueue;
        private ServiceCounterDataType totalRequestCount;
        private UInteger unauthorizedRequestCount;
        private ServiceCounterDataType readCount;
        private ServiceCounterDataType historyReadCount;
        private ServiceCounterDataType writeCount;
        private ServiceCounterDataType historyUpdateCount;
        private ServiceCounterDataType callCount;
        private ServiceCounterDataType createMonitoredItemsCount;
        private ServiceCounterDataType modifyMonitoredItemsCount;
        private ServiceCounterDataType setMonitoringModeCount;
        private ServiceCounterDataType setTriggeringCount;
        private ServiceCounterDataType deleteMonitoredItemsCount;
        private ServiceCounterDataType createSubscriptionCount;
        private ServiceCounterDataType modifySubscriptionCount;
        private ServiceCounterDataType setPublishingModeCount;
        private ServiceCounterDataType publishCount;
        private ServiceCounterDataType republishCount;
        private ServiceCounterDataType transferSubscriptionsCount;
        private ServiceCounterDataType deleteSubscriptionsCount;
        private ServiceCounterDataType addNodesCount;
        private ServiceCounterDataType addReferencesCount;
        private ServiceCounterDataType deleteNodesCount;
        private ServiceCounterDataType deleteReferencesCount;
        private ServiceCounterDataType browseCount;
        private ServiceCounterDataType browseNextCount;
        private ServiceCounterDataType translateBrowsePathsToNodeIdsCount;
        private ServiceCounterDataType queryFirstCount;
        private ServiceCounterDataType queryNextCount;
        private ServiceCounterDataType registerNodesCount;
        private ServiceCounterDataType unregisterNodesCount;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SessionDiagnosticsDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SessionDiagnosticsDataType instance, SessionDiagnosticsDataTypeBuilder<?, ?> b) {
            b.sessionId(instance.sessionId);
            b.sessionName(instance.sessionName);
            b.clientDescription(instance.clientDescription);
            b.serverUri(instance.serverUri);
            b.endpointUrl(instance.endpointUrl);
            b.localeIds(instance.localeIds);
            b.actualSessionTimeout(instance.actualSessionTimeout);
            b.maxResponseMessageSize(instance.maxResponseMessageSize);
            b.clientConnectionTime(instance.clientConnectionTime);
            b.clientLastContactTime(instance.clientLastContactTime);
            b.currentSubscriptionsCount(instance.currentSubscriptionsCount);
            b.currentMonitoredItemsCount(instance.currentMonitoredItemsCount);
            b.currentPublishRequestsInQueue(instance.currentPublishRequestsInQueue);
            b.totalRequestCount(instance.totalRequestCount);
            b.unauthorizedRequestCount(instance.unauthorizedRequestCount);
            b.readCount(instance.readCount);
            b.historyReadCount(instance.historyReadCount);
            b.writeCount(instance.writeCount);
            b.historyUpdateCount(instance.historyUpdateCount);
            b.callCount(instance.callCount);
            b.createMonitoredItemsCount(instance.createMonitoredItemsCount);
            b.modifyMonitoredItemsCount(instance.modifyMonitoredItemsCount);
            b.setMonitoringModeCount(instance.setMonitoringModeCount);
            b.setTriggeringCount(instance.setTriggeringCount);
            b.deleteMonitoredItemsCount(instance.deleteMonitoredItemsCount);
            b.createSubscriptionCount(instance.createSubscriptionCount);
            b.modifySubscriptionCount(instance.modifySubscriptionCount);
            b.setPublishingModeCount(instance.setPublishingModeCount);
            b.publishCount(instance.publishCount);
            b.republishCount(instance.republishCount);
            b.transferSubscriptionsCount(instance.transferSubscriptionsCount);
            b.deleteSubscriptionsCount(instance.deleteSubscriptionsCount);
            b.addNodesCount(instance.addNodesCount);
            b.addReferencesCount(instance.addReferencesCount);
            b.deleteNodesCount(instance.deleteNodesCount);
            b.deleteReferencesCount(instance.deleteReferencesCount);
            b.browseCount(instance.browseCount);
            b.browseNextCount(instance.browseNextCount);
            b.translateBrowsePathsToNodeIdsCount(instance.translateBrowsePathsToNodeIdsCount);
            b.queryFirstCount(instance.queryFirstCount);
            b.queryNextCount(instance.queryNextCount);
            b.registerNodesCount(instance.registerNodesCount);
            b.unregisterNodesCount(instance.unregisterNodesCount);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B sessionId(NodeId sessionId) {
            this.sessionId = sessionId;
            return (B)this.self();
        }

        public B sessionName(String sessionName) {
            this.sessionName = sessionName;
            return (B)this.self();
        }

        public B clientDescription(ApplicationDescription clientDescription) {
            this.clientDescription = clientDescription;
            return (B)this.self();
        }

        public B serverUri(String serverUri) {
            this.serverUri = serverUri;
            return (B)this.self();
        }

        public B endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return (B)this.self();
        }

        public B localeIds(String[] localeIds) {
            this.localeIds = localeIds;
            return (B)this.self();
        }

        public B actualSessionTimeout(Double actualSessionTimeout) {
            this.actualSessionTimeout = actualSessionTimeout;
            return (B)this.self();
        }

        public B maxResponseMessageSize(UInteger maxResponseMessageSize) {
            this.maxResponseMessageSize = maxResponseMessageSize;
            return (B)this.self();
        }

        public B clientConnectionTime(DateTime clientConnectionTime) {
            this.clientConnectionTime = clientConnectionTime;
            return (B)this.self();
        }

        public B clientLastContactTime(DateTime clientLastContactTime) {
            this.clientLastContactTime = clientLastContactTime;
            return (B)this.self();
        }

        public B currentSubscriptionsCount(UInteger currentSubscriptionsCount) {
            this.currentSubscriptionsCount = currentSubscriptionsCount;
            return (B)this.self();
        }

        public B currentMonitoredItemsCount(UInteger currentMonitoredItemsCount) {
            this.currentMonitoredItemsCount = currentMonitoredItemsCount;
            return (B)this.self();
        }

        public B currentPublishRequestsInQueue(UInteger currentPublishRequestsInQueue) {
            this.currentPublishRequestsInQueue = currentPublishRequestsInQueue;
            return (B)this.self();
        }

        public B totalRequestCount(ServiceCounterDataType totalRequestCount) {
            this.totalRequestCount = totalRequestCount;
            return (B)this.self();
        }

        public B unauthorizedRequestCount(UInteger unauthorizedRequestCount) {
            this.unauthorizedRequestCount = unauthorizedRequestCount;
            return (B)this.self();
        }

        public B readCount(ServiceCounterDataType readCount) {
            this.readCount = readCount;
            return (B)this.self();
        }

        public B historyReadCount(ServiceCounterDataType historyReadCount) {
            this.historyReadCount = historyReadCount;
            return (B)this.self();
        }

        public B writeCount(ServiceCounterDataType writeCount) {
            this.writeCount = writeCount;
            return (B)this.self();
        }

        public B historyUpdateCount(ServiceCounterDataType historyUpdateCount) {
            this.historyUpdateCount = historyUpdateCount;
            return (B)this.self();
        }

        public B callCount(ServiceCounterDataType callCount) {
            this.callCount = callCount;
            return (B)this.self();
        }

        public B createMonitoredItemsCount(ServiceCounterDataType createMonitoredItemsCount) {
            this.createMonitoredItemsCount = createMonitoredItemsCount;
            return (B)this.self();
        }

        public B modifyMonitoredItemsCount(ServiceCounterDataType modifyMonitoredItemsCount) {
            this.modifyMonitoredItemsCount = modifyMonitoredItemsCount;
            return (B)this.self();
        }

        public B setMonitoringModeCount(ServiceCounterDataType setMonitoringModeCount) {
            this.setMonitoringModeCount = setMonitoringModeCount;
            return (B)this.self();
        }

        public B setTriggeringCount(ServiceCounterDataType setTriggeringCount) {
            this.setTriggeringCount = setTriggeringCount;
            return (B)this.self();
        }

        public B deleteMonitoredItemsCount(ServiceCounterDataType deleteMonitoredItemsCount) {
            this.deleteMonitoredItemsCount = deleteMonitoredItemsCount;
            return (B)this.self();
        }

        public B createSubscriptionCount(ServiceCounterDataType createSubscriptionCount) {
            this.createSubscriptionCount = createSubscriptionCount;
            return (B)this.self();
        }

        public B modifySubscriptionCount(ServiceCounterDataType modifySubscriptionCount) {
            this.modifySubscriptionCount = modifySubscriptionCount;
            return (B)this.self();
        }

        public B setPublishingModeCount(ServiceCounterDataType setPublishingModeCount) {
            this.setPublishingModeCount = setPublishingModeCount;
            return (B)this.self();
        }

        public B publishCount(ServiceCounterDataType publishCount) {
            this.publishCount = publishCount;
            return (B)this.self();
        }

        public B republishCount(ServiceCounterDataType republishCount) {
            this.republishCount = republishCount;
            return (B)this.self();
        }

        public B transferSubscriptionsCount(ServiceCounterDataType transferSubscriptionsCount) {
            this.transferSubscriptionsCount = transferSubscriptionsCount;
            return (B)this.self();
        }

        public B deleteSubscriptionsCount(ServiceCounterDataType deleteSubscriptionsCount) {
            this.deleteSubscriptionsCount = deleteSubscriptionsCount;
            return (B)this.self();
        }

        public B addNodesCount(ServiceCounterDataType addNodesCount) {
            this.addNodesCount = addNodesCount;
            return (B)this.self();
        }

        public B addReferencesCount(ServiceCounterDataType addReferencesCount) {
            this.addReferencesCount = addReferencesCount;
            return (B)this.self();
        }

        public B deleteNodesCount(ServiceCounterDataType deleteNodesCount) {
            this.deleteNodesCount = deleteNodesCount;
            return (B)this.self();
        }

        public B deleteReferencesCount(ServiceCounterDataType deleteReferencesCount) {
            this.deleteReferencesCount = deleteReferencesCount;
            return (B)this.self();
        }

        public B browseCount(ServiceCounterDataType browseCount) {
            this.browseCount = browseCount;
            return (B)this.self();
        }

        public B browseNextCount(ServiceCounterDataType browseNextCount) {
            this.browseNextCount = browseNextCount;
            return (B)this.self();
        }

        public B translateBrowsePathsToNodeIdsCount(ServiceCounterDataType translateBrowsePathsToNodeIdsCount) {
            this.translateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount;
            return (B)this.self();
        }

        public B queryFirstCount(ServiceCounterDataType queryFirstCount) {
            this.queryFirstCount = queryFirstCount;
            return (B)this.self();
        }

        public B queryNextCount(ServiceCounterDataType queryNextCount) {
            this.queryNextCount = queryNextCount;
            return (B)this.self();
        }

        public B registerNodesCount(ServiceCounterDataType registerNodesCount) {
            this.registerNodesCount = registerNodesCount;
            return (B)this.self();
        }

        public B unregisterNodesCount(ServiceCounterDataType unregisterNodesCount) {
            this.unregisterNodesCount = unregisterNodesCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SessionDiagnosticsDataType.SessionDiagnosticsDataTypeBuilder(super=" + super.toString() + ", sessionId=" + this.sessionId + ", sessionName=" + this.sessionName + ", clientDescription=" + this.clientDescription + ", serverUri=" + this.serverUri + ", endpointUrl=" + this.endpointUrl + ", localeIds=" + Arrays.deepToString(this.localeIds) + ", actualSessionTimeout=" + this.actualSessionTimeout + ", maxResponseMessageSize=" + this.maxResponseMessageSize + ", clientConnectionTime=" + this.clientConnectionTime + ", clientLastContactTime=" + this.clientLastContactTime + ", currentSubscriptionsCount=" + this.currentSubscriptionsCount + ", currentMonitoredItemsCount=" + this.currentMonitoredItemsCount + ", currentPublishRequestsInQueue=" + this.currentPublishRequestsInQueue + ", totalRequestCount=" + this.totalRequestCount + ", unauthorizedRequestCount=" + this.unauthorizedRequestCount + ", readCount=" + this.readCount + ", historyReadCount=" + this.historyReadCount + ", writeCount=" + this.writeCount + ", historyUpdateCount=" + this.historyUpdateCount + ", callCount=" + this.callCount + ", createMonitoredItemsCount=" + this.createMonitoredItemsCount + ", modifyMonitoredItemsCount=" + this.modifyMonitoredItemsCount + ", setMonitoringModeCount=" + this.setMonitoringModeCount + ", setTriggeringCount=" + this.setTriggeringCount + ", deleteMonitoredItemsCount=" + this.deleteMonitoredItemsCount + ", createSubscriptionCount=" + this.createSubscriptionCount + ", modifySubscriptionCount=" + this.modifySubscriptionCount + ", setPublishingModeCount=" + this.setPublishingModeCount + ", publishCount=" + this.publishCount + ", republishCount=" + this.republishCount + ", transferSubscriptionsCount=" + this.transferSubscriptionsCount + ", deleteSubscriptionsCount=" + this.deleteSubscriptionsCount + ", addNodesCount=" + this.addNodesCount + ", addReferencesCount=" + this.addReferencesCount + ", deleteNodesCount=" + this.deleteNodesCount + ", deleteReferencesCount=" + this.deleteReferencesCount + ", browseCount=" + this.browseCount + ", browseNextCount=" + this.browseNextCount + ", translateBrowsePathsToNodeIdsCount=" + this.translateBrowsePathsToNodeIdsCount + ", queryFirstCount=" + this.queryFirstCount + ", queryNextCount=" + this.queryNextCount + ", registerNodesCount=" + this.registerNodesCount + ", unregisterNodesCount=" + this.unregisterNodesCount + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SessionDiagnosticsDataType> {
        @Override
        public Class<SessionDiagnosticsDataType> getType() {
            return SessionDiagnosticsDataType.class;
        }

        @Override
        public SessionDiagnosticsDataType decode(SerializationContext context, UaDecoder decoder) {
            NodeId sessionId = decoder.readNodeId("SessionId");
            String sessionName = decoder.readString("SessionName");
            ApplicationDescription clientDescription = (ApplicationDescription)decoder.readStruct("ClientDescription", ApplicationDescription.TYPE_ID);
            String serverUri = decoder.readString("ServerUri");
            String endpointUrl = decoder.readString("EndpointUrl");
            String[] localeIds = decoder.readStringArray("LocaleIds");
            Double actualSessionTimeout = decoder.readDouble("ActualSessionTimeout");
            UInteger maxResponseMessageSize = decoder.readUInt32("MaxResponseMessageSize");
            DateTime clientConnectionTime = decoder.readDateTime("ClientConnectionTime");
            DateTime clientLastContactTime = decoder.readDateTime("ClientLastContactTime");
            UInteger currentSubscriptionsCount = decoder.readUInt32("CurrentSubscriptionsCount");
            UInteger currentMonitoredItemsCount = decoder.readUInt32("CurrentMonitoredItemsCount");
            UInteger currentPublishRequestsInQueue = decoder.readUInt32("CurrentPublishRequestsInQueue");
            ServiceCounterDataType totalRequestCount = (ServiceCounterDataType)decoder.readStruct("TotalRequestCount", ServiceCounterDataType.TYPE_ID);
            UInteger unauthorizedRequestCount = decoder.readUInt32("UnauthorizedRequestCount");
            ServiceCounterDataType readCount = (ServiceCounterDataType)decoder.readStruct("ReadCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType historyReadCount = (ServiceCounterDataType)decoder.readStruct("HistoryReadCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType writeCount = (ServiceCounterDataType)decoder.readStruct("WriteCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType historyUpdateCount = (ServiceCounterDataType)decoder.readStruct("HistoryUpdateCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType callCount = (ServiceCounterDataType)decoder.readStruct("CallCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType createMonitoredItemsCount = (ServiceCounterDataType)decoder.readStruct("CreateMonitoredItemsCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType modifyMonitoredItemsCount = (ServiceCounterDataType)decoder.readStruct("ModifyMonitoredItemsCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType setMonitoringModeCount = (ServiceCounterDataType)decoder.readStruct("SetMonitoringModeCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType setTriggeringCount = (ServiceCounterDataType)decoder.readStruct("SetTriggeringCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType deleteMonitoredItemsCount = (ServiceCounterDataType)decoder.readStruct("DeleteMonitoredItemsCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType createSubscriptionCount = (ServiceCounterDataType)decoder.readStruct("CreateSubscriptionCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType modifySubscriptionCount = (ServiceCounterDataType)decoder.readStruct("ModifySubscriptionCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType setPublishingModeCount = (ServiceCounterDataType)decoder.readStruct("SetPublishingModeCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType publishCount = (ServiceCounterDataType)decoder.readStruct("PublishCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType republishCount = (ServiceCounterDataType)decoder.readStruct("RepublishCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType transferSubscriptionsCount = (ServiceCounterDataType)decoder.readStruct("TransferSubscriptionsCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType deleteSubscriptionsCount = (ServiceCounterDataType)decoder.readStruct("DeleteSubscriptionsCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType addNodesCount = (ServiceCounterDataType)decoder.readStruct("AddNodesCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType addReferencesCount = (ServiceCounterDataType)decoder.readStruct("AddReferencesCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType deleteNodesCount = (ServiceCounterDataType)decoder.readStruct("DeleteNodesCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType deleteReferencesCount = (ServiceCounterDataType)decoder.readStruct("DeleteReferencesCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType browseCount = (ServiceCounterDataType)decoder.readStruct("BrowseCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType browseNextCount = (ServiceCounterDataType)decoder.readStruct("BrowseNextCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType translateBrowsePathsToNodeIdsCount = (ServiceCounterDataType)decoder.readStruct("TranslateBrowsePathsToNodeIdsCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType queryFirstCount = (ServiceCounterDataType)decoder.readStruct("QueryFirstCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType queryNextCount = (ServiceCounterDataType)decoder.readStruct("QueryNextCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType registerNodesCount = (ServiceCounterDataType)decoder.readStruct("RegisterNodesCount", ServiceCounterDataType.TYPE_ID);
            ServiceCounterDataType unregisterNodesCount = (ServiceCounterDataType)decoder.readStruct("UnregisterNodesCount", ServiceCounterDataType.TYPE_ID);
            return new SessionDiagnosticsDataType(sessionId, sessionName, clientDescription, serverUri, endpointUrl, localeIds, actualSessionTimeout, maxResponseMessageSize, clientConnectionTime, clientLastContactTime, currentSubscriptionsCount, currentMonitoredItemsCount, currentPublishRequestsInQueue, totalRequestCount, unauthorizedRequestCount, readCount, historyReadCount, writeCount, historyUpdateCount, callCount, createMonitoredItemsCount, modifyMonitoredItemsCount, setMonitoringModeCount, setTriggeringCount, deleteMonitoredItemsCount, createSubscriptionCount, modifySubscriptionCount, setPublishingModeCount, publishCount, republishCount, transferSubscriptionsCount, deleteSubscriptionsCount, addNodesCount, addReferencesCount, deleteNodesCount, deleteReferencesCount, browseCount, browseNextCount, translateBrowsePathsToNodeIdsCount, queryFirstCount, queryNextCount, registerNodesCount, unregisterNodesCount);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SessionDiagnosticsDataType value) {
            encoder.writeNodeId("SessionId", value.getSessionId());
            encoder.writeString("SessionName", value.getSessionName());
            encoder.writeStruct("ClientDescription", (Object)value.getClientDescription(), ApplicationDescription.TYPE_ID);
            encoder.writeString("ServerUri", value.getServerUri());
            encoder.writeString("EndpointUrl", value.getEndpointUrl());
            encoder.writeStringArray("LocaleIds", value.getLocaleIds());
            encoder.writeDouble("ActualSessionTimeout", value.getActualSessionTimeout());
            encoder.writeUInt32("MaxResponseMessageSize", value.getMaxResponseMessageSize());
            encoder.writeDateTime("ClientConnectionTime", value.getClientConnectionTime());
            encoder.writeDateTime("ClientLastContactTime", value.getClientLastContactTime());
            encoder.writeUInt32("CurrentSubscriptionsCount", value.getCurrentSubscriptionsCount());
            encoder.writeUInt32("CurrentMonitoredItemsCount", value.getCurrentMonitoredItemsCount());
            encoder.writeUInt32("CurrentPublishRequestsInQueue", value.getCurrentPublishRequestsInQueue());
            encoder.writeStruct("TotalRequestCount", (Object)value.getTotalRequestCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeUInt32("UnauthorizedRequestCount", value.getUnauthorizedRequestCount());
            encoder.writeStruct("ReadCount", (Object)value.getReadCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("HistoryReadCount", (Object)value.getHistoryReadCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("WriteCount", (Object)value.getWriteCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("HistoryUpdateCount", (Object)value.getHistoryUpdateCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("CallCount", (Object)value.getCallCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("CreateMonitoredItemsCount", (Object)value.getCreateMonitoredItemsCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("ModifyMonitoredItemsCount", (Object)value.getModifyMonitoredItemsCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("SetMonitoringModeCount", (Object)value.getSetMonitoringModeCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("SetTriggeringCount", (Object)value.getSetTriggeringCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("DeleteMonitoredItemsCount", (Object)value.getDeleteMonitoredItemsCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("CreateSubscriptionCount", (Object)value.getCreateSubscriptionCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("ModifySubscriptionCount", (Object)value.getModifySubscriptionCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("SetPublishingModeCount", (Object)value.getSetPublishingModeCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("PublishCount", (Object)value.getPublishCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("RepublishCount", (Object)value.getRepublishCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("TransferSubscriptionsCount", (Object)value.getTransferSubscriptionsCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("DeleteSubscriptionsCount", (Object)value.getDeleteSubscriptionsCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("AddNodesCount", (Object)value.getAddNodesCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("AddReferencesCount", (Object)value.getAddReferencesCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("DeleteNodesCount", (Object)value.getDeleteNodesCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("DeleteReferencesCount", (Object)value.getDeleteReferencesCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("BrowseCount", (Object)value.getBrowseCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("BrowseNextCount", (Object)value.getBrowseNextCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("TranslateBrowsePathsToNodeIdsCount", (Object)value.getTranslateBrowsePathsToNodeIdsCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("QueryFirstCount", (Object)value.getQueryFirstCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("QueryNextCount", (Object)value.getQueryNextCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("RegisterNodesCount", (Object)value.getRegisterNodesCount(), ServiceCounterDataType.TYPE_ID);
            encoder.writeStruct("UnregisterNodesCount", (Object)value.getUnregisterNodesCount(), ServiceCounterDataType.TYPE_ID);
        }
    }
}

