/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.service;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.commons.file.SystemFileFactory;

public class UDFClassLoader
extends URLClassLoader {
    private final String libRoot;
    private final AtomicLong activeQueriesCount;
    private volatile boolean deprecated;

    public UDFClassLoader(String libRoot) throws IOException {
        super(new URL[0]);
        this.libRoot = libRoot;
        this.activeQueriesCount = new AtomicLong(0L);
        this.deprecated = false;
        this.addURLs();
    }

    private void addURLs() throws IOException {
        try (Stream<Path> pathStream = Files.walk(SystemFileFactory.INSTANCE.getFile(this.libRoot).toPath(), new FileVisitOption[0]);){
            for (Path path2 : pathStream.filter(path -> !path.toFile().isDirectory()).collect(Collectors.toList())) {
                super.addURL(path2.toUri().toURL());
            }
        }
    }

    public void acquire() {
        this.activeQueriesCount.incrementAndGet();
    }

    public void release() throws IOException {
        this.activeQueriesCount.decrementAndGet();
        this.closeIfPossible();
    }

    public void markAsDeprecated() throws IOException {
        this.deprecated = true;
        this.closeIfPossible();
    }

    public void closeIfPossible() throws IOException {
        if (this.deprecated && this.activeQueriesCount.get() == 0L) {
            this.close();
        }
    }
}

