/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.builtin.UDTFEqualSizeBucketSample;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.exception.UDFParameterNotValidException;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.utils.Pair;

public class UDTFEqualSizeBucketOutlierSample
extends UDTFEqualSizeBucketSample {
    private String type;
    private int number;
    private OutlierSampler outlierSampler;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException, MetadataException {
        super.validate(validator);
        this.type = validator.getParameters().getStringOrDefault("type", "avg").toLowerCase();
        this.number = validator.getParameters().getIntOrDefault("number", 3);
        validator.validate(type -> "avg".equals(type) || "stendis".equals(type) || "cos".equals(type) || "prenextdis".equals(type), "Illegal outlier method. Outlier type should be avg, stendis, cos or prenextdis.", (Object)this.type).validate(number -> (Integer)number > 0, "Illegal number. Number should be greater than 0.", (Object)this.number);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.bucketSize *= this.number;
        configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(this.bucketSize)).setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(this.dataType));
        switch (this.type) {
            case "avg": {
                this.outlierSampler = new AvgOutlierSampler();
                break;
            }
            case "stendis": {
                this.outlierSampler = new StendisOutlierSampler();
                break;
            }
            case "cos": {
                this.outlierSampler = new CosOutlierSampler();
                break;
            }
            case "prenextdis": {
                this.outlierSampler = new PrenextdisOutlierSampler();
                break;
            }
            default: {
                throw new UDFParameterNotValidException("Illegal outlier method. Outlier type should be avg, stendis, cos or prenextdis.");
            }
        }
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws IOException, UDFParameterNotValidException {
        switch (this.dataType) {
            case INT32: {
                this.outlierSampler.outlierSampleInt(rowWindow, collector);
                break;
            }
            case INT64: {
                this.outlierSampler.outlierSampleLong(rowWindow, collector);
                break;
            }
            case FLOAT: {
                this.outlierSampler.outlierSampleFloat(rowWindow, collector);
                break;
            }
            case DOUBLE: {
                this.outlierSampler.outlierSampleDouble(rowWindow, collector);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
    }

    public void addToMinHeap(PriorityQueue<Pair<Integer, Double>> pq, int i, double value) {
        if (pq.size() < this.number) {
            pq.add((Pair<Integer, Double>)new Pair((Object)i, (Object)value));
        } else if (value > (Double)pq.peek().right) {
            pq.poll();
            pq.add((Pair<Integer, Double>)new Pair((Object)i, (Object)value));
        }
    }

    public void addToMaxHeap(PriorityQueue<Pair<Integer, Double>> pq, int i, double value) {
        if (pq.size() < this.number) {
            pq.add((Pair<Integer, Double>)new Pair((Object)i, (Object)value));
        } else if (value < (Double)pq.peek().right) {
            pq.poll();
            pq.add((Pair<Integer, Double>)new Pair((Object)i, (Object)value));
        }
    }

    public void putPQValueInt(PriorityQueue<Pair<Integer, Double>> pq, RowWindow rowWindow, PointCollector collector) throws IOException {
        int i;
        int[] arr = new int[this.number];
        for (i = 0; i < this.number; ++i) {
            arr[i] = (Integer)pq.peek().left;
            pq.poll();
        }
        Arrays.sort(arr);
        for (i = 0; i < this.number; ++i) {
            collector.putInt(rowWindow.getRow(arr[i]).getTime(), rowWindow.getRow(arr[i]).getInt(0));
        }
    }

    public void putPQValueLong(PriorityQueue<Pair<Integer, Double>> pq, RowWindow rowWindow, PointCollector collector) throws IOException {
        int i;
        int[] arr = new int[this.number];
        for (i = 0; i < this.number; ++i) {
            arr[i] = (Integer)pq.peek().left;
            pq.poll();
        }
        Arrays.sort(arr);
        for (i = 0; i < this.number; ++i) {
            collector.putLong(rowWindow.getRow(arr[i]).getTime(), rowWindow.getRow(arr[i]).getLong(0));
        }
    }

    public void putPQValueFloat(PriorityQueue<Pair<Integer, Double>> pq, RowWindow rowWindow, PointCollector collector) throws IOException {
        int i;
        int[] arr = new int[this.number];
        for (i = 0; i < this.number; ++i) {
            arr[i] = (Integer)pq.peek().left;
            pq.poll();
        }
        Arrays.sort(arr);
        for (i = 0; i < this.number; ++i) {
            collector.putFloat(rowWindow.getRow(arr[i]).getTime(), rowWindow.getRow(arr[i]).getFloat(0));
        }
    }

    public void putPQValueDouble(PriorityQueue<Pair<Integer, Double>> pq, RowWindow rowWindow, PointCollector collector) throws IOException {
        int i;
        int[] arr = new int[this.number];
        for (i = 0; i < this.number; ++i) {
            arr[i] = (Integer)pq.peek().left;
            pq.poll();
        }
        Arrays.sort(arr);
        for (i = 0; i < this.number; ++i) {
            collector.putDouble(rowWindow.getRow(arr[i]).getTime(), rowWindow.getRow(arr[i]).getDouble(0));
        }
    }

    public boolean isWindowSizeTooSmallInt(RowWindow rowWindow, PointCollector collector, int windowSize) throws IOException {
        if (windowSize <= this.number) {
            for (int i = 0; i < windowSize; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putInt(row.getTime(), row.getInt(0));
            }
            return true;
        }
        if (windowSize == this.number + 1) {
            for (int i = 0; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putInt(row.getTime(), row.getInt(0));
            }
            return true;
        }
        if (windowSize == this.number + 2) {
            for (int i = 1; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putInt(row.getTime(), row.getInt(0));
            }
            return true;
        }
        return false;
    }

    public boolean isWindowSizeTooSmallLong(RowWindow rowWindow, PointCollector collector, int windowSize) throws IOException {
        if (windowSize <= this.number) {
            for (int i = 0; i < windowSize; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putLong(row.getTime(), row.getLong(0));
            }
            return true;
        }
        if (windowSize == this.number + 1) {
            for (int i = 0; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putLong(row.getTime(), row.getLong(0));
            }
            return true;
        }
        if (windowSize == this.number + 2) {
            for (int i = 1; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putLong(row.getTime(), row.getLong(0));
            }
            return true;
        }
        return false;
    }

    public boolean isWindowSizeTooSmallFloat(RowWindow rowWindow, PointCollector collector, int windowSize) throws IOException {
        if (windowSize <= this.number) {
            for (int i = 0; i < windowSize; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putFloat(row.getTime(), row.getFloat(0));
            }
            return true;
        }
        if (windowSize == this.number + 1) {
            for (int i = 0; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putFloat(row.getTime(), row.getFloat(0));
            }
            return true;
        }
        if (windowSize == this.number + 2) {
            for (int i = 1; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putFloat(row.getTime(), row.getFloat(0));
            }
            return true;
        }
        return false;
    }

    public boolean isWindowSizeTooSmallDouble(RowWindow rowWindow, PointCollector collector, int windowSize) throws IOException {
        if (windowSize <= this.number) {
            for (int i = 0; i < windowSize; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putDouble(row.getTime(), row.getDouble(0));
            }
            return true;
        }
        if (windowSize == this.number + 1) {
            for (int i = 0; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putDouble(row.getTime(), row.getDouble(0));
            }
            return true;
        }
        if (windowSize == this.number + 2) {
            for (int i = 1; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                collector.putDouble(row.getTime(), row.getDouble(0));
            }
            return true;
        }
        return false;
    }

    private class AvgOutlierSampler
    implements OutlierSampler {
        private AvgOutlierSampler() {
        }

        @Override
        public void outlierSampleInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            int i;
            int windowSize = rowWindow.windowSize();
            if (windowSize <= UDTFEqualSizeBucketOutlierSample.this.number) {
                for (int i2 = 0; i2 < windowSize; ++i2) {
                    Row row = rowWindow.getRow(i2);
                    collector.putInt(row.getTime(), row.getInt(0));
                }
                return;
            }
            double avg = 0.0;
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            for (i = 0; i < windowSize; ++i) {
                avg += (double)rowWindow.getRow(i).getInt(0);
            }
            avg /= (double)windowSize;
            for (i = 0; i < windowSize; ++i) {
                double value = Math.abs((double)rowWindow.getRow(i).getInt(0) - avg);
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueInt(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            int i;
            int windowSize = rowWindow.windowSize();
            if (windowSize <= UDTFEqualSizeBucketOutlierSample.this.number) {
                for (int i2 = 0; i2 < windowSize; ++i2) {
                    Row row = rowWindow.getRow(i2);
                    collector.putLong(row.getTime(), row.getLong(0));
                }
                return;
            }
            double avg = 0.0;
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            for (i = 0; i < windowSize; ++i) {
                avg += (double)rowWindow.getRow(i).getLong(0);
            }
            avg /= (double)windowSize;
            for (i = 0; i < windowSize; ++i) {
                double value = Math.abs((double)rowWindow.getRow(i).getLong(0) - avg);
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueLong(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            int i;
            int windowSize = rowWindow.windowSize();
            if (windowSize <= UDTFEqualSizeBucketOutlierSample.this.number) {
                for (int i2 = 0; i2 < windowSize; ++i2) {
                    Row row = rowWindow.getRow(i2);
                    collector.putFloat(row.getTime(), row.getFloat(0));
                }
                return;
            }
            double avg = 0.0;
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            for (i = 0; i < windowSize; ++i) {
                avg += (double)rowWindow.getRow(i).getFloat(0);
            }
            avg /= (double)windowSize;
            for (i = 0; i < windowSize; ++i) {
                double value = Math.abs((double)rowWindow.getRow(i).getFloat(0) - avg);
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueFloat(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            int i;
            int windowSize = rowWindow.windowSize();
            if (windowSize <= UDTFEqualSizeBucketOutlierSample.this.number) {
                for (int i2 = 0; i2 < windowSize; ++i2) {
                    Row row = rowWindow.getRow(i2);
                    collector.putDouble(row.getTime(), row.getDouble(0));
                }
                return;
            }
            double avg = 0.0;
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            for (i = 0; i < windowSize; ++i) {
                avg += rowWindow.getRow(i).getDouble(0);
            }
            avg /= (double)windowSize;
            for (i = 0; i < windowSize; ++i) {
                double value = Math.abs(rowWindow.getRow(i).getDouble(0) - avg);
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueDouble(pq, rowWindow, collector);
        }
    }

    private static interface OutlierSampler {
        public void outlierSampleInt(RowWindow var1, PointCollector var2) throws IOException;

        public void outlierSampleLong(RowWindow var1, PointCollector var2) throws IOException;

        public void outlierSampleFloat(RowWindow var1, PointCollector var2) throws IOException;

        public void outlierSampleDouble(RowWindow var1, PointCollector var2) throws IOException;
    }

    private class StendisOutlierSampler
    implements OutlierSampler {
        private StendisOutlierSampler() {
        }

        @Override
        public void outlierSampleInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallInt(rowWindow, collector, windowSize)) {
                return;
            }
            long row0x = rowWindow.getRow(0).getTime();
            long row1x = rowWindow.getRow(windowSize - 1).getTime();
            int row0y = rowWindow.getRow(0).getInt(0);
            int row1y = rowWindow.getRow(windowSize - 1).getInt(0);
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            double A = (double)row0y - (double)row1y;
            double B = (double)row1x - (double)row0x;
            double C = (double)row0x * (double)row1y - (double)(row1x * (long)row0y);
            double denominator = Math.sqrt(A * A + B * B);
            for (int i = 1; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                double value = Math.abs(A * (double)row.getTime() + B * (double)row.getInt(0) + C) / denominator;
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueInt(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallLong(rowWindow, collector, windowSize)) {
                return;
            }
            long row0x = rowWindow.getRow(0).getTime();
            long row1x = rowWindow.getRow(windowSize - 1).getTime();
            long row0y = rowWindow.getRow(0).getLong(0);
            long row1y = rowWindow.getRow(windowSize - 1).getLong(0);
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            double A = (double)row0y - (double)row1y;
            double B = (double)row1x - (double)row0x;
            double C = (double)row0x * (double)row1y - (double)(row1x * row0y);
            double denominator = Math.sqrt(A * A + B * B);
            for (int i = 1; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                double value = Math.abs(A * (double)row.getTime() + B * (double)row.getLong(0) + C) / denominator;
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueLong(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallFloat(rowWindow, collector, windowSize)) {
                return;
            }
            long row0x = rowWindow.getRow(0).getTime();
            long row1x = rowWindow.getRow(windowSize - 1).getTime();
            float row0y = rowWindow.getRow(0).getFloat(0);
            float row1y = rowWindow.getRow(windowSize - 1).getFloat(0);
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            double A = (double)row0y - (double)row1y;
            double B = (double)row1x - (double)row0x;
            double C = (double)row0x * (double)row1y - (double)((float)row1x * row0y);
            double denominator = Math.sqrt(A * A + B * B);
            for (int i = 1; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                double value = Math.abs(A * (double)row.getTime() + B * (double)row.getFloat(0) + C) / denominator;
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueFloat(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallDouble(rowWindow, collector, windowSize)) {
                return;
            }
            long row0x = rowWindow.getRow(0).getTime();
            long row1x = rowWindow.getRow(windowSize - 1).getTime();
            double row0y = rowWindow.getRow(0).getDouble(0);
            double row1y = rowWindow.getRow(windowSize - 1).getDouble(0);
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            double A = row0y - row1y;
            double B = (double)row1x - (double)row0x;
            double C = (double)row0x * row1y - (double)row1x * row0y;
            double denominator = Math.sqrt(A * A + B * B);
            for (int i = 1; i < windowSize - 1; ++i) {
                Row row = rowWindow.getRow(i);
                double value = Math.abs(A * (double)row.getTime() + B * row.getDouble(0) + C) / denominator;
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueDouble(pq, rowWindow, collector);
        }
    }

    private class CosOutlierSampler
    implements OutlierSampler {
        private CosOutlierSampler() {
        }

        @Override
        public void outlierSampleInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallInt(rowWindow, collector, windowSize)) {
                return;
            }
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> -((Double)o.right).doubleValue()));
            for (int i = 1; i < windowSize - 1; ++i) {
                long lastTime = rowWindow.getRow(i - 1).getTime();
                long currentTime = rowWindow.getRow(i).getTime();
                long nextTime = rowWindow.getRow(i + 1).getTime();
                int lastValue = rowWindow.getRow(i - 1).getInt(0);
                int currentValue = rowWindow.getRow(i).getInt(0);
                int nextValue = rowWindow.getRow(i + 1).getInt(0);
                long x1 = currentTime - lastTime;
                long x2 = nextTime - currentTime;
                int y1 = currentValue - lastValue;
                int y2 = nextValue - currentValue;
                double value = (double)(x1 * x2 + (long)(y1 * y2)) / (Math.sqrt((double)x1 * (double)x1 + (double)(y1 * y1)) * Math.sqrt((double)x2 * (double)x2 + (double)(y2 * y2)));
                UDTFEqualSizeBucketOutlierSample.this.addToMaxHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueInt(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallLong(rowWindow, collector, windowSize)) {
                return;
            }
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> -((Double)o.right).doubleValue()));
            for (int i = 1; i < windowSize - 1; ++i) {
                long lastTime = rowWindow.getRow(i - 1).getTime();
                long currentTime = rowWindow.getRow(i).getTime();
                long nextTime = rowWindow.getRow(i + 1).getTime();
                long lastValue = rowWindow.getRow(i - 1).getLong(0);
                long currentValue = rowWindow.getRow(i).getLong(0);
                long nextValue = rowWindow.getRow(i + 1).getLong(0);
                long x1 = currentTime - lastTime;
                long x2 = nextTime - currentTime;
                long y1 = currentValue - lastValue;
                long y2 = nextValue - currentValue;
                double value = (double)(x1 * x2 + y1 * y2) / (Math.sqrt((double)x1 * (double)x1 + (double)(y1 * y1)) * Math.sqrt((double)x2 * (double)x2 + (double)(y2 * y2)));
                UDTFEqualSizeBucketOutlierSample.this.addToMaxHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueLong(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallFloat(rowWindow, collector, windowSize)) {
                return;
            }
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> -((Double)o.right).doubleValue()));
            for (int i = 1; i < windowSize - 1; ++i) {
                long lastTime = rowWindow.getRow(i - 1).getTime();
                long currentTime = rowWindow.getRow(i).getTime();
                long nextTime = rowWindow.getRow(i + 1).getTime();
                float lastValue = rowWindow.getRow(i - 1).getFloat(0);
                float currentValue = rowWindow.getRow(i).getFloat(0);
                float nextValue = rowWindow.getRow(i + 1).getFloat(0);
                long x1 = currentTime - lastTime;
                long x2 = nextTime - currentTime;
                float y1 = currentValue - lastValue;
                float y2 = nextValue - currentValue;
                double value = (double)((float)(x1 * x2) + y1 * y2) / (Math.sqrt((float)(x1 * x1) + y1 * y1) * Math.sqrt((float)(x2 * x2) + y2 * y2));
                UDTFEqualSizeBucketOutlierSample.this.addToMaxHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueFloat(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallDouble(rowWindow, collector, windowSize)) {
                return;
            }
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> -((Double)o.right).doubleValue()));
            for (int i = 1; i < windowSize - 1; ++i) {
                long lastTime = rowWindow.getRow(i - 1).getTime();
                long currentTime = rowWindow.getRow(i).getTime();
                long nextTime = rowWindow.getRow(i + 1).getTime();
                double lastValue = rowWindow.getRow(i - 1).getDouble(0);
                double currentValue = rowWindow.getRow(i).getDouble(0);
                double nextValue = rowWindow.getRow(i + 1).getDouble(0);
                long x1 = currentTime - lastTime;
                long x2 = nextTime - currentTime;
                double y1 = currentValue - lastValue;
                double y2 = nextValue - currentValue;
                double value = ((double)(x1 * x2) + y1 * y2) / (Math.sqrt((double)(x1 * x1) + y1 * y1) * Math.sqrt((double)(x2 * x2) + y2 * y2));
                UDTFEqualSizeBucketOutlierSample.this.addToMaxHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueDouble(pq, rowWindow, collector);
        }
    }

    private class PrenextdisOutlierSampler
    implements OutlierSampler {
        private PrenextdisOutlierSampler() {
        }

        @Override
        public void outlierSampleInt(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallInt(rowWindow, collector, windowSize)) {
                return;
            }
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            for (int i = 1; i < windowSize - 1; ++i) {
                long lastTime = rowWindow.getRow(i - 1).getTime();
                long currentTime = rowWindow.getRow(i).getTime();
                long nextTime = rowWindow.getRow(i + 1).getTime();
                int lastValue = rowWindow.getRow(i - 1).getInt(0);
                int currentValue = rowWindow.getRow(i).getInt(0);
                int nextValue = rowWindow.getRow(i + 1).getInt(0);
                long x1 = Math.abs(currentTime - lastTime);
                long x2 = Math.abs(nextTime - currentTime);
                int y1 = Math.abs(currentValue - lastValue);
                int y2 = Math.abs(nextValue - currentValue);
                double value = (double)x1 + (double)y1 + (double)x2 + (double)y2;
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueInt(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleLong(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallLong(rowWindow, collector, windowSize)) {
                return;
            }
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            for (int i = 1; i < windowSize - 1; ++i) {
                long lastTime = rowWindow.getRow(i - 1).getTime();
                long currentTime = rowWindow.getRow(i).getTime();
                long nextTime = rowWindow.getRow(i + 1).getTime();
                long lastValue = rowWindow.getRow(i - 1).getLong(0);
                long currentValue = rowWindow.getRow(i).getLong(0);
                long nextValue = rowWindow.getRow(i + 1).getLong(0);
                long x1 = Math.abs(currentTime - lastTime);
                long x2 = Math.abs(nextTime - currentTime);
                long y1 = Math.abs(currentValue - lastValue);
                long y2 = Math.abs(nextValue - currentValue);
                double value = (double)x1 + (double)y1 + (double)x2 + (double)y2;
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueLong(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallFloat(rowWindow, collector, windowSize)) {
                return;
            }
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            for (int i = 1; i < windowSize - 1; ++i) {
                long lastTime = rowWindow.getRow(i - 1).getTime();
                long currentTime = rowWindow.getRow(i).getTime();
                long nextTime = rowWindow.getRow(i + 1).getTime();
                float lastValue = rowWindow.getRow(i - 1).getFloat(0);
                float currentValue = rowWindow.getRow(i).getFloat(0);
                float nextValue = rowWindow.getRow(i + 1).getFloat(0);
                long x1 = Math.abs(currentTime - lastTime);
                long x2 = Math.abs(nextTime - currentTime);
                float y1 = Math.abs(currentValue - lastValue);
                float y2 = Math.abs(nextValue - currentValue);
                double value = (float)x1 + y1 + (float)x2 + y2;
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueFloat(pq, rowWindow, collector);
        }

        @Override
        public void outlierSampleDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
            int windowSize = rowWindow.windowSize();
            if (UDTFEqualSizeBucketOutlierSample.this.isWindowSizeTooSmallDouble(rowWindow, collector, windowSize)) {
                return;
            }
            PriorityQueue<Pair<Integer, Double>> pq = new PriorityQueue<Pair<Integer, Double>>(UDTFEqualSizeBucketOutlierSample.this.number, Comparator.comparing(o -> (Double)o.right));
            for (int i = 1; i < windowSize - 1; ++i) {
                long lastTime = rowWindow.getRow(i - 1).getTime();
                long currentTime = rowWindow.getRow(i).getTime();
                long nextTime = rowWindow.getRow(i + 1).getTime();
                double lastValue = rowWindow.getRow(i - 1).getDouble(0);
                double currentValue = rowWindow.getRow(i).getDouble(0);
                double nextValue = rowWindow.getRow(i + 1).getDouble(0);
                long x1 = Math.abs(currentTime - lastTime);
                long x2 = Math.abs(nextTime - currentTime);
                double y1 = Math.abs(currentValue - lastValue);
                double y2 = Math.abs(nextValue - currentValue);
                double value = (double)x1 + y1 + (double)x2 + y2;
                UDTFEqualSizeBucketOutlierSample.this.addToMinHeap(pq, i, value);
            }
            UDTFEqualSizeBucketOutlierSample.this.putPQValueDouble(pq, rowWindow, collector);
        }
    }
}

