/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition.executor.hash;

import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;

public class BKDRHashExecutor
extends SeriesPartitionExecutor {
    private static final int SEED = 131;

    public BKDRHashExecutor(int deviceGroupCount) {
        super(deviceGroupCount);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(String device) {
        int hash = 0;
        for (int i = 0; i < device.length(); ++i) {
            hash = hash * 131 + device.charAt(i);
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }
}

