/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.RetainedMessage;
import io.moquette.broker.subscriptions.Topic;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class MemoryRetainedRepository
implements IRetainedRepository {
    private final ConcurrentMap<Topic, RetainedMessage> storage = new ConcurrentHashMap<Topic, RetainedMessage>();
    private final ConcurrentMap<Topic, RetainedMessage> storageExpire = new ConcurrentHashMap<Topic, RetainedMessage>();

    MemoryRetainedRepository() {
    }

    @Override
    public void cleanRetained(Topic topic) {
        this.storage.remove(topic);
        this.storageExpire.remove(topic);
    }

    @Override
    public void retain(Topic topic, MqttPublishMessage msg) {
        byte[] rawPayload = MemoryRetainedRepository.payloadToByteArray(msg);
        RetainedMessage toStore = new RetainedMessage(topic, msg.fixedHeader().qosLevel(), rawPayload, MemoryRetainedRepository.extractPropertiesArray(msg));
        this.storage.put(topic, toStore);
    }

    @Override
    public void retain(Topic topic, MqttPublishMessage msg, Instant expiryTime) {
        byte[] rawPayload = MemoryRetainedRepository.payloadToByteArray(msg);
        RetainedMessage toStore = new RetainedMessage(topic, msg.fixedHeader().qosLevel(), rawPayload, MemoryRetainedRepository.extractPropertiesArray(msg), expiryTime);
        this.storageExpire.put(topic, toStore);
    }

    private static MqttProperties.MqttProperty[] extractPropertiesArray(MqttPublishMessage msg) {
        MqttProperties properties = msg.variableHeader().properties();
        return properties.listAll().toArray(new MqttProperties.MqttProperty[0]);
    }

    private static byte[] payloadToByteArray(MqttPublishMessage msg) {
        ByteBuf payload = msg.content();
        byte[] rawPayload = new byte[payload.readableBytes()];
        payload.getBytes(0, rawPayload);
        return rawPayload;
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty() && this.storageExpire.isEmpty();
    }

    @Override
    public Collection<RetainedMessage> retainedOnTopic(String topic) {
        Topic searchTopic = new Topic(topic);
        ArrayList<RetainedMessage> matchingMessages = new ArrayList<RetainedMessage>();
        matchingMessages.addAll(this.findMatching(searchTopic, this.storage));
        matchingMessages.addAll(this.findMatching(searchTopic, this.storageExpire));
        return matchingMessages;
    }

    @Override
    public Collection<RetainedMessage> listExpirable() {
        return this.storageExpire.values();
    }

    private List<RetainedMessage> findMatching(Topic searchTopic, ConcurrentMap<Topic, RetainedMessage> map) {
        ArrayList<RetainedMessage> matchingMessages = new ArrayList<RetainedMessage>();
        for (Map.Entry entry : map.entrySet()) {
            Topic scanTopic = (Topic)entry.getKey();
            if (!scanTopic.match(searchTopic)) continue;
            matchingMessages.add((RetainedMessage)entry.getValue());
        }
        return matchingMessages;
    }
}

