/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.function.CheckedBiFunction;
import org.apache.ratis.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BufferedWriteChannel
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(BufferedWriteChannel.class);
    private final String name;
    private final FileChannel fileChannel;
    private final ByteBuffer writeBuffer;
    private boolean forced = true;
    private final AtomicReference<CompletableFuture<Void>> flushFuture = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));

    static BufferedWriteChannel open(File file, boolean append, ByteBuffer buffer) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel fc = raf.getChannel();
        long size = file.length();
        if (append) {
            fc.position(size);
            Preconditions.assertSame((long)size, (long)fc.size(), (String)"fc.size");
        } else {
            if (size > 0L) {
                fc.truncate(0L);
            }
            Preconditions.assertSame((long)0L, (long)fc.size(), (String)"fc.size");
        }
        Preconditions.assertSame((long)fc.size(), (long)fc.position(), (String)"fc.position");
        String name = file.getName() + (append ? " (append)" : "");
        LOG.info("open {} at position {}", (Object)name, (Object)fc.position());
        return new BufferedWriteChannel(name, fc, buffer);
    }

    BufferedWriteChannel(String name, FileChannel fileChannel, ByteBuffer byteBuffer) {
        this.name = name;
        this.fileChannel = fileChannel;
        this.writeBuffer = byteBuffer;
    }

    int writeBufferPosition() {
        return this.writeBuffer.position();
    }

    void writeToBuffer(int writeSize, CheckedConsumer<ByteBuffer, IOException> writeMethod) throws IOException {
        if (writeSize > this.writeBuffer.capacity()) {
            throw new IOException("writeSize = " + writeSize + " > writeBuffer.capacity() = " + this.writeBuffer.capacity());
        }
        if (writeSize > this.writeBuffer.remaining()) {
            this.flushBuffer();
        }
        int pos = this.writeBufferPosition();
        int lim = this.writeBuffer.limit();
        writeMethod.accept((Object)this.writeBuffer);
        int written = this.writeBufferPosition() - pos;
        Preconditions.assertSame((int)writeSize, (int)written, (String)"written");
        Preconditions.assertSame((int)lim, (int)this.writeBuffer.limit(), (String)"writeBuffer.limit()");
    }

    void writeToChannel(ByteBuffer buffer) throws IOException {
        int written;
        Preconditions.assertSame((int)0, (int)this.writeBufferPosition(), (String)"writeBuffer.position()");
        int length = buffer.remaining();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write {} bytes (pos={}, size={}) to channel {}", new Object[]{length, this.fileChannel.position(), this.fileChannel.size(), this});
        }
        for (written = 0; written < length; written += this.fileChannel.write(buffer)) {
        }
        Preconditions.assertSame((int)length, (int)written, (String)"written");
        this.forced = false;
    }

    void preallocateIfNecessary(long size, CheckedBiFunction<FileChannel, Long, Long, IOException> preallocate) throws IOException {
        long outstanding = (long)this.writeBufferPosition() + size;
        if (this.fileChannel.position() + outstanding > this.fileChannel.size()) {
            preallocate.apply((Object)this.fileChannel, (Object)outstanding);
        }
    }

    void flush() throws IOException {
        this.flushBuffer();
        if (!this.forced) {
            this.fileChannel.force(false);
            this.forced = true;
        }
    }

    CompletableFuture<Void> asyncFlush(ExecutorService executor) throws IOException {
        this.flushBuffer();
        if (this.forced) {
            return this.flushFuture.get();
        }
        CompletableFuture<Void> f = CompletableFuture.supplyAsync(this::fileChannelForce, executor);
        this.forced = true;
        return this.flushFuture.updateAndGet(previous -> f.thenCombine((CompletionStage)previous, (current, prev) -> current));
    }

    private Void fileChannelForce() {
        try {
            this.fileChannel.force(false);
        }
        catch (IOException e) {
            throw new CompletionException("Failed to force channel " + this, e);
        }
        return null;
    }

    private void flushBuffer() throws IOException {
        if (this.writeBufferPosition() == 0) {
            return;
        }
        this.writeBuffer.flip();
        this.writeToChannel(this.writeBuffer);
        this.writeBuffer.clear();
        this.forced = false;
    }

    boolean isOpen() {
        return this.fileChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.flushFuture.get().join();
            this.fileChannel.truncate(this.fileChannel.position());
        }
        finally {
            this.fileChannel.close();
        }
    }

    public String toString() {
        return this.name;
    }
}

