/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Map;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.pipe.api.type.Binary;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.Pair;

public class CustomizedReadableIntermediateResults {
    private final Map<String, Pair<TSDataType, Object>> intermediateResults;

    public CustomizedReadableIntermediateResults(Map<String, Pair<TSDataType, Object>> intermediateResults) {
        this.intermediateResults = intermediateResults;
    }

    public boolean getBoolean(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        if (typeResultPair.getLeft() == TSDataType.BOOLEAN) {
            return (Boolean)typeResultPair.getRight();
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to boolean.", typeResultPair.getLeft()));
    }

    public int getInt(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case INT32: {
                return (Integer)value;
            }
            case DATE: {
                return DateUtils.parseDateExpressionToInt((LocalDate)((LocalDate)value));
            }
            case INT64: 
            case TIMESTAMP: {
                return (int)((Long)value).longValue();
            }
            case FLOAT: {
                return (int)((Float)value).floatValue();
            }
            case DOUBLE: {
                return (int)((Double)value).doubleValue();
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to int.", typeResultPair.getLeft()));
    }

    public long getLong(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case INT32: {
                return ((Integer)value).intValue();
            }
            case DATE: {
                return DateUtils.parseDateExpressionToInt((LocalDate)((LocalDate)value)).intValue();
            }
            case INT64: 
            case TIMESTAMP: {
                return (Long)value;
            }
            case FLOAT: {
                return (long)((Float)value).floatValue();
            }
            case DOUBLE: {
                return (long)((Double)value).doubleValue();
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to long.", typeResultPair.getLeft()));
    }

    public float getFloat(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case INT32: {
                return ((Integer)value).intValue();
            }
            case DATE: {
                return DateUtils.parseDateExpressionToInt((LocalDate)((LocalDate)value)).intValue();
            }
            case INT64: 
            case TIMESTAMP: {
                return ((Long)value).longValue();
            }
            case FLOAT: {
                return ((Float)value).floatValue();
            }
            case DOUBLE: {
                return (float)((Double)value).doubleValue();
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to float.", typeResultPair.getLeft()));
    }

    public double getDouble(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case INT32: {
                return ((Integer)value).intValue();
            }
            case DATE: {
                return DateUtils.parseDateExpressionToInt((LocalDate)((LocalDate)value)).intValue();
            }
            case INT64: 
            case TIMESTAMP: {
                return ((Long)value).longValue();
            }
            case FLOAT: {
                return ((Float)value).floatValue();
            }
            case DOUBLE: {
                return (Double)value;
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to double.", typeResultPair.getLeft()));
    }

    public String getString(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case BOOLEAN: {
                return Boolean.toString((Boolean)value);
            }
            case INT32: {
                return Integer.toString((Integer)value);
            }
            case DATE: {
                return ((LocalDate)value).toString();
            }
            case INT64: {
                return Long.toString((Long)value);
            }
            case TIMESTAMP: {
                return RpcUtils.formatDatetime((String)"default", (String)CommonDescriptor.getInstance().getConfig().getTimestampPrecision(), (long)((Long)value), (ZoneId)ZoneId.systemDefault());
            }
            case FLOAT: {
                return Float.toString(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Double.toString((Double)value);
            }
            case TEXT: 
            case STRING: {
                return (String)value;
            }
            case BLOB: {
                return BytesUtils.parseBlobByteArrayToString((byte[])((Binary)value).getValues());
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to string.", typeResultPair.getLeft()));
    }

    public Object getObject(String key) {
        return this.intermediateResults.get(key).getRight();
    }

    public TSDataType getType(String key) {
        return (TSDataType)this.intermediateResults.get(key).getLeft();
    }
}

