/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.basic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.ValueFilter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class FloatFilter
extends ValueFilter {
    protected FloatFilter(int measurementIndex) {
        super(measurementIndex);
    }

    protected FloatFilter(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public boolean satisfyFloat(long time, float value) {
        return this.valueSatisfy(value);
    }

    @Override
    public ReadWriteIOUtils.ClassSerializeId getClassSerializeId() {
        return ReadWriteIOUtils.ClassSerializeId.FLOAT;
    }

    protected abstract boolean valueSatisfy(float var1);

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        Column valueColumn = tsBlock.getValueColumns()[this.measurementIndex];
        boolean[] satisfyInfo = new boolean[selection.length];
        System.arraycopy(selection, 0, satisfyInfo, 0, selection.length);
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i]) continue;
            satisfyInfo[i] = valueColumn.isNull(i) ? false : this.valueSatisfy(valueColumn.getFloat(i));
        }
        return satisfyInfo;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        super.serialize(outputStream);
    }
}

