/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.managers.eventstorage.HighPriorityListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.service.ServiceChangeBatchRequest;
import org.apache.ignite.internal.processors.service.ServiceClusterDeploymentResultBatch;
import org.apache.ignite.internal.processors.service.ServiceDeploymentActions;
import org.apache.ignite.internal.processors.service.ServiceDeploymentProcessId;
import org.apache.ignite.internal.processors.service.ServiceDeploymentTask;
import org.apache.ignite.internal.processors.service.ServiceSingleNodeDeploymentResultBatch;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceDeploymentManager {
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final DiscoveryEventListener discoLsnr = new ServiceDiscoveryListener();
    private final GridMessageListener commLsnr = new ServiceCommunicationListener();
    private final Map<ServiceDeploymentProcessId, ServiceDeploymentTask> tasks = new ConcurrentHashMap<ServiceDeploymentProcessId, ServiceDeploymentTask>();
    private final List<PendingEventHolder> pendingEvts = new ArrayList<PendingEventHolder>();
    private final AtomicReference<AffinityTopologyVersion> readyTopVer = new AtomicReference<AffinityTopologyVersion>(AffinityTopologyVersion.NONE);
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private final ServicesDeploymentWorker depWorker;
    private final long dfltDumpTimeoutLimit;

    ServiceDeploymentManager(@NotNull GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        ctx.event().addDiscoveryEventListener(this.discoLsnr, 10, 11, 12, 18);
        ctx.io().addMessageListener(GridTopic.TOPIC_SERVICES, this.commLsnr);
        this.depWorker = new ServicesDeploymentWorker();
        long limit = IgniteSystemProperties.getLong("IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT_LIMIT", 0L);
        this.dfltDumpTimeoutLimit = limit <= 0L ? 1800000L : limit;
    }

    void startProcessing() {
        assert (this.depWorker.runner() == null) : "Method shouldn't be called twice during lifecycle;";
        new IgniteThread(this.ctx.igniteInstanceName(), "services-deployment-worker", this.depWorker).start();
    }

    void stopProcessing(IgniteCheckedException stopErr) {
        this.busyLock.block();
        try {
            this.ctx.event().removeDiscoveryEventListener(this.discoLsnr, new int[0]);
            this.ctx.io().removeMessageListener(this.commLsnr);
            U.cancel(this.depWorker);
            U.join(this.depWorker, this.log);
            this.depWorker.tasksQueue.clear();
            this.pendingEvts.clear();
            this.tasks.values().forEach(t -> t.completeError(stopErr));
            this.tasks.clear();
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public AffinityTopologyVersion readyTopologyVersion() {
        return this.readyTopVer.get();
    }

    void onLocalJoin(DiscoveryEvent evt, DiscoCache discoCache, ServiceDeploymentActions depActions) {
        this.checkClusterStateAndAddTask(evt, discoCache, depActions);
    }

    void deployerBlockingSectionBegin() {
        assert (this.depWorker != null && Thread.currentThread() == this.depWorker.runner());
        this.depWorker.blockingSectionBegin();
    }

    void deployerBlockingSectionEnd() {
        assert (this.depWorker != null && Thread.currentThread() == this.depWorker.runner());
        this.depWorker.blockingSectionEnd();
    }

    private void checkClusterStateAndAddTask(@NotNull DiscoveryEvent evt, @NotNull DiscoCache discoCache, @Nullable ServiceDeploymentActions depActions) {
        if (discoCache.state().transition()) {
            this.pendingEvts.add(new PendingEventHolder(evt, discoCache.version(), depActions));
        } else if (discoCache.state().active()) {
            this.addTask(evt, discoCache.version(), depActions);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Ignore event, cluster is inactive, evt=" + evt);
        }
    }

    private void addTask(@NotNull DiscoveryEvent evt, @NotNull AffinityTopologyVersion topVer, @Nullable ServiceDeploymentActions depActions) {
        ServiceDeploymentProcessId depId = this.deploymentId(evt, topVer);
        ServiceDeploymentTask task = this.tasks.computeIfAbsent(depId, t -> new ServiceDeploymentTask(this.ctx, depId));
        if (!task.onEnqueued()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Service deployment process hasn't been started for discovery event, because of a task with the same deployment process id is already added (possible cause is message's double delivering), evt=" + evt);
            }
            return;
        }
        assert (task.event() == null && task.topologyVersion() == null);
        task.onEvent(evt, topVer, depActions);
        this.depWorker.tasksQueue.add(task);
    }

    private ServiceDeploymentProcessId deploymentId(@NotNull DiscoveryEvent evt, @NotNull AffinityTopologyVersion topVer) {
        return evt instanceof DiscoveryCustomEvent ? new ServiceDeploymentProcessId(((DiscoveryCustomEvent)evt).customMessage().id()) : new ServiceDeploymentProcessId(topVer);
    }

    private DiscoveryCustomEvent copyIfNeeded(@NotNull DiscoveryCustomEvent evt) {
        DiscoveryCustomMessage msg = evt.customMessage();
        assert (msg != null) : "DiscoveryCustomMessage has been nullified concurrently, evt=" + evt;
        if (msg instanceof ServiceChangeBatchRequest) {
            return evt;
        }
        DiscoveryCustomEvent cp = new DiscoveryCustomEvent();
        cp.node(evt.node());
        cp.customMessage(msg);
        cp.eventNode(evt.eventNode());
        cp.affinityTopologyVersion(evt.affinityTopologyVersion());
        return cp;
    }

    private boolean enterBusy() {
        return this.busyLock.enterBusy();
    }

    private void leaveBusy() {
        this.busyLock.leaveBusy();
    }

    private class ServicesDeploymentWorker
    extends GridWorker {
        private final LinkedBlockingQueue<ServiceDeploymentTask> tasksQueue;

        private ServicesDeploymentWorker() {
            super(ServiceDeploymentManager.this.ctx.igniteInstanceName(), "services-deployment-worker", ServiceDeploymentManager.this.log, ServiceDeploymentManager.this.ctx.workersRegistry());
            this.tasksQueue = new LinkedBlockingQueue();
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void taskPostProcessing(ServiceDeploymentTask task) {
            AffinityTopologyVersion readyVer = ServiceDeploymentManager.this.readyTopVer.get();
            ServiceDeploymentManager.this.readyTopVer.compareAndSet(readyVer, task.topologyVersion());
            ServiceDeploymentManager.this.tasks.remove(task.deploymentId());
        }
    }

    private class ServiceCommunicationListener
    implements GridMessageListener {
        private ServiceCommunicationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            if (!ServiceDeploymentManager.this.enterBusy()) {
                return;
            }
            try {
                if (msg instanceof ServiceSingleNodeDeploymentResultBatch) {
                    ServiceSingleNodeDeploymentResultBatch msg0 = (ServiceSingleNodeDeploymentResultBatch)msg;
                    if (ServiceDeploymentManager.this.log.isDebugEnabled()) {
                        ServiceDeploymentManager.this.log.debug("Received services single deployments message : [locId=" + ServiceDeploymentManager.this.ctx.localNodeId() + ", snd=" + nodeId + ", msg=" + msg0 + "]");
                    }
                    ServiceDeploymentManager.this.tasks.computeIfAbsent(msg0.deploymentId(), t -> new ServiceDeploymentTask(ServiceDeploymentManager.this.ctx, msg0.deploymentId())).onReceiveSingleDeploymentsMessage(nodeId, msg0);
                }
            }
            finally {
                ServiceDeploymentManager.this.leaveBusy();
            }
        }
    }

    private static class PendingEventHolder {
        private DiscoveryEvent evt;
        private AffinityTopologyVersion topVer;
        private ServiceDeploymentActions depActions;

        private PendingEventHolder(DiscoveryEvent evt, AffinityTopologyVersion topVer, ServiceDeploymentActions depActions) {
            this.evt = evt;
            this.topVer = topVer;
            this.depActions = depActions;
        }
    }

    private class ServiceDiscoveryListener
    implements DiscoveryEventListener,
    HighPriorityListener {
        private ServiceDiscoveryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(DiscoveryEvent evt, DiscoCache discoCache) {
            if (!ServiceDeploymentManager.this.enterBusy()) {
                return;
            }
            try {
                UUID snd = evt.eventNode().id();
                int evtType = evt.type();
                assert (snd != null) : "Event's node id shouldn't be null.";
                assert (evtType == 10 || evtType == 11 || evtType == 12 || evtType == 18) : "Unexpected event was received, evt=" + evt;
                if (evtType == 18) {
                    DiscoveryCustomMessage msg = ((DiscoveryCustomEvent)evt).customMessage();
                    if (msg instanceof ChangeGlobalStateFinishMessage) {
                        ChangeGlobalStateFinishMessage msg0 = (ChangeGlobalStateFinishMessage)msg;
                        if (msg0.clusterActive()) {
                            ServiceDeploymentManager.this.pendingEvts.forEach(t -> ServiceDeploymentManager.this.addTask(t.evt, t.topVer, t.depActions));
                        } else if (ServiceDeploymentManager.this.log.isDebugEnabled()) {
                            ServiceDeploymentManager.this.pendingEvts.forEach(t -> ServiceDeploymentManager.this.log.debug("Ignore event, cluster is inactive: " + t.evt));
                        }
                        ServiceDeploymentManager.this.pendingEvts.clear();
                    } else if (msg instanceof ServiceClusterDeploymentResultBatch) {
                        ServiceClusterDeploymentResultBatch msg0 = (ServiceClusterDeploymentResultBatch)msg;
                        if (ServiceDeploymentManager.this.log.isDebugEnabled()) {
                            ServiceDeploymentManager.this.log.debug("Received services full deployments message : [locId=" + ServiceDeploymentManager.this.ctx.localNodeId() + ", snd=" + snd + ", msg=" + msg0 + "]");
                        }
                        ServiceDeploymentProcessId depId = msg0.deploymentId();
                        assert (depId != null);
                        ServiceDeploymentTask task = ServiceDeploymentManager.this.tasks.get(depId);
                        if (task != null) {
                            task.onReceiveFullDeploymentsMessage(msg0);
                        }
                    } else if (msg instanceof CacheAffinityChangeMessage) {
                        ServiceDeploymentManager.this.addTask(ServiceDeploymentManager.this.copyIfNeeded((DiscoveryCustomEvent)evt), discoCache.version(), null);
                    } else {
                        ServiceDeploymentActions depActions = null;
                        if (msg instanceof ChangeGlobalStateMessage) {
                            depActions = ((ChangeGlobalStateMessage)msg).servicesDeploymentActions();
                        } else if (msg instanceof ServiceChangeBatchRequest) {
                            depActions = ((ServiceChangeBatchRequest)msg).servicesDeploymentActions();
                        } else if (msg instanceof DynamicCacheChangeBatch) {
                            depActions = ((DynamicCacheChangeBatch)msg).servicesDeploymentActions();
                        }
                        if (depActions != null) {
                            ServiceDeploymentManager.this.addTask(ServiceDeploymentManager.this.copyIfNeeded((DiscoveryCustomEvent)evt), discoCache.version(), depActions);
                        }
                    }
                } else {
                    if (evtType == 11 || evtType == 12) {
                        ServiceDeploymentManager.this.tasks.values().forEach(t -> t.onNodeLeft(snd));
                    }
                    ServiceDeploymentManager.this.checkClusterStateAndAddTask(evt, discoCache, null);
                }
            }
            finally {
                ServiceDeploymentManager.this.leaveBusy();
            }
        }

        @Override
        public int order() {
            return 0;
        }
    }
}

