/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.GlobalCommitterOperator;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.util.function.SerializableSupplier;

@Experimental
public class StandardSinkTopologies {
    public static final String GLOBAL_COMMITTER_TRANSFORMATION_NAME = "Global Committer";

    private StandardSinkTopologies() {
    }

    public static <CommT> void addGlobalCommitter(DataStream<CommittableMessage<CommT>> committables, SerializableSupplier<Committer<CommT>> committerFactory, SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializer) {
        PhysicalTransformation transformation = (PhysicalTransformation)committables.global().transform(GLOBAL_COMMITTER_TRANSFORMATION_NAME, Types.VOID, new GlobalCommitterOperator(committerFactory, committableSerializer)).getTransformation();
        transformation.setChainingStrategy(ChainingStrategy.ALWAYS);
        transformation.setName(GLOBAL_COMMITTER_TRANSFORMATION_NAME);
        transformation.setParallelism(1);
        transformation.setMaxParallelism(1);
    }
}

