/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.runners.dataflow.util.CloudKnownType;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CloudObject
extends GenericJson
implements Cloneable {
    @Key(value="@type")
    private @UnknownKeyFor @NonNull @Initialized String className;

    public static @UnknownKeyFor @NonNull @Initialized CloudObject fromSpec(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> spec) {
        CloudObject result = new CloudObject();
        result.putAll(spec);
        if (result.className == null) {
            throw new RuntimeException("Unable to create an SDK object from " + spec + ": Object class not specified (missing \"" + "@type" + "\" field)");
        }
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cls) {
        CloudObject result = new CloudObject();
        result.className = ((Class)Preconditions.checkNotNull(cls)).getName();
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject forClassName(@UnknownKeyFor @NonNull @Initialized String className) {
        CloudObject result = new CloudObject();
        result.className = (String)Preconditions.checkNotNull((Object)className);
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject forString(@UnknownKeyFor @NonNull @Initialized String value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.TEXT.getUri());
        result.put("value", value);
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject forBoolean(@UnknownKeyFor @NonNull @Initialized Boolean value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.BOOLEAN.getUri());
        result.put("value", value);
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject forInteger(@UnknownKeyFor @NonNull @Initialized Long value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.INTEGER.getUri());
        result.put("value", value);
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject forInteger(@UnknownKeyFor @NonNull @Initialized Integer value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.INTEGER.getUri());
        result.put("value", value);
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject forFloat(@UnknownKeyFor @NonNull @Initialized Float value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.FLOAT.getUri());
        result.put("value", value);
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject forFloat(@UnknownKeyFor @NonNull @Initialized Double value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.FLOAT.getUri());
        result.put("value", value);
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject forKnownType(@UnknownKeyFor @NonNull @Initialized Object value) {
        @Nullable CloudKnownType ty = CloudKnownType.forClass(value.getClass());
        if (ty == null) {
            throw new RuntimeException("Unable to represent value via the Dataflow API: " + value);
        }
        CloudObject result = CloudObject.forClassName(ty.getUri());
        result.put("value", value);
        return result;
    }

    private CloudObject() {
    }

    public @UnknownKeyFor @NonNull @Initialized String getClassName() {
        return this.className;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized CloudObject clone() {
        return (CloudObject)super.clone();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object otherObject) {
        if (!(otherObject instanceof CloudObject)) {
            return false;
        }
        CloudObject other = (CloudObject)otherObject;
        return Objects.equals(this.className, other.className) && super.equals(otherObject);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.className, super.hashCode());
    }
}

