/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.common.base.Ascii;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.io.ByteStreams;
import autovalue.shaded.com.google.escapevelocity.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;
import java.util.jar.JarFile;

abstract class TemplateVars {
    private final ImmutableList<Field> fields = TemplateVars.getFields(this.getClass());

    abstract Template parsedTemplate();

    TemplateVars() {
    }

    private static ImmutableList<Field> getFields(Class<?> c) {
        ImmutableList.Builder<Field> fieldsBuilder = ImmutableList.builder();
        while (c != TemplateVars.class) {
            TemplateVars.addFields(fieldsBuilder, c.getDeclaredFields());
            c = c.getSuperclass();
        }
        return fieldsBuilder.build();
    }

    private static void addFields(ImmutableList.Builder<Field> fieldsBuilder, Field[] declaredFields) {
        for (Field field : declaredFields) {
            if (field.isSynthetic() || TemplateVars.isStaticFinal(field)) continue;
            if (Modifier.isPrivate(field.getModifiers())) {
                throw new IllegalArgumentException("Field cannot be private: " + field);
            }
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field cannot be static unless also final: " + field);
            }
            if (field.getType().isPrimitive()) {
                throw new IllegalArgumentException("Field cannot be primitive: " + field);
            }
            fieldsBuilder.add((Object)field);
        }
    }

    String toText() {
        ImmutableMap<String, Object> vars = this.toVars();
        return this.parsedTemplate().evaluate(vars);
    }

    private ImmutableMap<String, Object> toVars() {
        TreeMap<String, Object> vars = new TreeMap<String, Object>();
        for (Field field : this.fields) {
            Object value = TemplateVars.fieldValue(field, this);
            if (value == null) {
                throw new IllegalArgumentException("Field cannot be null (was it set?): " + field);
            }
            Object old = vars.put(field.getName(), value);
            if (old == null) continue;
            throw new IllegalArgumentException("Two fields called " + field.getName() + "?!");
        }
        return ImmutableMap.copyOf(vars);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.toVars();
    }

    static Template parsedTemplateForResource(String resourceName) {
        try {
            return Template.parseFrom(resourceName, TemplateVars::readerFromUrl);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Reader readerFromUrl(String resourceName) throws IOException {
        URL resourceUrl = TemplateVars.class.getResource(resourceName);
        if (resourceUrl == null) {
            throw new IllegalArgumentException("Could not find resource: " + resourceName);
        }
        try {
            if (Ascii.equalsIgnoreCase(resourceUrl.getProtocol(), "file")) {
                return TemplateVars.readerFromFile(resourceUrl);
            }
            if (Ascii.equalsIgnoreCase(resourceUrl.getProtocol(), "jar")) {
                return TemplateVars.readerFromJar(resourceUrl);
            }
            throw new AssertionError((Object)("Template search logic fails for: " + resourceUrl));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static Reader readerFromJar(URL resourceUrl) throws URISyntaxException, IOException {
        int bang;
        String resourceUrlString = resourceUrl.toString().substring("jar:".length());
        String entryName = resourceUrlString.substring((bang = resourceUrlString.lastIndexOf(33)) + 1);
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        }
        URI jarUri = new URI(resourceUrlString.substring(0, bang));
        try (JarFile jar = new JarFile(new File(jarUri));){
            StringReader stringReader;
            block12: {
                InputStream in = jar.getInputStream(jar.getJarEntry(entryName));
                try {
                    String contents = new String(ByteStreams.toByteArray(in), StandardCharsets.UTF_8);
                    stringReader = new StringReader(contents);
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return stringReader;
        }
    }

    private static Reader readerFromFile(URL resourceUrl) throws IOException, URISyntaxException {
        File resourceFile = new File(resourceUrl.toURI());
        return new InputStreamReader((InputStream)new FileInputStream(resourceFile), StandardCharsets.UTF_8);
    }

    private static Object fieldValue(Field field, Object container) {
        try {
            return field.get(container);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }
}

