/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.model.Event;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.ChunkContextGenerator;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.chunking.Parser;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;

public abstract class AbstractParserEventStream
extends AbstractEventStream<Parse> {
    private ChunkerContextGenerator chunkerContextGenerator;
    private POSContextGenerator tagContextGenerator;
    protected HeadRules rules;
    protected Set<String> punctSet;
    protected ParserEventTypeEnum etype;
    protected boolean fixPossesives;
    protected Dictionary dict;

    public AbstractParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype, Dictionary dict) {
        super(d);
        this.dict = dict;
        if (etype == ParserEventTypeEnum.CHUNK) {
            this.chunkerContextGenerator = new ChunkContextGenerator();
        } else if (etype == ParserEventTypeEnum.TAG) {
            this.tagContextGenerator = new DefaultPOSContextGenerator(null);
        }
        this.rules = rules;
        this.punctSet = rules.getPunctuationTags();
        this.etype = etype;
        this.init();
    }

    @Override
    protected Iterator<Event> createEvents(Parse sample) {
        ArrayList<Event> newEvents = new ArrayList<Event>();
        Parse.pruneParse(sample);
        if (this.fixPossesives) {
            Parse.fixPossesives(sample);
        }
        sample.updateHeads(this.rules);
        Parse[] chunks = AbstractParserEventStream.getInitialChunks(sample);
        if (this.etype == ParserEventTypeEnum.TAG) {
            this.addTagEvents(newEvents, chunks);
        } else if (this.etype == ParserEventTypeEnum.CHUNK) {
            this.addChunkEvents(newEvents, chunks);
        } else {
            this.addParseEvents(newEvents, Parser.collapsePunctuation(chunks, this.punctSet));
        }
        return newEvents.iterator();
    }

    protected void init() {
        this.fixPossesives = false;
    }

    public AbstractParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype) {
        this(d, rules, etype, null);
    }

    public static Parse[] getInitialChunks(Parse p) {
        ArrayList<Parse> chunks = new ArrayList<Parse>();
        AbstractParserEventStream.getInitialChunks(p, chunks);
        return chunks.toArray(new Parse[chunks.size()]);
    }

    private static void getInitialChunks(Parse p, List<Parse> ichunks) {
        if (p.isPosTag()) {
            ichunks.add(p);
        } else {
            Parse[] kids = p.getChildren();
            boolean allKidsAreTags = true;
            for (Parse kid : kids) {
                if (kid.isPosTag()) continue;
                allKidsAreTags = false;
                break;
            }
            if (allKidsAreTags) {
                ichunks.add(p);
            } else {
                for (Parse kid : kids) {
                    AbstractParserEventStream.getInitialChunks(kid, ichunks);
                }
            }
        }
    }

    protected abstract void addParseEvents(List<Event> var1, Parse[] var2);

    private void addChunkEvents(List<Event> chunkEvents, Parse[] chunks) {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        for (Parse c : chunks) {
            Parse[] kids;
            if (c.isPosTag()) {
                toks.add(c.getCoveredText());
                tags.add(c.getType());
                preds.add("O");
                continue;
            }
            boolean start = true;
            String ctype = c.getType();
            for (Parse tok : kids = c.getChildren()) {
                toks.add(tok.getCoveredText());
                tags.add(tok.getType());
                if (start) {
                    preds.add("S-" + ctype);
                    start = false;
                    continue;
                }
                preds.add("C-" + ctype);
            }
        }
        int tl = toks.size();
        for (int ti = 0; ti < tl; ++ti) {
            chunkEvents.add(new Event((String)preds.get(ti), this.chunkerContextGenerator.getContext(ti, toks.toArray(new String[toks.size()]), tags.toArray(new String[tags.size()]), preds.toArray(new String[preds.size()]))));
        }
    }

    private void addTagEvents(List<Event> tagEvents, Parse[] chunks) {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        for (Parse c : chunks) {
            Parse[] kids;
            if (c.isPosTag()) {
                toks.add(c.getCoveredText());
                preds.add(c.getType());
                continue;
            }
            for (Parse tok : kids = c.getChildren()) {
                toks.add(tok.getCoveredText());
                preds.add(tok.getType());
            }
        }
        int tl = toks.size();
        for (int ti = 0; ti < tl; ++ti) {
            tagEvents.add(new Event((String)preds.get(ti), this.tagContextGenerator.getContext(ti, toks.toArray(new String[toks.size()]), preds.toArray(new String[preds.size()]), (Object[])null)));
        }
    }

    protected boolean lastChild(Parse child, Parse parent) {
        Parse[] kids = AbstractBottomUpParser.collapsePunctuation(parent.getChildren(), this.punctSet);
        return kids[kids.length - 1] == child;
    }
}

