/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryLimiter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemoryLimiterImpl
implements MemoryLimiter {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MemoryLimiterImpl.class);
    private final @UnknownKeyFor @NonNull @Initialized long minBlockSize;
    private final @UnknownKeyFor @NonNull @Initialized long maxBlockSize;
    private final @UnknownKeyFor @NonNull @Initialized long maxAvailable;
    @GuardedBy(value="this")
    private @UnknownKeyFor @NonNull @Initialized long available;

    public MemoryLimiterImpl(@UnknownKeyFor @NonNull @Initialized long minBlockSize, @UnknownKeyFor @NonNull @Initialized long maxBlockSize, @UnknownKeyFor @NonNull @Initialized long maxAvailable) {
        this.minBlockSize = minBlockSize;
        this.maxBlockSize = maxBlockSize;
        this.maxAvailable = maxAvailable;
        this.available = maxAvailable;
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized MemoryLimiterImpl. @UnknownKeyFor @NonNull @Initialized Block claim(@UnknownKeyFor @NonNull @Initialized long toAcquire) {
        toAcquire = Math.max(Math.min(toAcquire, this.available / 2L), this.minBlockSize);
        this.available -= toAcquire;
        return new Block(toAcquire);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long minBlockSize() {
        return this.minBlockSize;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long maxBlockSize() {
        return this.maxBlockSize;
    }

    private synchronized void release(@UnknownKeyFor @NonNull @Initialized long toRelease) {
        this.available += toRelease;
        Preconditions.checkState((this.available <= this.maxAvailable ? 1 : 0) != 0);
    }

    public class Block
    implements MemoryLimiter.Block {
        public final @UnknownKeyFor @NonNull @Initialized long claimed;
        private @UnknownKeyFor @NonNull @Initialized boolean released = false;

        private Block(long claimed) {
            this.claimed = claimed;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long claimed() {
            return this.claimed;
        }

        @Override
        public void close() {
            Preconditions.checkState((!this.released ? 1 : 0) != 0);
            this.released = true;
            MemoryLimiterImpl.this.release(this.claimed);
        }

        public void finalize() {
            if (!this.released) {
                LOG.error("Failed to release memory block- likely SDF implementation error.");
                this.close();
            }
        }
    }
}

