/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.CloudRegionOrZone;
import com.google.cloud.pubsublite.ProjectId;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.extensions.protobuf.ProtoByteUtils;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteIO;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.Uuid;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class PubsubLiteWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<PubsubLiteWriteSchemaTransformConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized String SUPPORTED_FORMATS_STR = "RAW,JSON,AVRO,PROTO";
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> SUPPORTED_FORMATS = Sets.newHashSet((Object[])"RAW,JSON,AVRO,PROTO".split(","));
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PubSubMessage> OUTPUT_TAG = new TupleTag<PubSubMessage>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR_TAG = new TupleTag<Row>(){};
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PubsubLiteWriteSchemaTransformProvider.class);

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubLiteWriteSchemaTransformConfiguration> configurationClass() {
        return PubsubLiteWriteSchemaTransformConfiguration.class;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(final @UnknownKeyFor @NonNull @Initialized PubsubLiteWriteSchemaTransformConfiguration configuration) {
        if (!SUPPORTED_FORMATS.contains(configuration.getFormat())) {
            throw new IllegalArgumentException("Format " + configuration.getFormat() + " is not supported. Supported formats are: " + String.join((CharSequence)", ", SUPPORTED_FORMATS));
        }
        return new SchemaTransform(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                void var9_18;
                ArrayList<String> attributesConfigValue = configuration.getAttributes();
                String attributeId = configuration.getAttributeId();
                ArrayList<String> attributes = attributesConfigValue != null ? attributesConfigValue : new ArrayList<String>();
                Schema inputSchema = !attributes.isEmpty() ? PubsubLiteWriteSchemaTransformProvider.getSchemaWithoutAttributes(input.get("input").getSchema(), attributes) : input.get("input").getSchema();
                ErrorHandling errorHandling = configuration.getErrorHandling();
                boolean handleErrors = ErrorHandling.hasOutput((ErrorHandling)errorHandling);
                Schema errorSchema = ErrorHandling.errorSchema((Schema)inputSchema);
                if (configuration.getFormat().equals("RAW")) {
                    int numFields = inputSchema.getFields().size();
                    if (numFields != 1) {
                        throw new IllegalArgumentException("Expecting exactly one field, found " + numFields);
                    }
                    if (!inputSchema.getField(0).getType().equals((Object)Schema.FieldType.BYTES)) {
                        throw new IllegalArgumentException("The input schema must have exactly one field of type byte.");
                    }
                    SerializableFunction<Row, byte[]> serializableFunction = PubsubLiteWriteSchemaTransformProvider.getRowToRawBytesFunction(inputSchema.getField(0).getName());
                } else if (configuration.getFormat().equals("PROTO")) {
                    String descriptorPath = configuration.getFileDescriptorPath();
                    String schema = configuration.getSchema();
                    String messageName = configuration.getMessageName();
                    if (descriptorPath != null && messageName != null) {
                        SerializableFunction serializableFunction = ProtoByteUtils.getRowToProtoBytes((String)descriptorPath, (String)messageName);
                    } else {
                        if (schema == null || messageName == null) throw new IllegalArgumentException("At least a descriptorPath or a PROTO schema is required.");
                        SerializableFunction serializableFunction = ProtoByteUtils.getRowToProtoBytesFromSchema((String)schema, (String)messageName);
                    }
                } else if (configuration.getFormat().equals("JSON")) {
                    SimpleFunction simpleFunction = JsonUtils.getRowToJsonBytesFunction((Schema)inputSchema);
                } else {
                    SimpleFunction simpleFunction = AvroUtils.getRowToAvroBytesFunction((Schema)inputSchema);
                }
                PCollectionTuple outputTuple = (PCollectionTuple)input.get("input").apply("Map Rows to PubSubMessages", (PTransform)ParDo.of((DoFn)new ErrorCounterFn("PubSubLite-write-error-counter", (SerializableFunction<Row, byte[]>)var9_18, errorSchema, handleErrors, attributes, inputSchema)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
                ((PCollection)outputTuple.get(OUTPUT_TAG).apply("Add UUIDs", attributeId != null && !attributeId.isEmpty() ? new SetUuidFromPubSubMessage(attributeId) : PubsubLiteIO.addUuids())).apply("Write to PS Lite", PubsubLiteIO.write(PublisherOptions.newBuilder().setTopicPath(((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setProject(ProjectId.of((String)configuration.getProject()))).setName(TopicName.of((String)configuration.getTopicName())).setLocation(CloudRegionOrZone.parse((String)configuration.getLocation()))).build()).build()));
                PCollection errorOutput = outputTuple.get(ERROR_TAG).setRowSchema(ErrorHandling.errorSchema((Schema)errorSchema));
                String outputString = errorHandling != null ? errorHandling.getOutput() : "errors";
                return PCollectionRowTuple.of((String)(handleErrors ? outputString : "errors"), (PCollection)errorOutput);
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema getSchemaWithoutAttributes(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes) {
        Schema.Builder schemaBuilder = Schema.builder();
        inputSchema.getFields().forEach(field -> {
            if (!attributes.contains(field.getName())) {
                schemaBuilder.addField(field.getName(), field.getType());
            }
        });
        return schemaBuilder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValues> getStringAttributeValuesMap(@UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes) {
        HashMap<String, AttributeValues> attributeValuesHashMap = new HashMap<String, AttributeValues>();
        attributes.forEach(attribute -> {
            String value = (String)row.getValue(attribute);
            if (value != null) {
                attributeValuesHashMap.put((String)attribute, AttributeValues.newBuilder().addValues(ByteString.copyFromUtf8((String)value)).build());
            }
        });
        return attributeValuesHashMap;
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getRowToRawBytesFunction(final @UnknownKeyFor @NonNull @Initialized String rowFieldName) {
        return new SimpleFunction<Row, byte[]>(){

            public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized Row input) {
                byte[] rawBytes = input.getBytes(rowFieldName);
                if (rawBytes == null) {
                    throw new NullPointerException();
                }
                return rawBytes;
            }
        };
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:pubsublite_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList("input");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList("errors");
    }

    public static class SetUuidFromPubSubMessage
    extends PTransform<PCollection<PubSubMessage>, PCollection<PubSubMessage>> {
        private final @UnknownKeyFor @NonNull @Initialized String attributeId;

        public SetUuidFromPubSubMessage(@UnknownKeyFor @NonNull @Initialized String attributeId) {
            this.attributeId = attributeId;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubSubMessage> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubSubMessage> input) {
            return (PCollection)input.apply("SetUuidFromPubSubMessage", (PTransform)ParDo.of((DoFn)new SetUuidFn(this.attributeId)));
        }

        public static class SetUuidFn
        extends DoFn<PubSubMessage, PubSubMessage> {
            private final @UnknownKeyFor @NonNull @Initialized String attributeId;

            public SetUuidFn(@UnknownKeyFor @NonNull @Initialized String attributeId) {
                this.attributeId = attributeId;
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PubSubMessage input, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PubSubMessage> outputReceiver) {
                PubSubMessage.Builder builder = input.toBuilder();
                builder.putAttributes(this.attributeId, AttributeValues.newBuilder().addValues(Uuid.random().value()).build());
                outputReceiver.output((Object)builder.build());
            }
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class PubsubLiteWriteSchemaTransformConfiguration {
        public void validate() {
            String dataFormat = this.getFormat();
            String inputSchema = this.getSchema();
            String messageName = this.getMessageName();
            String descriptorPath = this.getFileDescriptorPath();
            if (dataFormat != null && dataFormat.equals("PROTO")) {
                assert (messageName != null) : "Expecting messageName to be non-null.";
                assert (descriptorPath != null && inputSchema != null) : "You must include a descriptorPath or a PROTO schema but not both.";
            }
        }

        @SchemaFieldDescription(value="The GCP project where the Pubsub Lite reservation resides. This can be a project number of a project ID.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getProject();

        @SchemaFieldDescription(value="The region or zone where the Pubsub Lite reservation resides.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getLocation();

        @SchemaFieldDescription(value="The name of the topic to publish data into. This will be concatenated with the project and location parameters to build a full topic path.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getTopicName();

        @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub Lite. Valid options are: RAW,JSON,AVRO,PROTO")
        public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

        @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
        public abstract @Nullable @UnknownKeyFor @Initialized ErrorHandling getErrorHandling();

        @SchemaFieldDescription(value="List of attribute keys whose values will be pulled out as Pubsub Lite message attributes.  For example, if the format is `JSON` and attributes is `[\"a\", \"b\"]` then elements of the form `Row(any_field=..., a=..., b=...)` will result in Pubsub Lite messages whose payload has the contents of any_field and whose attribute will be populated with the values of `a` and `b`.")
        public abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getAttributes();

        @SchemaFieldDescription(value="If set, will set an attribute for each Pubsub Lite message with the given name and a unique value. This attribute can then be used in a ReadFromPubSubLite PTransform to deduplicate messages.")
        public abstract @Nullable @UnknownKeyFor @Initialized String getAttributeId();

        @SchemaFieldDescription(value="The path to the Protocol Buffer File Descriptor Set file. This file is used for schema definition and message serialization.")
        public abstract @Nullable @UnknownKeyFor @Initialized String getFileDescriptorPath();

        @SchemaFieldDescription(value="The name of the Protocol Buffer message to be used for schema extraction and data conversion.")
        public abstract @Nullable @UnknownKeyFor @Initialized String getMessageName();

        public abstract @Nullable @UnknownKeyFor @Initialized String getSchema();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProject(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTopicName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributes(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributeId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFileDescriptorPath(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setMessageName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized PubsubLiteWriteSchemaTransformConfiguration build();
        }
    }

    public static class ErrorCounterFn
    extends DoFn<Row, PubSubMessage> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toBytesFn;
        private final @UnknownKeyFor @NonNull @Initialized Counter errorCounter;
        private @UnknownKeyFor @NonNull @Initialized long errorsInBundle = 0L;
        private final @UnknownKeyFor @NonNull @Initialized Schema errorSchema;
        private final @UnknownKeyFor @NonNull @Initialized boolean handleErrors;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes;
        private final @UnknownKeyFor @NonNull @Initialized Schema schemaWithoutAttributes;

        public ErrorCounterFn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toBytesFn, @UnknownKeyFor @NonNull @Initialized Schema errorSchema, @UnknownKeyFor @NonNull @Initialized boolean handleErrors) {
            this.toBytesFn = toBytesFn;
            this.errorCounter = Metrics.counter(PubsubLiteWriteSchemaTransformProvider.class, (String)name);
            this.errorSchema = errorSchema;
            this.handleErrors = handleErrors;
            this.attributes = new ArrayList<String>();
            this.schemaWithoutAttributes = Schema.builder().build();
        }

        public ErrorCounterFn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toBytesFn, @UnknownKeyFor @NonNull @Initialized Schema errorSchema, @UnknownKeyFor @NonNull @Initialized boolean handleErrors, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes, @UnknownKeyFor @NonNull @Initialized Schema schemaWithoutAttributes) {
            this.toBytesFn = toBytesFn;
            this.errorCounter = Metrics.counter(PubsubLiteWriteSchemaTransformProvider.class, (String)name);
            this.errorSchema = errorSchema;
            this.handleErrors = handleErrors;
            this.attributes = attributes;
            this.schemaWithoutAttributes = schemaWithoutAttributes;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
            try {
                PubSubMessage message;
                if (this.attributes.isEmpty()) {
                    message = PubSubMessage.newBuilder().setData(ByteString.copyFrom((byte[])Objects.requireNonNull((byte[])this.toBytesFn.apply((Object)row)))).build();
                } else {
                    Row.Builder builder = Row.withSchema((Schema)this.schemaWithoutAttributes);
                    this.schemaWithoutAttributes.getFields().forEach(field -> builder.addValue(row.getValue(field.getName())));
                    Row resultingRow = builder.build();
                    Map attributeValuesHashMap = PubsubLiteWriteSchemaTransformProvider.getStringAttributeValuesMap(row, this.attributes);
                    message = PubSubMessage.newBuilder().setData(ByteString.copyFrom((byte[])Objects.requireNonNull((byte[])this.toBytesFn.apply((Object)resultingRow)))).putAllAttributes(attributeValuesHashMap).build();
                }
                receiver.get(OUTPUT_TAG).output((Object)message);
            }
            catch (Exception e) {
                if (!this.handleErrors) {
                    throw new RuntimeException(e);
                }
                ++this.errorsInBundle;
                LOG.warn("Error while processing the element", (Throwable)e);
                receiver.get(ERROR_TAG).output((Object)ErrorHandling.errorRecord((Schema)this.errorSchema, (Row)row, (Throwable)e));
            }
        }

        @DoFn.FinishBundle
        public void finish() {
            this.errorCounter.inc(this.errorsInBundle);
            this.errorsInBundle = 0L;
        }
    }
}

