/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ClickHouseHttpResponse {
    private final ClickHouseHttpConnection connection;
    private final ClickHouseInputStream input;
    protected final String serverDisplayName;
    protected final String queryId;
    protected final ClickHouseFormat format;
    protected final TimeZone timeZone;
    protected final ClickHouseResponseSummary summary;

    private static long getLongValue(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    protected ClickHouseConfig getConfig(ClickHouseRequest<?> request) {
        ClickHouseConfig config = request.getConfig();
        if (this.format != null && this.format != config.getFormat()) {
            HashMap<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
            options.putAll(config.getAllOptions());
            options.put(ClickHouseClientOption.FORMAT, (Serializable)((Object)this.format));
            config = new ClickHouseConfig(options, config.getDefaultCredentials(), config.getNodeSelector(), config.getMetricRegistry());
        }
        return config;
    }

    public ClickHouseHttpResponse(ClickHouseHttpConnection connection, ClickHouseInputStream input, String serverDisplayName, String queryId, String summary, ClickHouseFormat format, TimeZone timeZone) {
        if (connection == null || input == null) {
            throw new IllegalArgumentException("Non-null connection and input stream are required");
        }
        this.connection = connection;
        this.input = input;
        this.serverDisplayName = !ClickHouseChecker.isNullOrEmpty(serverDisplayName) ? serverDisplayName : connection.server.getHost();
        this.queryId = !ClickHouseChecker.isNullOrEmpty(queryId) ? queryId : "";
        Map map = (Map)ClickHouseUtils.parseJson(!ClickHouseChecker.isNullOrEmpty(summary) ? summary : "{}");
        this.summary = new ClickHouseResponseSummary(new ClickHouseResponseSummary.Progress(ClickHouseHttpResponse.getLongValue(map, "read_rows"), ClickHouseHttpResponse.getLongValue(map, "read_bytes"), ClickHouseHttpResponse.getLongValue(map, "total_rows_to_read"), ClickHouseHttpResponse.getLongValue(map, "written_rows"), ClickHouseHttpResponse.getLongValue(map, "written_bytes"), ClickHouseHttpResponse.getLongValue(map, "elapsed_ns"), ClickHouseHttpResponse.getLongValue(map, "result_rows"), this.queryId), null);
        this.format = format != null ? format : connection.config.getFormat();
        this.timeZone = timeZone != null ? timeZone : connection.config.getServerTimeZone();
    }

    public ClickHouseInputStream getInputStream() {
        return this.input;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

