/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.model.anthropic.AnthropicMessage;
import java.util.List;

public class AnthropicCreateMessageRequest {
    String model;
    List<AnthropicMessage> messages;
    String system;
    int maxTokens;
    List<String> stopSequences;
    boolean stream;
    Double temperature;
    Double topP;
    Integer topK;

    AnthropicCreateMessageRequest(String model, List<AnthropicMessage> messages, String system, int maxTokens, List<String> stopSequences, boolean stream, Double temperature, Double topP, Integer topK) {
        this.model = model;
        this.messages = messages;
        this.system = system;
        this.maxTokens = maxTokens;
        this.stopSequences = stopSequences;
        this.stream = stream;
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
    }

    public static AnthropicCreateMessageRequestBuilder builder() {
        return new AnthropicCreateMessageRequestBuilder();
    }

    public static class AnthropicCreateMessageRequestBuilder {
        private String model;
        private List<AnthropicMessage> messages;
        private String system;
        private int maxTokens;
        private List<String> stopSequences;
        private boolean stream;
        private Double temperature;
        private Double topP;
        private Integer topK;

        AnthropicCreateMessageRequestBuilder() {
        }

        public AnthropicCreateMessageRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder messages(List<AnthropicMessage> messages) {
            this.messages = messages;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder system(String system) {
            this.system = system;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public AnthropicCreateMessageRequestBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public AnthropicCreateMessageRequest build() {
            return new AnthropicCreateMessageRequest(this.model, this.messages, this.system, this.maxTokens, this.stopSequences, this.stream, this.temperature, this.topP, this.topK);
        }

        public String toString() {
            return "AnthropicCreateMessageRequest.AnthropicCreateMessageRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", system=" + this.system + ", maxTokens=" + this.maxTokens + ", stopSequences=" + this.stopSequences + ", stream=" + this.stream + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ")";
        }
    }
}

