/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.ArrayDeque;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.spark.translation.SparkInputDataProcessor;
import org.apache.beam.runners.spark.translation.SparkProcessContext;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.AbstractIterator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Tuple2;

class UnboundedSparkInputDataProcessor<@UnknownKeyFor FnInputT, @UnknownKeyFor FnOutputT>
implements SparkInputDataProcessor<FnInputT, FnOutputT, Tuple2<TupleTag<?>, WindowedValue<?>>> {
    private final @UnknownKeyFor @NonNull @Initialized UnboundedDoFnOutputManager outputManager = new UnboundedDoFnOutputManager();

    UnboundedSparkInputDataProcessor() {
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager getOutputManager() {
        return this.outputManager;
    }

    @Override
    public <K> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> createOutputIterator(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> input, @UnknownKeyFor @NonNull @Initialized SparkProcessContext<K, FnInputT, FnOutputT> ctx) {
        return new UnboundedInOutIterator<K>(input, ctx);
    }

    private class UnboundedInOutIterator<@UnknownKeyFor K>
    extends AbstractIterator<Tuple2<TupleTag<?>, WindowedValue<?>>> {
        private final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<FnInputT>> inputIterator;
        private final @UnknownKeyFor @NonNull @Initialized SparkProcessContext<K, FnInputT, FnOutputT> ctx;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> outputIterator;
        private @UnknownKeyFor @NonNull @Initialized boolean isBundleStarted;
        private @UnknownKeyFor @NonNull @Initialized boolean isBundleFinished;

        UnboundedInOutIterator(@UnknownKeyFor @NonNull @Initialized Iterator<WindowedValue<FnInputT>> iterator, SparkProcessContext<K, FnInputT, FnOutputT> ctx) {
            this.inputIterator = iterator;
            this.ctx = ctx;
            this.outputIterator = UnboundedSparkInputDataProcessor.this.outputManager.iterator();
        }

        @CheckForNull
        protected /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @Nullable @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> computeNext() {
            try {
                if (!this.isBundleStarted) {
                    this.isBundleStarted = true;
                    this.ctx.getDoFnRunner().startBundle();
                }
                while (true) {
                    if (this.outputIterator.hasNext()) {
                        return this.outputIterator.next();
                    }
                    UnboundedSparkInputDataProcessor.this.outputManager.clear();
                    if (this.inputIterator.hasNext()) {
                        this.ctx.getDoFnRunner().processElement(this.inputIterator.next());
                        this.outputIterator = UnboundedSparkInputDataProcessor.this.outputManager.iterator();
                        continue;
                    }
                    if (this.ctx.getTimerDataIterator().hasNext()) {
                        this.fireTimer(this.ctx.getTimerDataIterator().next());
                        this.outputIterator = UnboundedSparkInputDataProcessor.this.outputManager.iterator();
                        continue;
                    }
                    if (this.isBundleFinished) break;
                    this.isBundleFinished = true;
                    this.ctx.getDoFnRunner().finishBundle();
                    this.outputIterator = UnboundedSparkInputDataProcessor.this.outputManager.iterator();
                }
                DoFnInvokers.invokerFor(this.ctx.getDoFn()).invokeTeardown();
                return (Tuple2)this.endOfData();
            }
            catch (RuntimeException re) {
                DoFnInvokers.invokerFor(this.ctx.getDoFn()).invokeTeardown();
                throw re;
            }
        }

        private void fireTimer(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
            StateNamespace namespace = timer.getNamespace();
            Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
            BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
            this.ctx.getDoFnRunner().onTimer(timer.getTimerId(), timer.getTimerFamilyId(), this.ctx.getKey(), window, timer.getTimestamp(), timer.getOutputTimestamp(), timer.getDomain());
        }
    }

    private static class UnboundedDoFnOutputManager
    implements DoFnRunners.OutputManager,
    Iterable<Tuple2<TupleTag<?>, WindowedValue<?>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ArrayDeque<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> outputs = new ArrayDeque();

        private UnboundedDoFnOutputManager() {
        }

        public void clear() {
            this.outputs.clear();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> iterator() {
            return this.outputs.iterator();
        }

        public synchronized <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
            this.outputs.addLast(new Tuple2(tag, output));
        }
    }
}

