/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface TestSparkPipelineOptions
extends SparkPipelineOptions,
TestPipelineOptions {
    @Description(value="A special flag that forces streaming in tests.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean isForceStreaming();

    public void setForceStreaming(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="A hard-coded expected number of assertions for this test pipeline.")
    public @Nullable @UnknownKeyFor @Initialized Integer getExpectedAssertions();

    public void setExpectedAssertions(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="A watermark (time in millis) that causes a pipeline that reads from an unbounded source to stop.")
    @Default.InstanceFactory(value=DefaultStopPipelineWatermarkFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Long getStopPipelineWatermark();

    public void setStopPipelineWatermark(@UnknownKeyFor @NonNull @Initialized Long var1);

    public static class DefaultStopPipelineWatermarkFactory
    implements DefaultValueFactory<Long> {
        public @UnknownKeyFor @NonNull @Initialized Long create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis();
        }
    }
}

