/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Keys;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public final class Deduplicate {
    public static final @UnknownKeyFor @NonNull @Initialized TimeDomain DEFAULT_TIME_DOMAIN = TimeDomain.PROCESSING_TIME;
    public static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_DURATION = Duration.standardMinutes((long)10L);

    public static <T> @UnknownKeyFor @NonNull @Initialized Values<T> values() {
        return new Values(DEFAULT_TIME_DOMAIN, DEFAULT_DURATION);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized KeyedValues<K, V> keyedValues() {
        return new KeyedValues(DEFAULT_TIME_DOMAIN, DEFAULT_DURATION);
    }

    public static <T, IdT> @UnknownKeyFor @NonNull @Initialized WithRepresentativeValues<T, IdT> withRepresentativeValueFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, IdT> representativeValueFn) {
        return new WithRepresentativeValues(DEFAULT_TIME_DOMAIN, DEFAULT_DURATION, representativeValueFn, null, null);
    }

    private Deduplicate() {
    }

    private static class DeduplicateFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KV<K, V>, KV<K, V>> {
        private static final @UnknownKeyFor @NonNull @Initialized String EXPIRY_TIMER = "expiryTimer";
        private static final @UnknownKeyFor @NonNull @Initialized String SEEN_STATE = "seen";
        @DoFn.TimerId(value="expiryTimer")
        private final @UnknownKeyFor @NonNull @Initialized TimerSpec expiryTimerSpec;
        @DoFn.StateId(value="seen")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Boolean>> seenState = StateSpecs.value(BooleanCoder.of());
        private final @UnknownKeyFor @NonNull @Initialized Duration duration;

        private DeduplicateFn(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain, @UnknownKeyFor @NonNull @Initialized Duration duration) {
            this.expiryTimerSpec = TimerSpecs.timer(timeDomain);
            this.duration = duration;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, V> element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, V>> receiver, @DoFn.StateId(value="seen") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Boolean> seenState, @DoFn.TimerId(value="expiryTimer") @UnknownKeyFor @NonNull @Initialized Timer expiryTimer) {
            Boolean seen = seenState.read();
            if (seen == null) {
                expiryTimer.offset(this.duration).withNoOutputTimestamp().setRelative();
                seenState.write(true);
                receiver.output(element);
            }
        }

        @DoFn.OnTimer(value="expiryTimer")
        public void onExpiry(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized OnTimerContext context, @DoFn.StateId(value="seen") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Boolean> seenState) {
            seenState.clear();
        }
    }

    public static final class KeyedValues<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, V>>> {
        private final @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain;
        private final @UnknownKeyFor @NonNull @Initialized Duration duration;

        private KeyedValues(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain, @UnknownKeyFor @NonNull @Initialized Duration duration) {
            this.timeDomain = timeDomain;
            this.duration = duration;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            return (PCollection)input.apply(ParDo.of(new DeduplicateFn(this.timeDomain, this.duration)));
        }

        public @UnknownKeyFor @NonNull @Initialized KeyedValues<K, V> withTimeDomain(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            return new KeyedValues<K, V>(timeDomain, this.duration);
        }

        public @UnknownKeyFor @NonNull @Initialized KeyedValues<K, V> withDuration(@UnknownKeyFor @NonNull @Initialized Duration duration) {
            return new KeyedValues<K, V>(this.timeDomain, duration);
        }
    }

    public static final class WithRepresentativeValues<@UnknownKeyFor T, @UnknownKeyFor IdT>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, IdT> fn;
        private final @Nullable @UnknownKeyFor @Initialized TypeDescriptor<IdT> type;
        private final @Nullable @UnknownKeyFor @Initialized Coder<IdT> coder;
        private final @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain;
        private final @UnknownKeyFor @NonNull @Initialized Duration duration;

        private WithRepresentativeValues(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain, @UnknownKeyFor @NonNull @Initialized Duration duration, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, IdT> fn, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<IdT> type, @Nullable @UnknownKeyFor @Initialized Coder<IdT> coder) {
            this.timeDomain = timeDomain;
            this.duration = duration;
            this.fn = fn;
            this.type = type;
            this.coder = coder;
        }

        public @UnknownKeyFor @NonNull @Initialized WithRepresentativeValues<T, IdT> withRepresentativeType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<IdT> type) {
            return new WithRepresentativeValues<T, IdT>(this.timeDomain, this.duration, this.fn, type, null);
        }

        public @UnknownKeyFor @NonNull @Initialized WithRepresentativeValues<T, IdT> withRepresentativeCoder(@UnknownKeyFor @NonNull @Initialized Coder<IdT> coder) {
            return new WithRepresentativeValues<T, IdT>(this.timeDomain, this.duration, this.fn, null, coder);
        }

        public @UnknownKeyFor @NonNull @Initialized WithRepresentativeValues<T, IdT> withTimeDomain(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            return new WithRepresentativeValues<T, IdT>(timeDomain, this.duration, this.fn, this.type, this.coder);
        }

        public @UnknownKeyFor @NonNull @Initialized WithRepresentativeValues<T, IdT> withDuration(@UnknownKeyFor @NonNull @Initialized Duration duration) {
            return new WithRepresentativeValues<T, IdT>(this.timeDomain, duration, this.fn, this.type, this.coder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            WithKeys withKeys = WithKeys.of(this.fn);
            if (this.type != null) {
                withKeys = withKeys.withKeyType(this.type);
            }
            PCollection inputWithKey = (PCollection)input.apply(withKeys);
            if (this.coder != null) {
                inputWithKey.setCoder(KvCoder.of(this.coder, input.getCoder()));
            }
            return (PCollection)((PCollection)inputWithKey.apply(new KeyedValues(this.timeDomain, this.duration))).apply(org.apache.beam.sdk.transforms.Values.create());
        }
    }

    public static final class Values<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain;
        private final @UnknownKeyFor @NonNull @Initialized Duration duration;

        private Values(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain, @UnknownKeyFor @NonNull @Initialized Duration duration) {
            this.timeDomain = timeDomain;
            this.duration = duration;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("KeyByElement", MapElements.via(new SimpleFunction<T, KV<T, Void>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized KV<T, @UnknownKeyFor @Nullable @Initialized Void> apply(T element) {
                    return KV.of(element, null);
                }
            }))).apply(new KeyedValues(this.timeDomain, this.duration))).apply(Keys.create());
        }

        public @UnknownKeyFor @NonNull @Initialized Values<T> withTimeDomain(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            return new Values<T>(timeDomain, this.duration);
        }

        public @UnknownKeyFor @NonNull @Initialized Values<T> withDuration(@UnknownKeyFor @NonNull @Initialized Duration duration) {
            return new Values<T>(this.timeDomain, duration);
        }
    }
}

