/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProviderV2;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.SetterBasedCreatorFactory;
import org.apache.beam.sdk.schemas.annotations.SchemaCaseFormat;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldNumber;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class JavaBeanSchema
extends GetterBasedSchemaProviderV2 {
    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized Schema schemaFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(typeDescriptor, GetterTypeSupplier.INSTANCE);
        if (ReflectUtils.getAnnotatedCreateMethod(typeDescriptor.getRawType()) == null && ReflectUtils.getAnnotatedConstructor(typeDescriptor.getRawType()) == null) {
            JavaBeanUtils.validateJavaBean(GetterTypeSupplier.INSTANCE.get(typeDescriptor, schema), SetterTypeSupplier.INSTANCE.get(typeDescriptor, schema), schema);
        }
        return schema;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> fieldValueGetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return JavaBeanUtils.getGetters(targetTypeDescriptor, schema, GetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return JavaBeanUtils.getFieldTypes(targetTypeDescriptor, schema, GetterTypeSupplier.INSTANCE);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        Method annotated = ReflectUtils.getAnnotatedCreateMethod(targetTypeDescriptor.getRawType());
        if (annotated != null) {
            return JavaBeanUtils.getStaticCreator(targetTypeDescriptor, annotated, schema, GetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
        Constructor constructor = ReflectUtils.getAnnotatedConstructor(targetTypeDescriptor.getRawType());
        if (constructor != null) {
            return JavaBeanUtils.getConstructorCreator(targetTypeDescriptor, constructor, schema, GetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
        SetterBasedCreatorFactory setterBasedFactory = new SetterBasedCreatorFactory(new JavaBeanSetterFactory());
        return (SchemaUserTypeCreator)setterBasedFactory.create(targetTypeDescriptor, schema);
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }

    private static class JavaBeanSetterFactory
    implements Factory<List<FieldValueSetter>> {
        private JavaBeanSetterFactory() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueSetter> create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            return JavaBeanUtils.getSetters(targetTypeDescriptor, schema, SetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
    }

    @VisibleForTesting
    public static class SetterTypeSupplier
    implements FieldValueTypeSupplier {
        private static final @UnknownKeyFor @NonNull @Initialized SetterTypeSupplier INSTANCE = new SetterTypeSupplier();

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor) {
            return ReflectUtils.getMethods(typeDescriptor.getRawType()).stream().filter(ReflectUtils::isSetter).filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).map(FieldValueTypeInformation::forSetter).map(t -> {
                if (t.getMethod().getAnnotation(SchemaFieldNumber.class) != null) {
                    throw new RuntimeException(String.format("@SchemaFieldNumber can only be used on getters in Java Beans. Found on setter '%s'", t.getMethod().getName()));
                }
                if (t.getMethod().getAnnotation(SchemaFieldName.class) != null) {
                    throw new RuntimeException(String.format("@SchemaFieldName can only be used on getters in Java Beans. Found on setter '%s'", t.getMethod().getName()));
                }
                if (t.getMethod().getAnnotation(SchemaCaseFormat.class) != null) {
                    throw new RuntimeException(String.format("@SchemaCaseFormat can only be used on getters in Java Beans. Found on setter '%s'", t.getMethod().getName()));
                }
                return t;
            }).collect(Collectors.toList());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return System.identityHashCode(this);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }
    }

    @VisibleForTesting
    public static class GetterTypeSupplier
    implements FieldValueTypeSupplier {
        public static final @UnknownKeyFor @NonNull @Initialized GetterTypeSupplier INSTANCE = new GetterTypeSupplier();

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor) {
            List methods = ReflectUtils.getMethods(typeDescriptor.getRawType()).stream().filter(ReflectUtils::isGetter).filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).collect(Collectors.toList());
            ArrayList types = Lists.newArrayListWithCapacity((int)methods.size());
            for (int i = 0; i < methods.size(); ++i) {
                types.add(FieldValueTypeInformation.forGetter((Method)methods.get(i), i));
            }
            types.sort(Comparator.comparing(FieldValueTypeInformation::getNumber));
            GetterTypeSupplier.validateFieldNumbers(types);
            return types;
        }

        private static void validateFieldNumbers(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> types) {
            for (int i = 0; i < types.size(); ++i) {
                FieldValueTypeInformation type = types.get(i);
                Integer number = type.getNumber();
                if (number == null) {
                    throw new RuntimeException("Unexpected null number for " + type.getName());
                }
                Preconditions.checkState((number == i ? 1 : 0) != 0, (Object)("Expected field number " + i + " for field: " + type.getName() + " instead got " + number));
            }
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return System.identityHashCode(this);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }
    }
}

