/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.local;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public abstract class StructuralKey<@UnknownKeyFor K> {
    private StructuralKey() {
    }

    public abstract K getKey();

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> empty() {
        return new StructuralKey<Object>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object getKey() {
                return this;
            }
        };
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized StructuralKey<K> of(K key, @UnknownKeyFor @NonNull @Initialized Coder<K> coder) {
        try {
            return new CoderStructuralKey(coder, key);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not encode a key with its provided coder " + coder.getClass().getSimpleName(), e);
        }
    }

    private static class CoderStructuralKey<@UnknownKeyFor K>
    extends StructuralKey<K> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> coder;
        private final @UnknownKeyFor @NonNull @Initialized Object structuralValue;
        private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encoded;

        private CoderStructuralKey(@UnknownKeyFor @NonNull @Initialized Coder<K> coder, K key) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.coder = coder;
            this.structuralValue = coder.structuralValue(key);
            this.encoded = CoderUtils.encodeToByteArray(coder, key);
        }

        @Override
        public K getKey() {
            try {
                return CoderUtils.decodeFromByteArray(this.coder, this.encoded);
            }
            catch (CoderException e) {
                throw new IllegalArgumentException("Could not decode Key with coder of type " + this.coder.getClass().getSimpleName(), e);
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CoderStructuralKey) {
                CoderStructuralKey that = (CoderStructuralKey)other;
                return this.structuralValue.equals(that.structuralValue);
            }
            return false;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.structuralValue.hashCode();
        }
    }
}

