/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ComparisonChain;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

class WatermarkCallbackExecutor {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PriorityQueue<@UnknownKeyFor @NonNull @Initialized WatermarkCallback>> callbacks = new ConcurrentHashMap();
    private final @UnknownKeyFor @NonNull @Initialized Executor executor;

    public static @UnknownKeyFor @NonNull @Initialized WatermarkCallbackExecutor create(@UnknownKeyFor @NonNull @Initialized Executor executor) {
        return new WatermarkCallbackExecutor(executor);
    }

    private WatermarkCallbackExecutor(@UnknownKeyFor @NonNull @Initialized Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnGuaranteedFiring(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> step, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized Runnable runnable) {
        WatermarkCallback callback = WatermarkCallback.onGuaranteedFiring(window, windowingStrategy, runnable);
        PriorityQueue callbackQueue = (PriorityQueue)this.callbacks.get(step);
        if (callbackQueue == null && this.callbacks.putIfAbsent(step, callbackQueue = new PriorityQueue(11, new CallbackOrdering())) != null) {
            callbackQueue = (PriorityQueue)this.callbacks.get(step);
        }
        PriorityQueue priorityQueue = callbackQueue;
        synchronized (priorityQueue) {
            callbackQueue.offer(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnWindowExpiration(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> step, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized Runnable runnable) {
        WatermarkCallback callback = WatermarkCallback.afterWindowExpiration(window, windowingStrategy, runnable);
        PriorityQueue callbackQueue = (PriorityQueue)this.callbacks.get(step);
        if (callbackQueue == null && this.callbacks.putIfAbsent(step, callbackQueue = new PriorityQueue(11, new CallbackOrdering())) != null) {
            callbackQueue = (PriorityQueue)this.callbacks.get(step);
        }
        PriorityQueue priorityQueue = callbackQueue;
        synchronized (priorityQueue) {
            callbackQueue.offer(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireForWatermark(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> step, @UnknownKeyFor @NonNull @Initialized Instant watermark) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        PriorityQueue callbackQueue = (PriorityQueue)this.callbacks.get(step);
        if (callbackQueue == null) {
            return;
        }
        PriorityQueue priorityQueue = callbackQueue;
        synchronized (priorityQueue) {
            ArrayList<Runnable> toFire = new ArrayList<Runnable>();
            while (!callbackQueue.isEmpty() && ((WatermarkCallback)callbackQueue.peek()).shouldFire(watermark)) {
                toFire.add(((WatermarkCallback)callbackQueue.poll()).getCallback());
            }
            if (!toFire.isEmpty()) {
                CountDownLatch latch = new CountDownLatch(toFire.size());
                toFire.forEach(r -> this.executor.execute(() -> {
                    try {
                        r.run();
                    }
                    finally {
                        latch.countDown();
                    }
                }));
                latch.await();
            }
        }
    }

    private static class CallbackOrdering
    extends Ordering<WatermarkCallback>
    implements Serializable {
        private CallbackOrdering() {
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public @UnknownKeyFor @NonNull @Initialized int compare(@Nonnull @UnknownKeyFor @NonNull @Initialized WatermarkCallback left, @Nonnull @UnknownKeyFor @NonNull @Initialized WatermarkCallback right) {
            return ComparisonChain.start().compare((Comparable)left.fireAfter, (Comparable)right.fireAfter).compare((Object)left.callback, (Object)right.callback, (Comparator)Ordering.arbitrary()).result();
        }
    }

    private static class WatermarkCallback {
        private final @UnknownKeyFor @NonNull @Initialized Instant fireAfter;
        private final @UnknownKeyFor @NonNull @Initialized Runnable callback;

        public static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized WatermarkCallback onGuaranteedFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> strategy, @UnknownKeyFor @NonNull @Initialized Runnable callback) {
            Instant firingAfter = strategy.getTrigger().getWatermarkThatGuaranteesFiring(window);
            return new WatermarkCallback(firingAfter, callback);
        }

        public static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized WatermarkCallback afterWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> strategy, @UnknownKeyFor @NonNull @Initialized Runnable callback) {
            Instant firingAfter = window.maxTimestamp().plus((ReadableDuration)strategy.getAllowedLateness()).plus((ReadableDuration)Duration.millis((long)1L));
            return new WatermarkCallback(firingAfter, callback);
        }

        private WatermarkCallback(@UnknownKeyFor @NonNull @Initialized Instant fireAfter, @UnknownKeyFor @NonNull @Initialized Runnable callback) {
            this.fireAfter = fireAfter;
            this.callback = callback;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean shouldFire(@UnknownKeyFor @NonNull @Initialized Instant currentWatermark) {
            return currentWatermark.isAfter((ReadableInstant)this.fireAfter) || currentWatermark.equals((Object)BoundedWindow.TIMESTAMP_MAX_VALUE);
        }

        public @UnknownKeyFor @NonNull @Initialized Runnable getCallback() {
            return this.callback;
        }
    }
}

