/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.uniquerowsbyhashset;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.uniquerowsbyhashset.RowKey;
import org.apache.hop.pipeline.transforms.uniquerowsbyhashset.UniqueRowsByHashSetData;
import org.apache.hop.pipeline.transforms.uniquerowsbyhashset.UniqueRowsByHashSetMeta;

public class UniqueRowsByHashSet
extends BaseTransform<UniqueRowsByHashSetMeta, UniqueRowsByHashSetData> {
    private static final Class<?> PKG = UniqueRowsByHashSetMeta.class;

    public UniqueRowsByHashSet(TransformMeta transformMeta, UniqueRowsByHashSetMeta meta, UniqueRowsByHashSetData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private boolean isUniqueRow(Object[] row) {
        return ((UniqueRowsByHashSetData)this.data).seen.add(new RowKey(row, (UniqueRowsByHashSetData)this.data));
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            ((UniqueRowsByHashSetData)this.data).clearHashSet();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((UniqueRowsByHashSetData)this.data).inputRowMeta = this.getInputRowMeta().clone();
            ((UniqueRowsByHashSetData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((UniqueRowsByHashSetMeta)this.meta).getFields(((UniqueRowsByHashSetData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((UniqueRowsByHashSetData)this.data).storeValues = ((UniqueRowsByHashSetMeta)this.meta).getStoreValues();
            ((UniqueRowsByHashSetData)this.data).fieldnrs = new int[((UniqueRowsByHashSetMeta)this.meta).getCompareFields().length];
            for (int i = 0; i < ((UniqueRowsByHashSetMeta)this.meta).getCompareFields().length; ++i) {
                ((UniqueRowsByHashSetData)this.data).fieldnrs[i] = this.getInputRowMeta().indexOfValue(((UniqueRowsByHashSetMeta)this.meta).getCompareFields()[i]);
                if (((UniqueRowsByHashSetData)this.data).fieldnrs[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSet.Log.CouldNotFindFieldInRow", (String[])new String[]{((UniqueRowsByHashSetMeta)this.meta).getCompareFields()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (!((UniqueRowsByHashSetData)this.data).sendDuplicateRows) continue;
                ((UniqueRowsByHashSetData)this.data).compareFields = ((UniqueRowsByHashSetData)this.data).compareFields == null ? ((UniqueRowsByHashSetMeta)this.meta).getCompareFields()[i] : ((UniqueRowsByHashSetData)this.data).compareFields + "," + ((UniqueRowsByHashSetMeta)this.meta).getCompareFields()[i];
            }
            if (((UniqueRowsByHashSetData)this.data).sendDuplicateRows && !Utils.isEmpty((CharSequence)((UniqueRowsByHashSetMeta)this.meta).getErrorDescription())) {
                ((UniqueRowsByHashSetData)this.data).realErrorDescription = this.resolve(((UniqueRowsByHashSetMeta)this.meta).getErrorDescription());
            }
        }
        if (this.isUniqueRow(r)) {
            this.putRow(((UniqueRowsByHashSetData)this.data).outputRowMeta, r);
        } else {
            this.incrementLinesRejected();
            if (((UniqueRowsByHashSetData)this.data).sendDuplicateRows) {
                this.putError(this.getInputRowMeta(), r, 1L, ((UniqueRowsByHashSetData)this.data).realErrorDescription, Utils.isEmpty((CharSequence)((UniqueRowsByHashSetData)this.data).compareFields) ? null : ((UniqueRowsByHashSetData)this.data).compareFields, "UNRH001");
            }
        }
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSet.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((UniqueRowsByHashSetData)this.data).sendDuplicateRows = this.getTransformMeta().getTransformErrorMeta() != null && ((UniqueRowsByHashSetMeta)this.meta).supportsErrorHandling();
            return true;
        }
        return false;
    }
}

