/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.util.BitSet;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.netpreserve.jwarc.MessageParser;

public class MediaType
extends MessageParser {
    private static BitSet tokenChars = new BitSet();
    private static final byte[] _media_type_actions;
    private static final short[] _media_type_key_offsets;
    private static final char[] _media_type_trans_keys;
    private static final byte[] _media_type_single_lengths;
    private static final byte[] _media_type_range_lengths;
    private static final short[] _media_type_index_offsets;
    private static final byte[] _media_type_indicies;
    private static final byte[] _media_type_trans_targs;
    private static final byte[] _media_type_trans_actions;
    private static final byte[] _media_type_eof_actions;
    static final int media_type_start = 11;
    static final int media_type_en_strict = 1;
    static final int media_type_en_lenient = 11;
    public static final MediaType GEMINI;
    public static final MediaType GEMTEXT;
    public static final MediaType JSON;
    public static MediaType HTML;
    public static MediaType HTML_UTF8;
    public static MediaType HTTP;
    public static MediaType HTTP_REQUEST;
    public static MediaType HTTP_RESPONSE;
    public static MediaType OCTET_STREAM;
    public static MediaType PLAIN_TEXT;
    public static MediaType WARC_FIELDS;
    public static final MediaType WWW_FORM_URLENCODED;
    private final String raw;
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private int hashCode;
    private boolean valid;

    private static byte[] init__media_type_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 2, 0, 3, 2, 1, 3, 2, 4, 3, 2, 5, 4, 2, 6, 3, 2, 7, 5, 2, 8, 4, 2, 13, 3, 2, 14, 3, 3, 4, 1, 3, 3, 5, 4, 3, 3, 8, 5, 4, 3, 9, 5, 4, 3, 10, 5, 4, 3, 11, 13, 3, 3, 12, 14, 3, 4, 0, 5, 4, 3};
    }

    private static short[] init__media_type_key_offsets_0() {
        return new short[]{0, 0, 15, 29, 44, 47, 64, 80, 95, 102, 109, 114, 128, 129, 130, 148, 151, 169, 172, 191, 209, 227, 235, 243, 246, 268, 291, 313, 335, 341, 363, 371, 389, 403, 417, 435, 453};
    }

    private static char[] init__media_type_trans_keys_0() {
        return new char[]{'!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '/', '|', '~', '#', '\'', '*', '+', '-', '9', 'A', 'Z', '^', 'z', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ';', '\t', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '=', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\"', '|', '~', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\"', '\\', '\u007f', '\u0000', '\b', '\n', '\u001f', '\"', '\\', '\u007f', '\u0000', '\b', '\n', '\u001f', '\u007f', '\u0000', '\b', '\n', '\u001f', '!', '/', '|', '~', '#', '\'', '*', '+', '-', '9', 'A', 'Z', '^', 'z', '/', '/', '\t', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ';', '\t', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ';', '\t', ' ', '!', ';', '=', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '\"', ';', '|', '~', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '\"', ';', '\\', '\u007f', '\u0000', '\u001f', '\t', ' ', '\"', ';', '\\', '\u007f', '\u0000', '\u001f', '\t', ' ', ';', '\t', ' ', '\"', ';', '\\', '|', '~', '\u007f', '\u0000', '\u001f', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '\"', ';', '=', '\\', '|', '~', '\u007f', '\u0000', '\u001f', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '\"', ';', '\\', '|', '~', '\u007f', '\u0000', '\u001f', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '\"', ';', '\\', '|', '~', '\u007f', '\u0000', '\u001f', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ';', '\u007f', '\u0000', '\u001f', '\t', ' ', '\"', ';', '\\', '|', '~', '\u007f', '\u0000', '\u001f', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '\"', ';', '\\', '\u007f', '\u0000', '\u001f', '\t', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '/', '|', '~', '#', '\'', '*', '+', '-', '9', 'A', 'Z', '^', 'z', '!', '/', '|', '~', '#', '\'', '*', '+', '-', '9', 'A', 'Z', '^', 'z', '\t', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ';', '\u0000'};
    }

    private static byte[] init__media_type_single_lengths_0() {
        return new byte[]{0, 3, 4, 3, 3, 5, 4, 3, 3, 3, 1, 4, 1, 1, 6, 3, 6, 3, 7, 6, 6, 6, 6, 3, 8, 9, 8, 8, 4, 8, 6, 6, 4, 4, 6, 6, 3};
    }

    private static byte[] init__media_type_range_lengths_0() {
        return new byte[]{0, 6, 5, 6, 0, 6, 6, 6, 2, 2, 2, 5, 0, 0, 6, 0, 6, 0, 6, 6, 6, 1, 1, 0, 7, 7, 7, 7, 1, 7, 1, 6, 5, 5, 6, 6, 0};
    }

    private static short[] init__media_type_index_offsets_0() {
        return new short[]{0, 0, 10, 20, 30, 34, 46, 57, 67, 73, 79, 83, 93, 95, 97, 110, 114, 127, 131, 145, 158, 171, 179, 187, 191, 207, 224, 240, 256, 262, 278, 286, 299, 309, 319, 332, 345};
    }

    private static byte[] init__media_type_indicies_0() {
        return new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 2, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 4, 4, 5, 0, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 7, 8, 7, 7, 7, 7, 7, 7, 7, 7, 0, 10, 9, 9, 9, 9, 9, 9, 9, 9, 0, 12, 13, 0, 0, 0, 11, 15, 16, 0, 0, 0, 14, 0, 0, 0, 17, 19, 0, 19, 19, 19, 19, 19, 19, 19, 18, 21, 20, 0, 20, 23, 23, 24, 25, 24, 24, 24, 24, 24, 24, 24, 24, 22, 23, 23, 25, 22, 27, 27, 28, 27, 28, 28, 28, 28, 28, 28, 28, 28, 26, 29, 29, 27, 26, 29, 29, 30, 27, 31, 30, 30, 30, 30, 30, 30, 30, 30, 26, 29, 29, 33, 27, 32, 32, 32, 32, 32, 32, 32, 32, 26, 34, 34, 35, 36, 35, 35, 35, 35, 35, 35, 35, 35, 26, 37, 37, 39, 40, 41, 26, 26, 38, 42, 42, 44, 45, 46, 26, 26, 43, 47, 47, 48, 26, 45, 45, 44, 45, 46, 49, 49, 26, 26, 49, 49, 49, 49, 49, 49, 43, 42, 42, 44, 45, 51, 46, 50, 50, 26, 26, 50, 50, 50, 50, 50, 50, 43, 42, 42, 53, 45, 46, 52, 52, 26, 26, 52, 52, 52, 52, 52, 52, 43, 54, 54, 44, 56, 46, 55, 55, 26, 26, 55, 55, 55, 55, 55, 55, 43, 57, 57, 59, 26, 26, 58, 40, 40, 39, 40, 41, 60, 60, 26, 26, 60, 60, 60, 60, 60, 60, 38, 61, 61, 39, 62, 41, 26, 26, 38, 63, 63, 24, 64, 24, 24, 24, 24, 24, 24, 24, 24, 22, 65, 66, 65, 65, 65, 65, 65, 65, 65, 20, 65, 67, 65, 65, 65, 65, 65, 65, 65, 20, 68, 68, 3, 69, 3, 3, 3, 3, 3, 3, 3, 3, 0, 70, 70, 71, 72, 71, 71, 71, 71, 71, 71, 71, 71, 0, 73, 73, 74, 0, 0};
    }

    private static byte[] init__media_type_trans_targs_0() {
        return new byte[]{0, 2, 3, 34, 4, 5, 6, 6, 7, 35, 8, 9, 36, 10, 9, 36, 10, 8, 12, 32, 13, 14, 15, 15, 31, 16, 17, 16, 18, 17, 18, 19, 20, 21, 17, 20, 16, 22, 22, 23, 24, 28, 22, 22, 23, 24, 28, 17, 16, 25, 25, 26, 27, 30, 22, 27, 24, 21, 21, 29, 25, 22, 24, 15, 16, 33, 14, 14, 4, 5, 4, 35, 5, 4, 5};
    }

    private static byte[] init__media_type_trans_actions_0() {
        return new byte[]{5, 0, 23, 0, 0, 0, 17, 0, 19, 21, 15, 9, 0, 0, 36, 11, 11, 13, 0, 0, 0, 48, 0, 51, 0, 51, 0, 7, 17, 7, 0, 19, 21, 15, 27, 0, 27, 33, 9, 0, 33, 0, 58, 36, 11, 58, 11, 30, 30, 62, 36, 66, 70, 42, 82, 36, 82, 39, 13, 39, 45, 54, 54, 78, 78, 0, 74, 23, 25, 25, 1, 0, 1, 3, 3};
    }

    private static byte[] init__media_type_eof_actions_0() {
        return new byte[]{0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 7, 7, 51, 51, 7, 7, 7, 7, 27, 7, 7, 30, 7, 7, 7, 27, 7, 7, 30, 78, 7, 7, 25, 1, 3};
    }

    public static MediaType parse(String string) throws IllegalArgumentException {
        return MediaType.parse(string, false);
    }

    public static MediaType parseLeniently(String string) {
        return MediaType.parse(string, true);
    }

    /*
     * Unable to fully structure code
     */
    private static MediaType parse(String string, boolean lenient) {
        map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        p = 0;
        eof = pe = string.length();
        typeEnd = string.length();
        subtypeEnd = string.length();
        nameStart = 0;
        nameEnd = 0;
        valueStart = 0;
        buf = new StringBuilder();
        valid = true;
        cs = 11;
        cs = lenient != false ? 11 : 1;
        _trans = 0;
        _goto_targ = 0;
        block31: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block31;
                    }
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block31;
                    }
                }
                case 1: {
                    _keys = MediaType._media_type_key_offsets[cs];
                    _trans = MediaType._media_type_index_offsets[cs];
                    _klen = MediaType._media_type_single_lengths[cs];
                    if (_klen <= 0) ** GOTO lbl43
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (string.charAt(p) < MediaType._media_type_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (string.charAt(p) > MediaType._media_type_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl57
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl43:
                    // 2 sources

                    if ((_klen = MediaType._media_type_range_lengths[cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (string.charAt(p) < MediaType._media_type_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (string.charAt(p) > MediaType._media_type_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl57
                        }
                        _trans += _klen;
                    }
lbl57:
                    // 5 sources

                    _trans = MediaType._media_type_indicies[_trans];
                    cs = MediaType._media_type_trans_targs[_trans];
                    if (MediaType._media_type_trans_actions[_trans] != 0) {
                        _acts = MediaType._media_type_trans_actions[_trans];
                        _nacts = MediaType._media_type_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (MediaType._media_type_actions[_acts++]) {
                                case 0: {
                                    name = string.substring(nameStart, nameEnd);
                                    value = string.substring(valueStart, p);
                                    map.putIfAbsent(name, value);
                                    break;
                                }
                                case 1: {
                                    name = string.substring(nameStart, nameEnd);
                                    value = buf.toString();
                                    map.putIfAbsent(name, value);
                                    break;
                                }
                                case 2: {
                                    if (p < 0) break;
                                    throw new IllegalArgumentException("parse error at position " + p + ": " + MediaType.getErrorContext(string, p, 40));
                                }
                                case 3: {
                                    valid = false;
                                    break;
                                }
                                case 4: {
                                    valueStart = p;
                                    break;
                                }
                                case 5: {
                                    buf.append(string, valueStart, p);
                                    break;
                                }
                                case 6: {
                                    buf.append(string.charAt(p));
                                    break;
                                }
                                case 7: {
                                    buf.setLength(0);
                                    break;
                                }
                                case 8: {
                                    nameStart = p;
                                    break;
                                }
                                case 9: {
                                    nameEnd = p;
                                    break;
                                }
                                case 10: {
                                    valueStart = p;
                                    break;
                                }
                                case 11: {
                                    typeEnd = p;
                                    break;
                                }
                                case 12: {
                                    subtypeEnd = p;
                                    break;
                                }
                                case 13: {
                                    typeEnd = p;
                                    break;
                                }
                                case 14: {
                                    subtypeEnd = p;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block31;
                    }
                    if (++p != pe) {
                        _goto_targ = 1;
                        continue block31;
                    }
                }
                case 4: {
                    if (p != eof) break block31;
                    __acts = MediaType._media_type_eof_actions[cs];
                    __nacts = MediaType._media_type_actions[__acts++];
                    while (__nacts-- > 0) {
                        switch (MediaType._media_type_actions[__acts++]) {
                            case 0: {
                                name = string.substring(nameStart, nameEnd);
                                value = string.substring(valueStart, p);
                                map.putIfAbsent(name, value);
                                break;
                            }
                            case 1: {
                                name = string.substring(nameStart, nameEnd);
                                value = buf.toString();
                                map.putIfAbsent(name, value);
                                break;
                            }
                            case 2: {
                                if (p < 0) break;
                                throw new IllegalArgumentException("parse error at position " + p + ": " + MediaType.getErrorContext(string, p, 40));
                            }
                            case 3: {
                                valid = false;
                                break;
                            }
                            case 12: {
                                subtypeEnd = p;
                                break;
                            }
                            case 14: {
                                subtypeEnd = p;
                            }
                        }
                    }
                    break block31;
                }
            }
            break;
        }
        if (valid) {
            type = string.substring(0, typeEnd);
            subtype = string.substring(typeEnd + 1, subtypeEnd);
        } else {
            type = string.substring(0, typeEnd);
            subtype = typeEnd + 1 >= string.length() ? "" : string.substring(typeEnd + 1, subtypeEnd);
        }
        parameters = Collections.unmodifiableMap(map);
        return new MediaType(string, type, subtype, parameters, valid);
    }

    private MediaType(String raw, String type, String subtype, Map<String, String> parameters, boolean valid) {
        this.raw = raw;
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
        this.valid = valid;
    }

    public String raw() {
        return this.raw;
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType that = (MediaType)o;
        if (this.hashCode != 0 && this.hashCode != that.hashCode && that.hashCode != 0) {
            return false;
        }
        return this.subtype.equalsIgnoreCase(that.subtype) && this.type.equalsIgnoreCase(that.type) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.type.toLowerCase(Locale.ROOT).hashCode();
            result = 31 * result + this.subtype.toLowerCase(Locale.ROOT).hashCode();
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                result = 31 * result + entry.getKey().toLowerCase(Locale.ROOT).hashCode();
                result = 31 * result + entry.getValue().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        if (!this.subtype.isEmpty()) {
            sb.append('/').append(this.subtype);
        }
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            sb.append(';');
            sb.append(parameter.getKey());
            sb.append('=');
            String value = parameter.getValue();
            if (!MediaType.validToken(value)) {
                sb.append('\"');
                sb.append(value.replace("\\", "\\\\").replace("\"", "\\\""));
                sb.append('\"');
                continue;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public MediaType base() {
        return new MediaType(null, this.type, this.subtype, Collections.emptyMap(), this.valid);
    }

    private static boolean validToken(String s) {
        return s.chars().allMatch(tokenChars::get);
    }

    static {
        "!#$%&'*+-.^_`|~ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890".chars().forEach(tokenChars::set);
        _media_type_actions = MediaType.init__media_type_actions_0();
        _media_type_key_offsets = MediaType.init__media_type_key_offsets_0();
        _media_type_trans_keys = MediaType.init__media_type_trans_keys_0();
        _media_type_single_lengths = MediaType.init__media_type_single_lengths_0();
        _media_type_range_lengths = MediaType.init__media_type_range_lengths_0();
        _media_type_index_offsets = MediaType.init__media_type_index_offsets_0();
        _media_type_indicies = MediaType.init__media_type_indicies_0();
        _media_type_trans_targs = MediaType.init__media_type_trans_targs_0();
        _media_type_trans_actions = MediaType.init__media_type_trans_actions_0();
        _media_type_eof_actions = MediaType.init__media_type_eof_actions_0();
        GEMINI = MediaType.parse("application/gemini");
        GEMTEXT = MediaType.parse("text/gemini");
        JSON = MediaType.parse("application/json");
        HTML = MediaType.parse("text/html");
        HTML_UTF8 = MediaType.parse("text/html;charset=utf-8");
        HTTP = MediaType.parse("application/http");
        HTTP_REQUEST = MediaType.parse("application/http;msgtype=request");
        HTTP_RESPONSE = MediaType.parse("application/http;msgtype=response");
        OCTET_STREAM = MediaType.parse("application/octet-stream");
        PLAIN_TEXT = MediaType.parse("text/plain");
        WARC_FIELDS = MediaType.parse("application/warc-fields");
        WWW_FORM_URLENCODED = MediaType.parse("application/x-www-form-urlencoded");
    }
}

