/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.Constants;
import com.sforce.ws.wsdl.Restriction;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;

public class SimpleType
implements Constants {
    private String name;
    private Restriction restriction;
    private Schema schema;

    public SimpleType(Schema schema) {
        this.schema = schema;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String toString() {
        return "SimpleType{name='" + this.name + '\'' + ", restriction=" + this.restriction + '}';
    }

    public void read(WsdlParser parser, String elementName) throws WsdlParseException {
        this.name = parser.getAttributeValue(null, "name");
        if (this.name == null) {
            this.name = elementName;
        }
        if (this.name == null) {
            throw new WsdlParseException("simpleType->element Name can not be null. " + parser.getPositionDescription());
        }
        int eventType = parser.getEventType();
        while (true) {
            String namespace;
            String name;
            if (eventType == 2) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("restriction".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    this.restriction = new Restriction(this.schema);
                    this.restriction.read(parser);
                }
            } else if (eventType == 3) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("simpleType".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    return;
                }
            } else if (eventType == 1) {
                throw new WsdlParseException("Failed to find end tag for 'simpleType'");
            }
            eventType = parser.next();
        }
    }

    public String getName() {
        return this.name;
    }
}

