/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.internal;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.internal.AeadCrypter;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.internal.ConscryptLoader;

final class AesGcmAeadCrypter
implements AeadCrypter {
    private static final Logger logger = Logger.getLogger(AesGcmAeadCrypter.class.getName());
    private static final int KEY_LENGTH = 16;
    private static final int TAG_LENGTH = 16;
    static final int NONCE_LENGTH = 12;
    private static final String AES = "AES";
    private static final String AES_GCM = "AES/GCM/NoPadding";
    private static final Provider CONSCRYPT = AesGcmAeadCrypter.getConscrypt();
    private final byte[] key;
    private final Cipher cipher;

    AesGcmAeadCrypter(byte[] key) throws GeneralSecurityException {
        Preconditions.checkArgument(key.length == 16);
        this.key = key;
        this.cipher = CONSCRYPT != null ? Cipher.getInstance(AES_GCM, CONSCRYPT) : Cipher.getInstance(AES_GCM);
    }

    private int encryptAad(ByteBuffer ciphertext, ByteBuffer plaintext, @Nullable ByteBuffer aad, byte[] nonce) throws GeneralSecurityException {
        Preconditions.checkArgument(nonce.length == 12);
        this.cipher.init(1, (Key)new SecretKeySpec(this.key, AES), new GCMParameterSpec(128, nonce));
        if (aad != null) {
            this.cipher.updateAAD(aad);
        }
        return this.cipher.doFinal(plaintext, ciphertext);
    }

    private void decryptAad(ByteBuffer plaintext, ByteBuffer ciphertext, @Nullable ByteBuffer aad, byte[] nonce) throws GeneralSecurityException {
        Preconditions.checkArgument(nonce.length == 12);
        this.cipher.init(2, (Key)new SecretKeySpec(this.key, AES), new GCMParameterSpec(128, nonce));
        if (aad != null) {
            this.cipher.updateAAD(aad);
        }
        this.cipher.doFinal(ciphertext, plaintext);
    }

    @Override
    public void encrypt(ByteBuffer ciphertext, ByteBuffer plaintext, byte[] nonce) throws GeneralSecurityException {
        this.encryptAad(ciphertext, plaintext, null, nonce);
    }

    @Override
    public void encrypt(ByteBuffer ciphertext, ByteBuffer plaintext, ByteBuffer aad, byte[] nonce) throws GeneralSecurityException {
        this.encryptAad(ciphertext, plaintext, aad, nonce);
    }

    @Override
    public void decrypt(ByteBuffer plaintext, ByteBuffer ciphertext, byte[] nonce) throws GeneralSecurityException {
        this.decryptAad(plaintext, ciphertext, null, nonce);
    }

    @Override
    public void decrypt(ByteBuffer plaintext, ByteBuffer ciphertext, ByteBuffer aad, byte[] nonce) throws GeneralSecurityException {
        this.decryptAad(plaintext, ciphertext, aad, nonce);
    }

    static int getKeyLength() {
        return 16;
    }

    @VisibleForTesting
    static Provider getConscrypt() {
        Provider provider;
        if (!ConscryptLoader.isPresent()) {
            return null;
        }
        try {
            provider = ConscryptLoader.newProvider();
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "Could not load Conscrypt. Will use slower JDK implementation", t);
            return null;
        }
        try {
            Cipher.getInstance(AES_GCM, provider);
        }
        catch (SecurityException t) {
            logger.log(Level.WARNING, "Could not load Conscrypt. Will try slower JDK implementation. This may be because the JDK is older than Java 7 update 121 or Java 8 update 111. If so, please update", t);
            return null;
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "Could not load Conscrypt. Will use slower JDK implementation", t);
            return null;
        }
        return provider;
    }
}

