/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kie.api.definition.KieDefinition;
import org.kie.api.definition.rule.Rule;

public class SerializedRule
implements Rule,
Externalizable {
    private String name;
    private String packageName;
    private Map<String, Object> metaAttributes;

    public SerializedRule() {
    }

    public SerializedRule(Rule rule) {
        this.name = rule.getName();
        this.packageName = rule.getPackageName();
        this.metaAttributes = new HashMap<String, Object>(rule.getMetaData());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.packageName);
        out.writeObject(this.metaAttributes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.packageName = in.readUTF();
        this.metaAttributes = (Map)in.readObject();
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Deprecated
    public String getMetaAttribute(String identifier) {
        return this.metaAttributes.get(identifier).toString();
    }

    @Deprecated
    public Collection<String> listMetaAttributes() {
        return this.metaAttributes.keySet();
    }

    @Deprecated
    public Map<String, Object> getMetaAttributes() {
        return Collections.unmodifiableMap(this.metaAttributes);
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaAttributes);
    }

    public KieDefinition.KnowledgeType getKnowledgeType() {
        return KieDefinition.KnowledgeType.RULE;
    }

    public String getNamespace() {
        return this.getPackageName();
    }

    public String getId() {
        return this.getName();
    }
}

