/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class CollectSetAccumulateFunction
extends AbstractAccumulateFunction<CollectListData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public CollectListData createContext() {
        return new CollectListData();
    }

    public void init(CollectListData data) {
        data.map.clear();
    }

    public void accumulate(CollectListData data, Object value) {
        CollectListData.MutableInt counter = data.map.get(value);
        if (counter == null) {
            counter = new CollectListData.MutableInt();
            data.map.put(value, counter);
        }
        ++counter.value;
    }

    public void reverse(CollectListData data, Object value) {
        CollectListData.MutableInt counter = data.map.get(value);
        if (--counter.value == 0) {
            data.map.remove(value);
        }
    }

    public Object getResult(CollectListData data) {
        return Collections.unmodifiableSet(data.map.keySet());
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return Set.class;
    }

    public static class CollectListData
    implements Externalizable {
        public Map<Object, MutableInt> map = new HashMap<Object, MutableInt>();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.map = (Map)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.map);
        }

        public static class MutableInt
        implements Serializable {
            private static final long serialVersionUID = 510L;
            public int value = 0;
        }
    }
}

