/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramMapEntry;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ProgramMap
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private Hashtable table_ = new Hashtable();
    private Object[] ids_ = null;
    private Vector idsV_ = new Vector();

    public void add(Object id, String programName, String dataName) {
        if (dataName == null) {
            throw new NullPointerException("dataName");
        }
        this.add(id, new ProgramMapEntry(programName, dataName, (int[])null, null, null));
    }

    public void add(Object id, String programName, String dataName, ValueMap valueMap) {
        if (dataName == null) {
            throw new NullPointerException("dataName");
        }
        this.add(id, new ProgramMapEntry(programName, dataName, (int[])null, valueMap, null));
    }

    public void add(Object id, String programName, String dataName, ValueMap valueMap, ResourceLevel level) {
        if (dataName == null) {
            throw new NullPointerException("dataName");
        }
        this.add(id, new ProgramMapEntry(programName, dataName, (int[])null, valueMap, level));
    }

    public void add(Object id, String programName, String dataName, int[] indices) {
        if (dataName == null) {
            throw new NullPointerException("dataName");
        }
        this.add(id, new ProgramMapEntry(programName, dataName, indices, null, null));
    }

    public void add(Object id, String programName, String dataName, String countName, ValueMap map) {
        if (dataName == null) {
            throw new NullPointerException("dataName");
        }
        this.add(id, new ProgramMapEntry(programName, dataName, countName, map, null));
    }

    public void add(Object id, String programName, String dataName, String countName) {
        if (dataName == null) {
            throw new NullPointerException("dataName");
        }
        this.add(id, new ProgramMapEntry(programName, dataName, countName, null, null));
    }

    public void add(Object id, String programName, String dataName, int[] indices, ValueMap valueMap) {
        if (dataName == null) {
            throw new NullPointerException("dataName");
        }
        this.add(id, new ProgramMapEntry(programName, dataName, indices, valueMap, null));
    }

    private synchronized void add(Object id, ProgramMapEntry entry) {
        Vector entriesV;
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (entry == null) {
            throw new NullPointerException("entry");
        }
        if (this.table_.containsKey(id)) {
            entriesV = (Vector)this.table_.get(id);
        } else {
            entriesV = new Vector();
            this.table_.put(id, entriesV);
        }
        entriesV.addElement(entry);
        this.idsV_.addElement(id);
        this.ids_ = null;
    }

    ProgramMapEntry[] getEntries(Object id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (!this.table_.containsKey(id)) {
            throw new ExtendedIllegalArgumentException("id", 2);
        }
        Vector entriesV = (Vector)this.table_.get(id);
        Object[] entries = new ProgramMapEntry[entriesV.size()];
        entriesV.copyInto(entries);
        return entries;
    }

    public synchronized Object[] getIDs() {
        if (this.ids_ == null) {
            this.ids_ = new Object[this.idsV_.size()];
            this.idsV_.copyInto(this.ids_);
        }
        return this.ids_;
    }

    synchronized Object[] getIDs(String level) {
        Vector subset = new Vector(this.idsV_.size());
        Enumeration enum1 = this.idsV_.elements();
        while (enum1.hasMoreElements()) {
            Object id = enum1.nextElement();
            Vector entries = (Vector)this.table_.get(id);
            Enumeration enum2 = entries.elements();
            while (enum2.hasMoreElements()) {
                ProgramMapEntry entry = (ProgramMapEntry)enum2.nextElement();
                if (!entry.getLevel().checkLevel(level) || subset.contains(id)) continue;
                subset.addElement(id);
            }
        }
        Object[] ids = new Object[subset.size()];
        subset.copyInto(ids);
        return ids;
    }

    public Object[] getValues(Object[] ids, AS400 system, ProgramCallDocument document, String programName, int[] indices) throws PcmlException {
        if (ids == null) {
            throw new NullPointerException("ids");
        }
        if (document == null) {
            throw new NullPointerException("document");
        }
        int bidiStringType = AS400BidiTransform.getStringType((char)system.getCcsid());
        Object[] values = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            if (!this.table_.containsKey(ids[i])) {
                throw new ExtendedIllegalArgumentException("ids[" + i + "]", 2);
            }
            Vector entriesV = (Vector)this.table_.get(ids[i]);
            Enumeration entries = entriesV.elements();
            while (entries.hasMoreElements()) {
                ProgramMapEntry entry = (ProgramMapEntry)entries.nextElement();
                String entryProgramName = entry.getProgramName();
                if (programName == null || entryProgramName == null) {
                    values[i] = entry.getValue(system, document, programName, indices, bidiStringType);
                    break;
                }
                if (!programName.equals(entry.getProgramName())) continue;
                values[i] = entry.getValue(system, document, programName, indices, bidiStringType);
                break;
            }
            if (values[i] != null) continue;
            throw new ExtendedIllegalArgumentException("values[" + i + "]", 2);
        }
        return values;
    }

    void setValues(Object[] ids, Object[] values, AS400 system, ProgramCallDocument document, String programName, int[] indices, int[] bidiStringTypes) throws PcmlException {
        if (ids == null) {
            throw new NullPointerException("ids");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (ids.length != values.length) {
            throw new ExtendedIllegalArgumentException("values", 2);
        }
        if (ids.length != bidiStringTypes.length) {
            throw new ExtendedIllegalArgumentException("bidiStringTypes", 2);
        }
        if (document == null) {
            throw new NullPointerException("document");
        }
        block0: for (int i = 0; i < ids.length; ++i) {
            if (!this.table_.containsKey(ids[i])) continue;
            Vector entriesV = (Vector)this.table_.get(ids[i]);
            Enumeration entries = entriesV.elements();
            while (entries.hasMoreElements()) {
                ProgramMapEntry entry = (ProgramMapEntry)entries.nextElement();
                String entryProgramName = entry.getProgramName();
                if (programName == null) {
                    entry.setValue(system, document, entryProgramName, indices, values[i], bidiStringTypes[i]);
                    continue block0;
                }
                if (entryProgramName == null) {
                    entry.setValue(system, document, programName, indices, values[i], bidiStringTypes[i]);
                    continue block0;
                }
                if (!programName.equals(entry.getProgramName())) continue;
                entry.setValue(system, document, programName, indices, values[i], bidiStringTypes[i]);
                continue block0;
            }
        }
    }
}

