/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Array;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ArrayFieldDescription;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.DBCSGraphicFieldDescription;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.RecordDescriptionEvent;
import com.ibm.as400.access.RecordDescriptionListener;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Record
implements Serializable {
    static final long serialVersionUID = 4L;
    private byte[] as400Data_;
    private FieldDescription[] fieldDescriptions_;
    private Object[] fields_;
    private int[] fieldOffsets_;
    private boolean hasDependentFields_;
    private boolean[] isConvertedToJava_;
    private boolean[] isConvertedToAS400_;
    private String name_ = "";
    private boolean[] nullFieldMap_;
    private transient PropertyChangeSupport changes_;
    private RecordFormat recordFormat_ = null;
    int recordLength_;
    int recordNumber_;
    long recordNumberLong_;
    Object[] returnFields_;
    private transient VetoableChangeSupport vetos_;
    private transient Vector recordDescriptionListeners_;

    public Record() {
        this.initializeTransient();
    }

    public Record(RecordFormat recordFormat) {
        this.initializeTransient();
        this.initializeRecord(recordFormat);
    }

    public Record(RecordFormat recordFormat, String recordName) {
        this(recordFormat);
        if (recordName == null) {
            throw new NullPointerException("recordName");
        }
        this.name_ = recordName;
    }

    public Record(RecordFormat recordFormat, byte[] contents) throws UnsupportedEncodingException {
        this(recordFormat, contents, 0);
    }

    public Record(RecordFormat recordFormat, byte[] contents, String recordName) throws UnsupportedEncodingException {
        this(recordFormat, contents, 0, recordName);
    }

    public Record(RecordFormat recordFormat, byte[] contents, int offset) throws UnsupportedEncodingException {
        this.initializeTransient();
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        if (recordFormat.getNumberOfFields() == 0) {
            throw new ExtendedIllegalArgumentException("recordFormat", 2);
        }
        if (contents == null) {
            throw new NullPointerException("contents");
        }
        if (contents.length == 0) {
            throw new ExtendedIllegalArgumentException("contents", 1);
        }
        if (offset < 0) {
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        this.recordFormat_ = recordFormat;
        this.fieldDescriptions_ = recordFormat.getFieldDescriptions();
        this.hasDependentFields_ = this.recordFormat_.getHasDependentFields();
        this.fields_ = new Object[this.fieldDescriptions_.length];
        this.returnFields_ = new Object[this.fieldDescriptions_.length];
        this.fieldOffsets_ = new int[this.fieldDescriptions_.length];
        this.isConvertedToJava_ = new boolean[this.fieldDescriptions_.length];
        this.isConvertedToAS400_ = new boolean[this.fieldDescriptions_.length];
        this.nullFieldMap_ = new boolean[this.fields_.length];
        FieldDescription fd = null;
        int fieldOffset = 0;
        int length = 0;
        this.recordLength_ = 0;
        for (int i = 0; i < this.fields_.length; ++i) {
            fd = this.fieldDescriptions_[i];
            this.fieldOffsets_[i] = fieldOffset;
            if (fd instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fd)).isVariableLength()) {
                fieldOffset += 2;
                this.recordLength_ += 2;
            }
            length = fd.getDataType().getByteLength();
            fieldOffset += length;
            this.recordLength_ += length;
            if (!this.hasDependentFields_) {
                this.isConvertedToAS400_[i] = true;
            }
            this.isConvertedToJava_[i] = false;
        }
        this.as400Data_ = new byte[this.recordLength_];
        if (!this.hasDependentFields_) {
            try {
                System.arraycopy(contents, offset, this.as400Data_, 0, this.as400Data_.length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                for (int i = 0; i < this.isConvertedToAS400_.length; ++i) {
                    this.isConvertedToAS400_[i] = false;
                }
                throw e;
            }
        } else {
            this.setContents(contents, offset);
        }
    }

    public Record(RecordFormat recordFormat, byte[] contents, int offset, String recordName) throws UnsupportedEncodingException {
        this(recordFormat, contents, offset);
        if (recordName == null) {
            throw new NullPointerException("recordName");
        }
        this.name_ = recordName;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addRecordDescriptionListener(RecordDescriptionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.recordDescriptionListeners_ == null) {
            this.recordDescriptionListeners_ = new Vector();
        }
        this.recordDescriptionListeners_.addElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public boolean equals(Object obj) {
        block9: {
            if (obj == null) {
                return false;
            }
            try {
                Record cmp = (Record)obj;
                if (cmp.recordLength_ == this.recordLength_ && cmp.recordNumber_ == this.recordNumber_ && cmp.recordNumberLong_ == this.recordNumberLong_ && cmp.hasDependentFields_ == this.hasDependentFields_ && (cmp.name_ == null ? this.name_ == null : cmp.name_.equals(this.name_))) {
                    int cn;
                    int n = this.getNumberOfFields();
                    if (n == (cn = cmp.getNumberOfFields())) {
                        int cnk;
                        int nk = this.getNumberOfKeyFields();
                        if (nk == (cnk = this.getNumberOfKeyFields())) {
                            for (int i = 0; i < n; ++i) {
                                Object obj1 = this.getField(i);
                                Object obj2 = cmp.getField(i);
                                if (obj1 == null) {
                                    if (obj2 == null) continue;
                                    return false;
                                }
                                if (obj2 == null) {
                                    return false;
                                }
                                if (obj1.equals(obj2)) continue;
                                return false;
                            }
                            break block9;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return true;
    }

    private void fireFieldModifiedEvent() {
        if (this.recordDescriptionListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.recordDescriptionListeners_.clone();
        RecordDescriptionEvent event = new RecordDescriptionEvent(this, 3);
        for (int i = 0; i < targets.size(); ++i) {
            RecordDescriptionListener target = (RecordDescriptionListener)targets.elementAt(i);
            target.fieldModified(event);
        }
    }

    public byte[] getContents() throws CharConversionException, UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (this.hasDependentFields_) {
            int offset = 0;
            if (Trace.traceOn_) {
                Trace.log(3, "recordLength_: " + String.valueOf(this.recordLength_));
            }
            byte[] toBytes = new byte[this.recordLength_];
            for (int i = 0; i < this.fields_.length; ++i) {
                FieldDescription f = this.fieldDescriptions_[i];
                if (f instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)f)).isVariableLength()) {
                    int variableFieldLength = this.fields_[i] == null ? 0 : (f instanceof HexFieldDescription ? ((byte[])this.fields_[i]).length : ((String)this.fields_[i]).length());
                    BinaryConverter.unsignedShortToByteArray(variableFieldLength, toBytes, offset);
                    offset += 2;
                }
                AS400DataType dType = f.getDataType();
                if (this.fields_[i] != null) {
                    offset += dType.toBytes(this.fields_[i], toBytes, offset);
                    continue;
                }
                offset += dType.toBytes(dType.getDefaultValue(), toBytes, offset);
            }
            return toBytes;
        }
        return this.as400Data_;
    }

    public void getContents(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("out");
        }
        out.write(this.getContents());
    }

    public Object getField(int index) throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (index < 0 || index > this.fields_.length - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        if (this.isConvertedToJava_[index]) {
            return this.fields_[index];
        }
        FieldDescription f = this.fieldDescriptions_[index];
        AS400DataType dType = f.getDataType();
        int offset = this.fieldOffsets_[index];
        if (f instanceof VariableLengthFieldDescription) {
            if (((VariableLengthFieldDescription)((Object)f)).isVariableLength()) {
                int variableFieldLength = BinaryConverter.byteArrayToUnsignedShort(this.as400Data_, offset);
                if (f instanceof DBCSGraphicFieldDescription) {
                    variableFieldLength *= 2;
                }
                offset += 2;
                if (f instanceof HexFieldDescription) {
                    byte[] b = new byte[variableFieldLength];
                    System.arraycopy(this.as400Data_, offset, b, 0, variableFieldLength);
                    this.fields_[index] = b;
                } else {
                    ConverterImpl c = ((AS400Text)dType).getConverter();
                    this.fields_[index] = c.byteArrayToString(this.as400Data_, offset, variableFieldLength);
                }
            } else {
                this.fields_[index] = dType.toObject(this.as400Data_, offset);
            }
        } else {
            this.fields_[index] = dType.toObject(this.as400Data_, offset);
        }
        if (this.recordDescriptionListeners_ != null) {
            this.fireFieldModifiedEvent();
        }
        this.isConvertedToJava_[index] = true;
        return this.fields_[index];
    }

    public Object getField(String name) throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        return this.getField(this.recordFormat_.getIndexOfFieldName(name));
    }

    public byte[] getFieldAsBytes(int index) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (index < 0 || index > this.fields_.length - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        byte[] fieldAsBytes = null;
        int fieldOffset = 0;
        int fieldByteLength = 0;
        if (this.hasDependentFields_) {
            int offsetToNextField = 0;
            for (int i = 0; i <= index; ++i) {
                fieldOffset = offsetToNextField;
                FieldDescription f = this.fieldDescriptions_[i];
                AS400DataType dType = f.getDataType();
                fieldByteLength = dType.getByteLength();
                int lengthDependField = this.recordFormat_.getLengthDependency(i);
                int offsetDependField = this.recordFormat_.getOffsetDependency(i);
                if (offsetDependField != -1) {
                    fieldOffset = ((Number)this.fields_[offsetDependField]).intValue();
                }
                if (lengthDependField != -1) {
                    fieldByteLength = ((Number)this.fields_[lengthDependField]).intValue();
                }
                if (f instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)f)).isVariableLength()) {
                    fieldByteLength += 2;
                }
                offsetToNextField = fieldOffset + fieldByteLength;
            }
        } else {
            fieldOffset = this.fieldOffsets_[index];
            FieldDescription f = this.fieldDescriptions_[index];
            AS400DataType dType = f.getDataType();
            fieldByteLength = dType.getByteLength();
            if (f instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)f)).isVariableLength()) {
                fieldByteLength += 2;
            }
        }
        fieldAsBytes = new byte[fieldByteLength];
        System.arraycopy(this.as400Data_, fieldOffset, fieldAsBytes, 0, fieldAsBytes.length);
        return fieldAsBytes;
    }

    public byte[] getFieldAsBytes(String name) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        return this.getFieldAsBytes(this.recordFormat_.getIndexOfFieldName(name));
    }

    public Object[] getFields() throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            return new Object[0];
        }
        for (int i = 0; i < this.fields_.length; ++i) {
            this.returnFields_[i] = this.getField(i);
        }
        return this.returnFields_;
    }

    public Object[] getKeyFields() throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            return new Object[0];
        }
        Object[] keyFields = new Object[this.recordFormat_.getNumberOfKeyFields()];
        String[] keyFieldNames = this.recordFormat_.getKeyFieldNames();
        for (int i = 0; i < keyFields.length; ++i) {
            keyFields[i] = this.getField(keyFieldNames[i]);
        }
        return keyFields;
    }

    public byte[] getKeyFieldsAsBytes() {
        if (this.recordFormat_ == null) {
            return new byte[0];
        }
        ByteArrayOutputStream keyAsBytes = new ByteArrayOutputStream();
        String[] keyFieldNames = this.recordFormat_.getKeyFieldNames();
        AS400DataType dt = null;
        FieldDescription fd = null;
        for (int i = 0; i < keyFieldNames.length; ++i) {
            int index = this.recordFormat_.getIndexOfFieldName(keyFieldNames[i]);
            fd = this.fieldDescriptions_[index];
            dt = fd.getDataType();
            int length = dt.getByteLength();
            if (fd instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fd)).isVariableLength()) {
                length += 2;
            }
            keyAsBytes.write(this.as400Data_, this.fieldOffsets_[index], length);
        }
        return keyAsBytes.toByteArray();
    }

    public int getNumberOfFields() {
        return this.recordFormat_ == null ? 0 : this.fields_.length;
    }

    public int getNumberOfKeyFields() {
        return this.recordFormat_ == null ? 0 : this.recordFormat_.getNumberOfKeyFields();
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat_;
    }

    public int getRecordLength() {
        return this.recordLength_;
    }

    public String getRecordName() {
        return this.name_;
    }

    public int getRecordNumber() {
        return this.recordNumber_;
    }

    public long getRecordNumberLong() {
        return this.recordNumberLong_;
    }

    public int hashCode() {
        return this.recordNumber_ == 0 ? this.recordLength_ : this.recordNumber_;
    }

    private void initializeRecord(RecordFormat recordFormat) {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        if (recordFormat.getNumberOfFields() == 0) {
            throw new ExtendedIllegalArgumentException("recordFormat", 2);
        }
        this.recordFormat_ = recordFormat;
        this.fieldDescriptions_ = recordFormat.getFieldDescriptions();
        this.hasDependentFields_ = this.recordFormat_.getHasDependentFields();
        this.fields_ = new Object[this.fieldDescriptions_.length];
        this.returnFields_ = new Object[this.fieldDescriptions_.length];
        this.fieldOffsets_ = new int[this.fieldDescriptions_.length];
        this.isConvertedToJava_ = new boolean[this.fieldDescriptions_.length];
        this.isConvertedToAS400_ = new boolean[this.fieldDescriptions_.length];
        this.nullFieldMap_ = new boolean[this.fieldDescriptions_.length];
        FieldDescription fd = null;
        AS400DataType dType = null;
        byte[] lenAsBytes = new byte[2];
        int offset = 0;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        this.recordLength_ = 0;
        for (int i = 0; i < this.fields_.length; ++i) {
            fd = this.fieldDescriptions_[i];
            Object obj = fd.getDFT();
            this.fieldOffsets_[i] = offset;
            if (obj == null) {
                if (fd.isDFTNull()) {
                    this.fields_[i] = fd.getDataType().getDefaultValue();
                    this.nullFieldMap_[i] = this.fieldDescriptions_[i].getALWNULL();
                } else if (fd.isDFTCurrent()) {
                    this.fields_[i] = fd.getDFTCurrentValue();
                } else {
                    this.fields_[i] = fd.getDataType().getDefaultValue();
                    if (this.fieldDescriptions_[i].getALWNULL()) {
                        this.nullFieldMap_[i] = true;
                        this.fields_[i] = null;
                    } else {
                        this.nullFieldMap_[i] = false;
                    }
                }
            } else {
                this.fields_[i] = obj;
            }
            if (fd instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)fd)).isVariableLength()) {
                int variableFieldLength = obj == null ? 0 : (fd instanceof HexFieldDescription ? ((byte[])obj).length : ((String)obj).length());
                BinaryConverter.unsignedShortToByteArray(variableFieldLength, lenAsBytes, 0);
                b.write(lenAsBytes, 0, 2);
                offset += 2;
                this.recordLength_ += 2;
            }
            dType = fd.getDataType();
            if (this.fields_[i] != null) {
                b.write(dType.toBytes(this.fields_[i]), 0, dType.getByteLength());
            } else {
                b.write(dType.toBytes(dType.getDefaultValue()), 0, dType.getByteLength());
            }
            this.isConvertedToJava_[i] = true;
            this.isConvertedToAS400_[i] = true;
            offset += fd.getDataType().getByteLength();
            this.recordLength_ += fd.getDataType().getByteLength();
        }
        this.as400Data_ = b.toByteArray();
        if (this.recordDescriptionListeners_ != null) {
            this.fireFieldModifiedEvent();
        }
    }

    void initializeTextObjects(AS400 system) {
        if (this.recordFormat_ != null) {
            this.recordFormat_.initializeTextObjects(system);
        }
        if (this.fieldDescriptions_ != null) {
            for (int i = 0; i < this.fieldDescriptions_.length; ++i) {
                AS400DataType dt = this.fieldDescriptions_[i].dataType_;
                if (dt.getInstanceType() != 9) continue;
                ((AS400Text)dt).setConverter(((AS400Text)dt).getConverter());
            }
        }
    }

    private void initializeTransient() {
    }

    public boolean isNullField(int index) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (index < 0 || index > this.fields_.length - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return this.nullFieldMap_[index];
    }

    public boolean isNullField(String name) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        return this.nullFieldMap_[this.recordFormat_.getIndexOfFieldName(name)];
    }

    private int readFromStream(InputStream in, byte[] buf, int offset, int length) throws IOException {
        boolean endOfFile = false;
        int bytesRead = 0;
        while (bytesRead < length && !endOfFile) {
            int temp = in.read(buf, offset + bytesRead, length - bytesRead);
            if (temp == -1) {
                endOfFile = true;
                continue;
            }
            bytesRead += temp;
        }
        return bytesRead;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeRecordDescriptionListener(RecordDescriptionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.recordDescriptionListeners_ != null) {
            this.recordDescriptionListeners_.removeElement(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setContents(byte[] contents) throws UnsupportedEncodingException {
        this.setContents(contents, 0);
    }

    public void setContents(byte[] contents, int offset) throws UnsupportedEncodingException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (contents == null) {
            throw new NullPointerException("contents");
        }
        if (contents.length == 0) {
            throw new ExtendedIllegalArgumentException("contents", 1);
        }
        if (offset < 0 || offset >= contents.length) {
            throw new ExtendedIllegalArgumentException("offset (" + offset + ")", 4);
        }
        if (this.hasDependentFields_) {
            int numFields = this.recordFormat_.getNumberOfFields();
            this.recordLength_ = 0;
            for (int i = 0; i < numFields; ++i) {
                FieldDescription f = this.fieldDescriptions_[i];
                int lengthDependField = this.recordFormat_.getLengthDependency(i);
                int offsetDependField = this.recordFormat_.getOffsetDependency(i);
                AS400DataType dType = f.getDataType();
                int length = dType.getByteLength();
                if (offsetDependField != -1) {
                    offset = ((Number)this.fields_[offsetDependField]).intValue();
                }
                if (lengthDependField != -1) {
                    AS400DataType newDataType = null;
                    length = ((Number)this.fields_[lengthDependField]).intValue();
                    boolean varLen = false;
                    if (f instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)f)).isVariableLength()) {
                        offset += 2;
                        this.recordLength_ += 2;
                        varLen = true;
                    }
                    if (f instanceof HexFieldDescription) {
                        newDataType = new AS400ByteArray(length);
                    } else if (f instanceof ArrayFieldDescription) {
                        newDataType = new AS400Array(((AS400Array)dType).getType(), length);
                    } else {
                        AS400Text dtText = (AS400Text)dType;
                        newDataType = new AS400Text(length, dtText.getCcsid());
                        ((AS400Text)newDataType).setConverter(dtText.getConverter());
                    }
                    if (!varLen) {
                        f.setDataType(newDataType);
                    }
                    this.fields_[i] = newDataType.toObject(contents, offset);
                    this.recordLength_ += f.getDataType().getByteLength();
                } else if (f instanceof VariableLengthFieldDescription) {
                    if (((VariableLengthFieldDescription)((Object)f)).isVariableLength()) {
                        int variableFieldLength = BinaryConverter.byteArrayToUnsignedShort(contents, offset);
                        offset += 2;
                        this.recordLength_ += 2;
                        if (f instanceof HexFieldDescription) {
                            byte[] b = new byte[variableFieldLength];
                            System.arraycopy(contents, offset, b, 0, variableFieldLength);
                            this.fields_[i] = b;
                        } else {
                            ConverterImpl c = ((AS400Text)dType).getConverter();
                            this.fields_[i] = c.byteArrayToString(contents, offset, variableFieldLength);
                        }
                        this.recordLength_ += dType.getByteLength();
                    } else {
                        this.fields_[i] = dType.toObject(contents, offset);
                        this.recordLength_ += dType.getByteLength();
                    }
                } else {
                    this.fields_[i] = dType.toObject(contents, offset);
                    this.recordLength_ += dType.getByteLength();
                }
                offset += length;
                this.isConvertedToJava_[i] = true;
                this.isConvertedToAS400_[i] = false;
            }
            if (this.recordDescriptionListeners_ != null) {
                this.fireFieldModifiedEvent();
            }
        } else {
            if (contents.length - offset < this.as400Data_.length) {
                Trace.log(2, "Byte array has insufficient length for record.  contents length: " + contents.length + ", offset: " + offset + ", record length: " + this.as400Data_.length);
                throw new ExtendedIllegalArgumentException("contents.length (" + contents.length + "), offset (" + offset + "), recordLength (" + this.as400Data_.length + ")", 4);
            }
            System.arraycopy(contents, offset, this.as400Data_, 0, this.as400Data_.length);
            for (int i = 0; i < this.isConvertedToJava_.length; ++i) {
                this.isConvertedToJava_[i] = false;
                this.isConvertedToAS400_[i] = true;
            }
        }
    }

    public void setContents(InputStream in) throws IOException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (in == null) {
            throw new NullPointerException("in");
        }
        byte[] contents = new byte[this.recordLength_];
        if (this.readFromStream(in, contents, 0, this.recordLength_) != this.recordLength_) {
            throw new ExtendedIOException("Unable to read " + String.valueOf(this.recordLength_) + "bytes", 25);
        }
        this.setContents(contents, 0);
    }

    public void setField(int index, Object value) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (index < 0 || index > this.fields_.length - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        this.fields_[index] = value;
        if (this.recordDescriptionListeners_ != null) {
            this.fireFieldModifiedEvent();
        }
        this.nullFieldMap_[index] = value == null;
        this.isConvertedToJava_[index] = true;
        byte[] convertedFieldBytes = null;
        if (!this.hasDependentFields_) {
            int offset = this.fieldOffsets_[index];
            int variableFieldLength = 0;
            FieldDescription f = this.fieldDescriptions_[index];
            if (f instanceof VariableLengthFieldDescription && ((VariableLengthFieldDescription)((Object)f)).isVariableLength()) {
                if (this.fields_[index] != null) {
                    try {
                        AS400DataType tmpDataType = f.getDataType();
                        if (tmpDataType instanceof AS400Text) {
                            int tmpCcsid = ((AS400Text)tmpDataType).getCcsid();
                            convertedFieldBytes = CharConverter.stringToByteArray(tmpCcsid, (String)this.fields_[index]);
                            variableFieldLength = convertedFieldBytes.length;
                        } else {
                            int n = variableFieldLength = f instanceof HexFieldDescription ? ((byte[])this.fields_[index]).length : ((String)this.fields_[index]).length();
                        }
                        if (f instanceof DBCSGraphicFieldDescription) {
                            variableFieldLength /= 2;
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        Trace.log(2, "Record.setField received UnsupportedEncodingException", (Throwable)e);
                        throw new InternalErrorException(10);
                    }
                }
                BinaryConverter.unsignedShortToByteArray(variableFieldLength, this.as400Data_, offset);
                offset += 2;
            }
            AS400DataType dType = f.getDataType();
            if (this.fields_[index] != null) {
                if (convertedFieldBytes != null) {
                    System.arraycopy(convertedFieldBytes, 0, this.as400Data_, offset, convertedFieldBytes.length);
                } else {
                    dType.toBytes(this.fields_[index], this.as400Data_, offset);
                }
            } else {
                dType.toBytes(dType.getDefaultValue(), this.as400Data_, offset);
            }
            this.isConvertedToAS400_[index] = true;
        } else {
            this.isConvertedToAS400_[index] = false;
        }
    }

    public void setField(String name, Object value) {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        this.setField(this.recordFormat_.getIndexOfFieldName(name), value);
    }

    public void setRecordFormat(RecordFormat recordFormat) throws PropertyVetoException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordFormat", this.recordFormat_, recordFormat);
        }
        RecordFormat old = this.recordFormat_;
        this.initializeRecord(recordFormat);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordFormat", old, this.recordFormat_);
        }
    }

    public void setRecordName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordName", this.name_, name);
        }
        String old = this.name_;
        this.name_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordName", old, this.name_);
        }
    }

    public void setRecordNumber(int recordNumber) throws PropertyVetoException {
        if (recordNumber < 0) {
            throw new ExtendedIllegalArgumentException("recordNumber", 4);
        }
        Integer old = null;
        Integer newnum = null;
        if (this.vetos_ != null || this.changes_ != null) {
            old = this.recordNumber_;
            newnum = recordNumber;
        }
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordNumber", old, newnum);
        }
        this.recordNumber_ = recordNumber;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordNumber", old, newnum);
        }
    }

    public void setRecordNumberLong(long recordNumber) throws PropertyVetoException {
        if (recordNumber > 0xFFFFFFF8L || recordNumber < 0L) {
            throw new ExtendedIllegalArgumentException("recordNumber", 4);
        }
        Long old = null;
        Long newnum = null;
        if (this.vetos_ != null || this.changes_ != null) {
            old = this.recordNumberLong_;
            newnum = recordNumber;
        }
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordNumberLong_", old, newnum);
        }
        this.recordNumberLong_ = recordNumber;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordNumberLong_", old, newnum);
        }
    }

    public String toString() {
        if (this.recordFormat_ == null) {
            return "";
        }
        StringBuffer theRecord = new StringBuffer(0);
        Object obj = null;
        for (int i = 0; i < this.fields_.length; ++i) {
            try {
                obj = this.getField(i);
            }
            catch (UnsupportedEncodingException e) {
                obj = null;
            }
            catch (Exception e) {
                obj = "???";
            }
            if (obj == null) {
                theRecord.append("null");
            } else if (obj instanceof byte[]) {
                theRecord.append(new String((byte[])obj));
            } else {
                theRecord.append(obj.toString());
            }
            theRecord.append(" ");
        }
        return theRecord.toString().substring(0, theRecord.length() - 1);
    }
}

