/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ProxyImpl;
import com.ibm.as400.access.PxCompDS;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxParm;
import com.ibm.as400.access.PxPxObjectParm;
import com.ibm.as400.access.PxSerializedObjectParm;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import java.util.Vector;

class PxToolboxObjectParm
extends PxCompDS
implements PxParm {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static boolean DEBUG_ = false;
    private Object value_;

    public PxToolboxObjectParm() {
        super((short)26050);
    }

    public PxToolboxObjectParm(Object value) {
        super((short)26050);
        this.value_ = value;
        if (DEBUG_) {
            System.out.println("Creating toolbox object parm: " + value + " (" + value.getClass() + ").");
        }
        this.addParm(new PxSerializedObjectParm(value));
        Vector fieldNames = new Vector();
        Vector proxyImpls = new Vector();
        PxToolboxObjectParm.analyze(value, "", fieldNames, proxyImpls);
        int proxyCount = proxyImpls.size();
        this.addParm(new PxIntParm(proxyCount));
        for (int i = 0; i < proxyCount; ++i) {
            this.addParm(new PxStringParm((String)fieldNames.elementAt(i)));
            this.addParm(new PxPxObjectParm(((ProxyImpl)proxyImpls.elementAt(i)).getPxId()));
        }
    }

    private static void analyze(Object objectValue, String prefix, Vector fieldNames, Vector proxyImpls) {
        block11: {
            if (DEBUG_) {
                System.out.println("Analyzing " + objectValue + " (" + objectValue.getClass() + ").");
                System.out.println("Prefix=" + prefix + ".");
            }
            try {
                Class<?> clazz = objectValue.getClass();
                while (!clazz.equals(Object.class)) {
                    Field[] declaredFields = clazz.getDeclaredFields();
                    if (declaredFields != null) {
                        for (int i = 0; i < declaredFields.length; ++i) {
                            String fieldName = declaredFields[i].getName();
                            if (DEBUG_) {
                                System.out.println("Field name=" + fieldName + ".");
                            }
                            if (Modifier.isTransient(declaredFields[i].getModifiers())) continue;
                            try {
                                Object fieldValue = declaredFields[i].get(objectValue);
                                if (fieldValue == null) continue;
                                if (DEBUG_) {
                                    System.out.println("Field value=" + fieldValue + " (" + fieldValue.getClass() + ").");
                                }
                                if (Modifier.isStatic(declaredFields[i].getModifiers()) || !fieldValue.getClass().getName().startsWith("com.ibm.as400.access")) continue;
                                if (fieldValue instanceof ProxyImpl) {
                                    fieldNames.addElement(prefix + fieldName);
                                    proxyImpls.addElement((ProxyImpl)fieldValue);
                                    continue;
                                }
                                if (!fieldValue.getClass().getName().startsWith("com.ibm.as400.access")) continue;
                                PxToolboxObjectParm.analyze(fieldValue, fieldValue + ".", fieldNames, proxyImpls);
                                continue;
                            }
                            catch (IllegalAccessException e) {
                                if (!DEBUG_) continue;
                                System.out.println("Ignored IllegalAccessException:" + e.getMessage());
                            }
                        }
                    }
                    clazz = clazz.getSuperclass();
                }
            }
            catch (Exception e) {
                if (!Trace.isTraceErrorOn()) break block11;
                Trace.log(2, "Exception when analyzing Toolbox parm", (Throwable)e);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        this.value_ = null;
        return super.clone();
    }

    @Override
    public Object getObjectValue() {
        return this.value_;
    }

    @Override
    public void readFrom(InputStream input, PxDSFactory factory) throws IOException {
        super.readFrom(input, factory);
        this.value_ = this.getParm(0).getObjectValue();
        int proxyCount = ((PxIntParm)this.getParm(1)).getIntValue();
        int parmIndex = 1;
        for (int i = 1; i <= proxyCount; ++i) {
            String fieldName = ((PxStringParm)this.getParm(++parmIndex)).getStringValue();
            Object impl = ((PxPxObjectParm)this.getParm(++parmIndex)).getObjectValue();
            Object fieldValue = this.value_;
            Field field = null;
            StringTokenizer tokenizer = new StringTokenizer(fieldName, ".");
            while (tokenizer.hasMoreTokens()) {
                block9: {
                    String token = tokenizer.nextToken();
                    Class<?> clazz = fieldValue.getClass();
                    try {
                        field = clazz.getDeclaredField(token);
                        if (field == null && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Error reading toolbox parm: field set to null");
                        }
                    }
                    catch (NoSuchFieldException e) {
                        if (!Trace.isTraceErrorOn()) break block9;
                        Trace.log(2, "Error reading toolbox parm", (Throwable)e);
                    }
                }
                try {
                    if (!tokenizer.hasMoreTokens() || field == null) continue;
                    fieldValue = field.get(fieldValue);
                }
                catch (IllegalAccessException e) {
                    if (!Trace.isTraceErrorOn()) continue;
                    Trace.log(2, "Error reading toolbox parm", (Throwable)e);
                }
            }
            try {
                if (field == null) continue;
                field.set(fieldValue, impl);
                continue;
            }
            catch (IllegalAccessException e) {
                if (!Trace.isTraceErrorOn()) continue;
                Trace.log(2, "Error reading toolbox parm", (Throwable)e);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.value_ + ")";
    }
}

