/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DLOPermission;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;

class PermissionAccessDLO
extends PermissionAccess {
    public PermissionAccessDLO(AS400 system) {
        super(system);
    }

    @Override
    public void addUser(String objName, UserPermission permission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall addUser = PermissionAccessDLO.getAddCommand(this.as400_, objName = PermissionAccessDLO.toUpperCasePath(objName), permission);
        if (!addUser.run()) {
            AS400Message[] msgList = addUser.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    protected final String expandQuotes(String objName) {
        return PermissionAccessDLO.expandQuotes0(objName);
    }

    static String expandQuotes0(String objName) {
        StringBuffer buf = new StringBuffer(objName);
        if (objName.indexOf(39) != -1) {
            for (int i = objName.length() - 1; i >= 0; --i) {
                if (buf.charAt(i) != '\'') continue;
                buf.insert(i, '\'');
            }
        }
        buf.insert(0, '\'');
        buf.append('\'');
        return buf.toString();
    }

    private static CommandCall getAddCommand(AS400 sys, String objName, UserPermission permission) {
        DLOPermission dloPermission = (DLOPermission)permission;
        String userProfile = dloPermission.getUserID();
        String authorityLevel = dloPermission.getDataAuthority();
        try {
            objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, sys.getCcsid());
        }
        catch (Exception e) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)e);
        }
        int index1 = objName.indexOf(47, 1);
        int index2 = objName.lastIndexOf(47);
        String name = objName.substring(index2 + 1);
        String folder = index1 + 1 < index2 ? objName.substring(index1 + 1, index2) : "*NONE";
        String command = "ADDDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(name) + ") FLR('" + folder + "') USRAUT((" + userProfile + " " + authorityLevel + "))";
        CommandCall cmd = new CommandCall(sys, command);
        return cmd;
    }

    private static CommandCall getChgCommand(AS400 sys, String objName, UserPermission permission) {
        DLOPermission dloPermission = (DLOPermission)permission;
        String userProfile = dloPermission.getUserID();
        String authorityLevel = dloPermission.getDataAuthority();
        try {
            objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, sys.getCcsid());
        }
        catch (Exception e) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)e);
        }
        int index1 = objName.indexOf(47, 1);
        int index2 = objName.lastIndexOf(47);
        String name = objName.substring(index2 + 1);
        if (name.equals("QDLS")) {
            name = "*ROOT";
        }
        String folder = index1 + 1 < index2 ? objName.substring(index1 + 1, index2) : "*NONE";
        String command = "CHGDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(name) + ") FLR('" + folder + "') USRAUT((" + userProfile + " " + authorityLevel + "))";
        CommandCall cmd = new CommandCall(sys, command);
        return cmd;
    }

    private static CommandCall getRmvCommand(AS400 sys, String objName, String userName) {
        try {
            objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, sys.getCcsid());
        }
        catch (Exception e) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)e);
        }
        int index1 = objName.indexOf(47, 1);
        int index2 = objName.lastIndexOf(47);
        String name = objName.substring(index2 + 1);
        String folder = index1 + 1 < index2 ? objName.substring(index1 + 1, index2) : "*NONE";
        String command = "RMVDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(name) + ") FLR('" + folder + "') USER((" + userName + "))";
        CommandCall cmd = new CommandCall(sys, command);
        return cmd;
    }

    @Override
    public UserPermission getUserPermission(Record userRecord) throws UnsupportedEncodingException {
        String profileName = ((String)userRecord.getField("profileName")).trim();
        String userOrGroup = ((String)userRecord.getField("userOrGroup")).trim();
        String dataAuthority = ((String)userRecord.getField("dataAuthority")).trim();
        String autListMgt = ((String)userRecord.getField("autListMgt")).trim();
        String objMgt = ((String)userRecord.getField("objMgt")).trim();
        String objExistence = ((String)userRecord.getField("objExistence")).trim();
        String objAlter = ((String)userRecord.getField("objAlter")).trim();
        String objRef = ((String)userRecord.getField("objRef")).trim();
        String objOperational = ((String)userRecord.getField("objOperational")).trim();
        String dataRead = ((String)userRecord.getField("dataRead")).trim();
        String dataAdd = ((String)userRecord.getField("dataAdd")).trim();
        String dataUpdate = ((String)userRecord.getField("dataUpdate")).trim();
        String dataDelete = ((String)userRecord.getField("dataDelete")).trim();
        String dataExecute = ((String)userRecord.getField("dataExecute")).trim();
        DLOPermission permission = new DLOPermission(profileName);
        permission.setGroupIndicator(this.getIntValue(userOrGroup));
        permission.setAuthorizationListManagement(this.getBooleanValue(autListMgt));
        permission.setManagement(this.getBooleanValue(objMgt));
        permission.setExistence(this.getBooleanValue(objExistence));
        permission.setAlter(this.getBooleanValue(objAlter));
        permission.setReference(this.getBooleanValue(objRef));
        permission.setOperational(this.getBooleanValue(objOperational));
        permission.setRead(this.getBooleanValue(dataRead));
        permission.setAdd(this.getBooleanValue(dataAdd));
        permission.setUpdate(this.getBooleanValue(dataUpdate));
        permission.setDelete(this.getBooleanValue(dataDelete));
        permission.setExecute(this.getBooleanValue(dataExecute));
        if (dataAuthority.equalsIgnoreCase("*AUTL")) {
            permission.setFromAuthorizationList(true);
        }
        return permission;
    }

    @Override
    public void removeUser(String objName, String userName) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall rmvUser = PermissionAccessDLO.getRmvCommand(this.as400_, objName = PermissionAccessDLO.toUpperCasePath(objName), userName);
        if (!rmvUser.run()) {
            AS400Message[] msgList = rmvUser.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setAuthority(String objName, UserPermission permission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall setAuthority = PermissionAccessDLO.getChgCommand(this.as400_, objName = PermissionAccessDLO.toUpperCasePath(objName), permission);
        if (!setAuthority.run()) {
            AS400Message[] msgList = setAuthority.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setAuthorizationList(String objName, String autList, String oldValue) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        objName = PermissionAccessDLO.toUpperCasePath(objName);
        try {
            objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, this.as400_.getCcsid());
        }
        catch (Exception e) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)e);
        }
        int index1 = objName.indexOf(47, 1);
        int index2 = objName.lastIndexOf(47);
        String name = objName.substring(index2 + 1);
        String folder = index1 + 1 < index2 ? objName.substring(index1 + 1, index2) : "*NONE";
        CommandCall setAUTL = new CommandCall(this.as400_);
        String cmd = autList.equalsIgnoreCase("*NONE") ? "RMVDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(name) + ") FLR('" + folder + "') AUTL(" + oldValue + ")" : "CHGDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(name) + ") FLR('" + folder + "') AUTL(" + autList + ")";
        setAUTL.setCommand(cmd);
        if (!setAUTL.run()) {
            AS400Message[] msgList = setAUTL.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setFromAuthorizationList(String objName, boolean fromAutl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        objName = PermissionAccessDLO.toUpperCasePath(objName);
        try {
            objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, this.as400_.getCcsid());
        }
        catch (Exception e) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)e);
        }
        int index1 = objName.indexOf(47, 1);
        int index2 = objName.lastIndexOf(47);
        String name = objName.substring(index2 + 1);
        String folder = index1 + 1 < index2 ? objName.substring(index1 + 1, index2) : "*NONE";
        CommandCall fromAUTL = new CommandCall(this.as400_);
        String cmd = "CHGDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(name) + ") FLR('" + folder + "') USRAUT((*PUBLIC *AUTL))";
        fromAUTL.setCommand(cmd);
        if (!fromAUTL.run()) {
            AS400Message[] msgList = fromAUTL.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public void setPrimaryGroup(String objName, String primaryGroup, boolean revokeOldAuthority) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        try {
            objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, this.as400_.getCcsid());
        }
        catch (Exception e) {
            Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)e);
        }
        super.setPrimaryGroup(objName, primaryGroup, revokeOldAuthority);
    }

    @Override
    public void setOwner(String objName, String owner, boolean revokeOldAuthority) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        try {
            objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, this.as400_.getCcsid());
        }
        catch (Exception e) {
            Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)e);
        }
        super.setOwner(objName, owner, revokeOldAuthority);
    }

    @Override
    public synchronized void setSensitivity(String objName, int sensitivityLevel) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        objName = PermissionAccessDLO.toUpperCasePath(objName);
        try {
            objName = CharConverter.convertIFSQSYSPathnameToJobPathname(objName, this.as400_.getCcsid());
        }
        catch (Exception e) {
            Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)e);
        }
        int index1 = objName.indexOf(47, 1);
        int index2 = objName.lastIndexOf(47);
        String name = objName.substring(index2 + 1);
        String folder = index1 + 1 < index2 ? objName.substring(index1 + 1, index2) : "*NONE";
        CommandCall setSensitiv = new CommandCall(this.as400_);
        String sensitivity = "";
        switch (sensitivityLevel) {
            case 1: {
                sensitivity = "*NONE";
                break;
            }
            case 2: {
                sensitivity = "*PERSONAL";
                break;
            }
            case 3: {
                sensitivity = "*PRIVATE";
                break;
            }
            case 4: {
                sensitivity = "*CONFIDENTIAL";
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("sensitivity", 2);
            }
        }
        String cmd = "CHGDLOAUT DLO(" + PermissionAccessDLO.expandQuotes0(name) + ") FLR('" + folder + "') SENSITIV(" + sensitivity + ")";
        setSensitiv.setCommand(cmd);
        if (!setSensitiv.run()) {
            AS400Message[] msgList = setSensitiv.getMessageList();
            throw new AS400Exception(msgList);
        }
    }
}

