/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSRandomAccessFileImpl;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyReturnValue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class IFSRandomAccessFileImplProxy
extends AbstractProxyImpl
implements IFSRandomAccessFileImpl {
    private static final boolean[] ARGS_TO_RETURN = new boolean[]{true, false, false, false};

    IFSRandomAccessFileImplProxy() {
        super("IFSRandomAccessFile");
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "close");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void connectAndOpen() throws AS400SecurityException, IOException {
        try {
            this.connection_.callMethod(this.pxId_, "connectAndOpen");
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            if (e1 instanceof AS400SecurityException) {
                throw (AS400SecurityException)e1;
            }
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "flush");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public long length() throws IOException {
        try {
            return this.connection_.callMethod(this.pxId_, "length").getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public IFSKey lock(long offset, long length) throws IOException {
        try {
            return (IFSKey)this.connection_.callMethod(this.pxId_, "lock", new Class[]{Long.TYPE, Long.TYPE}, new Object[]{offset, length}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void open() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "open");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public int read(byte[] data, int dataOffset, int length, boolean readFully) throws IOException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "read", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{data, dataOffset, length, readFully}, ARGS_TO_RETURN, readFully);
            byte[] returnDataBuffer = (byte[])rv.getArgument(0);
            System.arraycopy(returnDataBuffer, 0, data, 0, data.length);
            return rv.getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public String readLine() throws IOException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "readLine").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public String readUTF() throws IOException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "readUTF").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void setExistenceOption(int existenceOption) {
        try {
            this.connection_.callMethod(this.pxId_, "setExistenceOption", new Class[]{Integer.TYPE}, new Object[]{existenceOption});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void setFD(IFSFileDescriptorImpl fd) {
        try {
            this.connection_.callMethod(this.pxId_, "setFD", new Class[]{IFSFileDescriptorImpl.class}, new Object[]{fd});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void setForceToStorage(boolean forceToStorage) {
        try {
            this.connection_.callMethod(this.pxId_, "setForceToStorage", new Class[]{Boolean.TYPE}, new Object[]{forceToStorage});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void setLength(long length) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "setLength", new Class[]{Long.TYPE}, new Object[]{length});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void setMode(String mode) {
        try {
            this.connection_.callMethod(this.pxId_, "setMode", new Class[]{String.class}, new Object[]{mode});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void unlock(IFSKey key) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "unlock", new Class[]{IFSKey.class}, new Object[]{key});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void writeBytes(byte[] data, int dataOffset, int length) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "writeBytes", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{data, dataOffset, length});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "writeUTF", new Class[]{String.class}, new Object[]{s});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }
}

