/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.CADSPool;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class ClientAccessDataStream
extends DataStream {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    protected static final int HEADER_LENGTH = 20;
    private static final CADSPool basePool_ = new CADSPool();
    private InUseLock inUseLock_ = new InUseLock();
    boolean inUse_;
    private CADSPool fromPool_ = null;
    private int fromPoolIndex_ = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ClientAccessDataStream construct(InputStream is, Hashtable dataStreams, Hashtable dataStreamPrototypes, AS400ImplRemote system, int connectionID) throws IOException {
        ClientAccessDataStream baseDataStream = basePool_.getUnusedStream();
        try {
            byte[] data = baseDataStream.data_;
            if (ClientAccessDataStream.readFromStream(is, data, 0, 20, connectionID) < 20) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Failed to read all of the data stream header.");
                }
                baseDataStream.returnToPool();
                baseDataStream = null;
                throw new ConnectionDroppedException(2);
            }
            int length = baseDataStream.getLength();
            if (baseDataStream.data_[6] != -32) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Incorrect data stream header detected.", baseDataStream.data_, 0, 20);
                }
                baseDataStream.returnToPool();
                baseDataStream = null;
                is.skip(is.available());
                throw new InternalErrorException(2);
            }
            ClientAccessDataStream newDataStream = (ClientAccessDataStream)dataStreams.get(baseDataStream);
            if (newDataStream != null && newDataStream instanceof NPDataStream) {
                NPDataStream npds = (NPDataStream)newDataStream;
                if (baseDataStream.getCorrelation() == npds.getCorrelationID()) {
                    dataStreams.remove(baseDataStream);
                }
            }
            if (newDataStream != null && !(newDataStream instanceof NPDataStream)) {
                newDataStream = (ClientAccessDataStream)dataStreams.remove(baseDataStream);
            }
            if (newDataStream == null) {
                ClientAccessDataStream modelDataStream = (ClientAccessDataStream)dataStreamPrototypes.get(baseDataStream);
                if (modelDataStream == null) {
                    newDataStream = new ClientAccessDataStream();
                } else {
                    newDataStream = (ClientAccessDataStream)modelDataStream.getNewDataStream();
                    if (newDataStream == null) {
                        newDataStream = new ClientAccessDataStream();
                    }
                }
            }
            newDataStream.system_ = system;
            if (Trace.traceOn_) {
                newDataStream.setConnectionID(connectionID);
            }
            int nowLength = baseDataStream.getLength();
            newDataStream.data_ = new byte[nowLength];
            System.arraycopy(baseDataStream.data_, 0, newDataStream.data_, 0, 20);
            if (newDataStream.data_.length - 20 > 0) {
                newDataStream.readAfterHeader(is);
            }
            ClientAccessDataStream clientAccessDataStream = newDataStream;
            return clientAccessDataStream;
        }
        finally {
            if (baseDataStream != null) {
                baseDataStream.returnToPool();
                baseDataStream = null;
            }
        }
    }

    protected ClientAccessDataStream() {
        super(20);
    }

    ClientAccessDataStream(byte[] ds) {
        super(20, ds);
    }

    ClientAccessDataStream(CADSPool pool, int poolIndex) {
        super(20);
        this.fromPool_ = pool;
        this.fromPoolIndex_ = poolIndex;
    }

    @Override
    int getCorrelation() {
        return this.get32bit(12);
    }

    int getCSInstance() {
        return this.get32bit(8);
    }

    int getHeaderID() {
        return this.get16bit(4);
    }

    @Override
    int getLength() {
        return this.get32bit(0);
    }

    int getReqRepID() {
        return ((this.data_[18] & 0xFF) << 8) + (this.data_[19] & 0xFF);
    }

    int getServerID() {
        return this.get16bit(6);
    }

    int getTemplateLen() {
        return this.get16bit(16);
    }

    @Override
    public int hashCode() {
        return ((this.data_[18] & 0xFF) << 8) + (this.data_[19] & 0xFF);
    }

    @Override
    protected void setCorrelation(int id) {
        this.set32bit(id, 12);
    }

    protected void setCSInstance(int id) {
        this.set32bit(id, 8);
    }

    protected void setHeaderID(int id) {
        this.set16bit(id, 4);
    }

    @Override
    protected void setLength(int len) {
        this.data_[0] = (byte)(len >>> 24);
        this.data_[1] = (byte)(len >>> 16);
        this.data_[2] = (byte)(len >>> 8);
        this.data_[3] = (byte)len;
    }

    protected void setReqRepID(int id) {
        this.set16bit(id, 18);
    }

    protected void setServerID(int id) {
        this.set16bit(id, 6);
    }

    protected void setTemplateLen(int len) {
        this.set16bit(len, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnToPool() throws InternalErrorException {
        InUseLock inUseLock = this.inUseLock_;
        synchronized (inUseLock) {
            if (!this.inUse_) {
                throw new InternalErrorException(6);
            }
            this.inUse_ = false;
        }
        if (this.fromPool_ != null) {
            this.fromPool_.returnToPool(this, this.fromPoolIndex_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUse() {
        InUseLock inUseLock = this.inUseLock_;
        synchronized (inUseLock) {
            if (this.inUse_) {
                return false;
            }
            this.inUse_ = true;
            return true;
        }
    }

    private class InUseLock {
        private InUseLock() {
        }
    }
}

