/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.concurrent.Awaitable;

@Shared(scope={Shared.Scope.SIMULATION}, ancestors=Shared.Recursive.INTERFACES)
public interface Future<V>
extends io.netty.util.concurrent.Future<V>,
ListenableFuture<V>,
Awaitable {
    @Override
    public Future<V> await() throws InterruptedException;

    @Override
    public Future<V> awaitUninterruptibly();

    @Override
    public Future<V> awaitThrowUncheckedOnInterrupt();

    default public void rethrowIfFailed() {
        Throwable cause = this.cause();
        if (cause != null) {
            PlatformDependent.throwException((Throwable)cause);
        }
    }

    default public Future<V> sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    default public Future<V> syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed();
        return this;
    }

    default public Future<V> syncThrowUncheckedOnInterrupt() {
        this.awaitThrowUncheckedOnInterrupt();
        this.rethrowIfFailed();
        return this;
    }

    @Deprecated
    default public boolean await(long l) throws InterruptedException {
        return this.await(l, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    default public boolean awaitUninterruptibly(long l) {
        return this.awaitUninterruptibly(l, TimeUnit.MILLISECONDS);
    }

    public Future<V> addCallback(BiConsumer<? super V, Throwable> var1);

    public Future<V> addCallback(BiConsumer<? super V, Throwable> var1, Executor var2);

    public Future<V> addCallback(FutureCallback<? super V> var1);

    public Future<V> addCallback(FutureCallback<? super V> var1, Executor var2);

    public Future<V> addCallback(Consumer<? super V> var1, Consumer<? super Throwable> var2);

    public Future<V> addCallback(Consumer<? super V> var1, Consumer<? super Throwable> var2, Executor var3);

    default public <T> Future<T> map(Function<? super V, ? extends T> mapper) {
        return this.map(mapper, null);
    }

    public <T> Future<T> map(Function<? super V, ? extends T> var1, Executor var2);

    default public <T> Future<T> flatMap(Function<? super V, ? extends Future<T>> flatMapper) {
        return this.flatMap(flatMapper, null);
    }

    public <T> Future<T> flatMap(Function<? super V, ? extends Future<T>> var1, Executor var2);

    public void addListener(Runnable var1, Executor var2);

    public void addListener(Runnable var1);

    public Executor notifyExecutor();

    public Future<V> addListener(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> var1);

    public Future<V> addListeners(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> ... var1);

    public Future<V> removeListener(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> var1);

    public Future<V> removeListeners(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> ... var1);
}

