/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public abstract class BoundedWindow {
    public static final @UnknownKeyFor @NonNull @Initialized Instant TIMESTAMP_MIN_VALUE = BoundedWindow.extractTimestampFromProto(RunnerApi.BeamConstants.Constants.MIN_TIMESTAMP_MILLIS);
    public static final @UnknownKeyFor @NonNull @Initialized Instant TIMESTAMP_MAX_VALUE = BoundedWindow.extractTimestampFromProto(RunnerApi.BeamConstants.Constants.MAX_TIMESTAMP_MILLIS);

    public static @UnknownKeyFor @NonNull @Initialized String formatTimestamp(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        if (timestamp.equals((Object)TIMESTAMP_MIN_VALUE)) {
            return timestamp.toString() + " (TIMESTAMP_MIN_VALUE)";
        }
        if (timestamp.equals((Object)TIMESTAMP_MAX_VALUE)) {
            return timestamp.toString() + " (TIMESTAMP_MAX_VALUE)";
        }
        if (timestamp.equals((Object)GlobalWindow.INSTANCE.maxTimestamp())) {
            return timestamp.toString() + " (end of global window)";
        }
        return timestamp.toString();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Instant maxTimestamp();

    private static @UnknownKeyFor @NonNull @Initialized Instant extractTimestampFromProto(@UnknownKeyFor @NonNull @Initialized RunnerApi.BeamConstants.Constants constant) {
        return new Instant(Long.parseLong((String)constant.getValueDescriptor().getOptions().getExtension(RunnerApi.beamConstant)));
    }

    public static void validateTimestampBounds(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        if (timestamp.isBefore((ReadableInstant)TIMESTAMP_MIN_VALUE) || timestamp.isAfter((ReadableInstant)TIMESTAMP_MAX_VALUE)) {
            throw new IllegalArgumentException(String.format("Provided timestamp %s must be within bounds [%s, %s].", timestamp, TIMESTAMP_MIN_VALUE, TIMESTAMP_MAX_VALUE));
        }
    }
}

