/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.TimestampObservingWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class WatermarkEstimators {
    private WatermarkEstimators() {
    }

    public static class MonotonicallyIncreasing
    implements TimestampObservingWatermarkEstimator<Instant> {
        private @UnknownKeyFor @NonNull @Initialized Instant watermark;
        private @UnknownKeyFor @NonNull @Initialized Instant lastObservedTimestamp;

        public MonotonicallyIncreasing(@UnknownKeyFor @NonNull @Initialized Instant watermark) {
            BoundedWindow.validateTimestampBounds(watermark);
            this.watermark = (Instant)Preconditions.checkNotNull((Object)watermark, (Object)"timestamp must not be null.");
        }

        @Override
        public void observeTimestamp(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            this.lastObservedTimestamp = timestamp;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant currentWatermark() {
            if (this.lastObservedTimestamp != null && this.lastObservedTimestamp.isAfter((ReadableInstant)this.watermark)) {
                this.watermark = this.lastObservedTimestamp;
            }
            return this.watermark;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getState() {
            return this.watermark;
        }
    }

    public static class WallTime
    implements WatermarkEstimator<Instant> {
        private @UnknownKeyFor @NonNull @Initialized Instant watermark;

        public WallTime(@UnknownKeyFor @NonNull @Initialized Instant watermark) {
            BoundedWindow.validateTimestampBounds(watermark);
            this.watermark = (Instant)Preconditions.checkNotNull((Object)watermark, (Object)"watermark must not be null.");
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant currentWatermark() {
            Instant now = Instant.now();
            this.watermark = now.isAfter((ReadableInstant)this.watermark) ? now : this.watermark;
            return this.watermark;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getState() {
            return this.watermark;
        }
    }

    public static class Manual
    implements ManualWatermarkEstimator<Instant> {
        private @UnknownKeyFor @NonNull @Initialized Instant watermark;
        private @UnknownKeyFor @NonNull @Initialized Instant lastReportedWatermark;

        public Manual(@UnknownKeyFor @NonNull @Initialized Instant watermark) {
            BoundedWindow.validateTimestampBounds(watermark);
            this.watermark = (Instant)Preconditions.checkNotNull((Object)watermark, (Object)"watermark must not be null.");
        }

        @Override
        public void setWatermark(@UnknownKeyFor @NonNull @Initialized Instant watermark) {
            BoundedWindow.validateTimestampBounds(watermark);
            this.lastReportedWatermark = watermark;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant currentWatermark() {
            if (this.lastReportedWatermark != null && this.lastReportedWatermark.isAfter((ReadableInstant)this.watermark)) {
                this.watermark = this.lastReportedWatermark;
            }
            return this.watermark;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getState() {
            return this.watermark;
        }
    }
}

