/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.UpdateBackupRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.FieldMask;
import com.google.protobuf.util.Timestamps;
import javax.annotation.Nonnull;
import org.threeten.bp.Instant;

public final class UpdateBackupRequest {
    private final UpdateBackupRequest.Builder requestBuilder = com.google.bigtable.admin.v2.UpdateBackupRequest.newBuilder();
    private final String backupId;
    private final String clusterId;

    public static UpdateBackupRequest of(String clusterId, String backupId) {
        UpdateBackupRequest request = new UpdateBackupRequest(clusterId, backupId);
        return request;
    }

    private UpdateBackupRequest(String clusterId, String backupId) {
        Preconditions.checkNotNull((Object)clusterId);
        Preconditions.checkNotNull((Object)backupId);
        this.backupId = backupId;
        this.clusterId = clusterId;
    }

    public UpdateBackupRequest setExpireTime(Instant expireTime) {
        Preconditions.checkNotNull((Object)expireTime);
        this.requestBuilder.getBackupBuilder().setExpireTime(Timestamps.fromMillis((long)expireTime.toEpochMilli()));
        this.requestBuilder.setUpdateMask(FieldMask.newBuilder().addPaths("expire_time"));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateBackupRequest that = (UpdateBackupRequest)o;
        return Objects.equal((Object)this.requestBuilder.getBackupBuilder().getExpireTime(), (Object)that.requestBuilder.getBackupBuilder().getExpireTime()) && Objects.equal((Object)this.requestBuilder.getUpdateMask(), (Object)that.requestBuilder.getUpdateMask()) && Objects.equal((Object)this.clusterId, (Object)that.clusterId) && Objects.equal((Object)this.backupId, (Object)that.backupId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.getBackupBuilder().getExpireTime(), this.requestBuilder.getUpdateMask(), this.backupId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.UpdateBackupRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        this.requestBuilder.getBackupBuilder().setName(NameUtil.formatBackupName(projectId, instanceId, this.clusterId, this.backupId));
        return this.requestBuilder.build();
    }
}

