/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.delegates;

import java.util.List;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.dialog.NotePadDialog;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;

public class HopGuiNotePadDelegate {
    private static final Class<?> PKG = HopGui.class;
    private HopGui hopGui;
    private IHopFileTypeHandler handler;
    private PropsUi props;

    public HopGuiNotePadDelegate(HopGui hopGui, IHopFileTypeHandler handler) {
        this.hopGui = hopGui;
        this.handler = handler;
        this.props = PropsUi.getInstance();
    }

    public void deleteNotes(AbstractMeta meta, List<NotePadMeta> notes) {
        if (notes == null || notes.isEmpty()) {
            return;
        }
        int[] idxs = new int[notes.size()];
        Object[] noteCopies = new NotePadMeta[notes.size()];
        for (int i = 0; i < idxs.length; ++i) {
            idxs[i] = meta.indexOfNote(notes.get(i));
            noteCopies[i] = new NotePadMeta(notes.get(i));
        }
        for (int idx : idxs) {
            meta.removeNote(idx);
        }
        this.hopGui.undoDelegate.addUndoDelete((IUndo)meta, noteCopies, idxs);
        this.handler.updateGui();
    }

    public void deleteNote(AbstractMeta meta, NotePadMeta notePadMeta) {
        int idx = meta.indexOfNote(notePadMeta);
        if (idx >= 0) {
            meta.removeNote(idx);
            this.hopGui.undoDelegate.addUndoDelete((IUndo)meta, new NotePadMeta[]{notePadMeta.clone()}, new int[]{idx});
        }
        this.handler.updateGui();
    }

    public void newNote(IVariables variables, AbstractMeta meta, int x, int y) {
        String title = BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.NoteEditor.Title", (String[])new String[0]);
        NotePadDialog dd = new NotePadDialog(variables, this.hopGui.getShell(), title);
        NotePadMeta n = dd.open();
        if (n != null) {
            NotePadMeta npi = new NotePadMeta(n.getNote(), x, y, 20, 20, n.getFontName(), n.getFontSize(), n.isFontBold(), n.isFontItalic(), n.getFontColorRed(), n.getFontColorGreen(), n.getFontColorBlue(), n.getBackGroundColorRed(), n.getBackGroundColorGreen(), n.getBackGroundColorBlue(), n.getBorderColorRed(), n.getBorderColorGreen(), n.getBorderColorBlue());
            meta.addNote(npi);
            this.hopGui.undoDelegate.addUndoNew((IUndo)meta, new NotePadMeta[]{npi}, new int[]{meta.indexOfNote(npi)});
            this.handler.updateGui();
        }
    }
}

