/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.metadata;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.TranslateUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.metadata.IMetadataDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataEditorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.GuiContextHandler;
import org.apache.hop.ui.hopgui.context.GuiContextUtil;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.eclipse.swt.widgets.Shell;

public class MetadataManager<T extends IHopMetadata> {
    private static final Class<?> PKG = MetadataManager.class;
    public static final String CONST_ERROR = "Error";
    public static final String CONST_ERROR_EDITING_METADATA = "Error editing metadata";
    private final Shell parentShell;
    private IHopMetadataProvider metadataProvider;
    private IVariables variables;
    private ClassLoader classLoader;
    private Class<T> managedClass;

    public MetadataManager(IVariables variables, IHopMetadataProvider metadataProvider, Class<T> managedClass, Shell parentShell) {
        this.variables = variables;
        this.classLoader = managedClass.getClassLoader();
        this.metadataProvider = metadataProvider;
        this.managedClass = managedClass;
        this.parentShell = parentShell;
    }

    public boolean editMetadata() {
        HopGui hopGui = HopGui.getInstance();
        try {
            List<String> names = this.getNames();
            HopMetadata hopMetadata = HopMetadataUtil.getHopMetadataAnnotation(this.managedClass);
            ArrayList<GuiAction> actions = new ArrayList<GuiAction>();
            for (String name : names) {
                GuiAction action = new GuiAction(name, GuiActionType.Modify, name, name + " : " + hopMetadata.description(), hopMetadata.image(), (shiftAction, controlAction, t) -> this.editMetadata(name));
                action.setClassLoader(this.getClassLoader());
                actions.add(action);
            }
            return GuiContextUtil.getInstance().handleActionSelection(hopGui.getActiveShell(), "Select the " + hopMetadata.name() + " to edit", new GuiContextHandler("HopGuiMetadataContext", actions));
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), CONST_ERROR, CONST_ERROR_EDITING_METADATA, e);
            return false;
        }
    }

    public boolean deleteMetadata() {
        HopGui hopGui = HopGui.getInstance();
        try {
            List<String> names = this.getNames();
            HopMetadata hopMetadata = HopMetadataUtil.getHopMetadataAnnotation(this.managedClass);
            ArrayList<GuiAction> actions = new ArrayList<GuiAction>();
            for (String name : names) {
                GuiAction action = new GuiAction(name, GuiActionType.Delete, name, name + " : " + hopMetadata.description(), hopMetadata.image(), (shiftAction, controlAction, t) -> this.deleteMetadata(name));
                action.setClassLoader(this.getClassLoader());
                actions.add(action);
            }
            return GuiContextUtil.getInstance().handleActionSelection(hopGui.getShell(), "Select the " + hopMetadata.name() + " to delete after confirmation", new GuiContextHandler("HopGuiMetadaContext", actions));
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), CONST_ERROR, "Error deleting metadata", e);
            return false;
        }
    }

    public boolean editMetadata(String elementName) {
        if (StringUtils.isEmpty((String)elementName)) {
            return false;
        }
        HopGui hopGui = HopGui.getInstance();
        try {
            IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(this.managedClass);
            IHopMetadata element = serializer.load(this.getVariables().resolve(elementName));
            if (element == null) {
                throw new HopException("Unable to find element '" + this.getVariables().resolve(elementName) + "' in the metadata");
            }
            this.initializeElementVariables(element);
            MetadataEditor<IHopMetadata> editor = this.createEditor(element);
            editor.setTitle(element.getName());
            MetadataPerspective perspective = HopGui.getMetadataPerspective();
            if (perspective.isActive()) {
                perspective.addEditor(editor);
                return false;
            }
            MetadataEditorDialog dialog = new MetadataEditorDialog(this.parentShell, editor);
            String result = dialog.open();
            if (result != null) {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)hopGui.getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiMetadataObjectUpdated.id, (Object)element);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), CONST_ERROR, CONST_ERROR_EDITING_METADATA, e);
            return false;
        }
    }

    public void editWithEditor(String name) {
        if (name == null) {
            return;
        }
        HopGui hopGui = HopGui.getInstance();
        try {
            HopMetadata annotation = HopMetadataUtil.getHopMetadataAnnotation(this.managedClass);
            MetadataPerspective perspective = MetadataPerspective.getInstance();
            MetadataEditor<?> editor = perspective.findEditor(annotation.key(), name);
            if (editor == null) {
                IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(this.managedClass);
                IHopMetadata element = serializer.load(name);
                if (element == null) {
                    throw new HopException("Unable to find element '" + name + "' in the metadata");
                }
                this.initializeElementVariables(element);
                perspective.addEditor(this.createEditor(element));
            } else {
                perspective.setActiveEditor(editor);
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), CONST_ERROR, CONST_ERROR_EDITING_METADATA, e);
        }
    }

    private void initializeElementVariables(T element) {
        if (element instanceof IVariables) {
            IVariables iVariables = (IVariables)element;
            iVariables.initializeFrom(this.variables);
        }
    }

    public boolean deleteMetadata(String elementName) {
        if (StringUtils.isEmpty((String)elementName)) {
            return false;
        }
        MessageBox confirmBox = new MessageBox(HopGui.getInstance().getShell(), 196);
        confirmBox.setText("Delete?");
        confirmBox.setMessage("Are you sure you want to delete element " + elementName + "?");
        int anwser = confirmBox.open();
        if ((anwser & 0x40) == 0) {
            return false;
        }
        try {
            IHopMetadataSerializer<T> serializer = this.getSerializer();
            IHopMetadata object = serializer.delete(elementName);
            this.initializeElementVariables(object);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiMetadataObjectDeleted.id, (Object)object);
            return true;
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), CONST_ERROR, "Error deleting metadata element " + elementName, e);
            return false;
        }
    }

    public boolean rename(String oldName, String newName) throws HopException {
        IHopMetadataSerializer<T> serializer = this.getSerializer();
        if (serializer.exists(newName)) {
            MessageBox messageBox = new MessageBox(HopGui.getInstance().getShell(), 33);
            messageBox.setText(this.getManagedName());
            messageBox.setMessage("Name '" + newName + "' already existe.");
            messageBox.open();
            return false;
        }
        T metadata = this.loadElement(oldName);
        metadata.setName(newName);
        serializer.save(metadata);
        serializer.delete(oldName);
        return true;
    }

    public IHopMetadataSerializer<T> getSerializer() throws HopException {
        return this.metadataProvider.getSerializer(this.managedClass);
    }

    public boolean openMetaDialog(T object, IHopMetadataSerializer<T> serializer) throws Exception {
        Constructor<?> constructor;
        Class<?> dialogClass;
        if (object == null) {
            return false;
        }
        HopGui hopGui = HopGui.getInstance();
        String dialogClassName = this.calculateDialogClassname();
        Class[] constructorArguments = new Class[]{Shell.class, IHopMetadataProvider.class, this.managedClass};
        Object[] constructorParameters = new Object[]{hopGui.getShell(), this.metadataProvider, object};
        try {
            dialogClass = this.classLoader.loadClass(dialogClassName);
        }
        catch (ClassNotFoundException e1) {
            String simpleDialogClassName = this.calculateSimpleDialogClassname();
            try {
                dialogClass = this.classLoader.loadClass(simpleDialogClassName);
            }
            catch (ClassNotFoundException e2) {
                try {
                    dialogClass = Class.forName(dialogClassName);
                }
                catch (ClassNotFoundException e3) {
                    dialogClass = Class.forName(simpleDialogClassName);
                }
            }
        }
        try {
            constructor = dialogClass.getDeclaredConstructor(constructorArguments);
        }
        catch (NoSuchMethodException nsm) {
            constructorArguments = new Class[]{Shell.class, IHopMetadataProvider.class, this.managedClass, IVariables.class};
            constructorParameters = new Object[]{hopGui.getShell(), this.metadataProvider, object, hopGui.getVariables()};
            constructor = dialogClass.getDeclaredConstructor(constructorArguments);
        }
        if (constructor == null) {
            throw new HopException("Unable to find dialog class (" + dialogClassName + ") constructor with arguments: Shell, IHopMetadataProvider, T and optionally IVariables");
        }
        IMetadataDialog dialog = (IMetadataDialog)constructor.newInstance(constructorParameters);
        String name = dialog.open();
        if (name != null) {
            serializer.save(object);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiMetadataObjectUpdated.id, object);
            return true;
        }
        return false;
    }

    public T newMetadata() {
        try {
            IHopMetadata element = (IHopMetadata)this.managedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.initializeElementVariables(element);
            return (T)this.newMetadata(element);
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), CONST_ERROR, "Error creating new metadata element", e);
            return null;
        }
    }

    public T newMetadata(T element) {
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiMetadataObjectCreateBeforeDialog.id, element);
            MetadataEditor<T> editor = this.createEditor(element);
            MetadataEditorDialog dialog = new MetadataEditorDialog(HopGui.getInstance().getShell(), editor);
            String name = dialog.open();
            if (name != null) {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiMetadataObjectCreated.id, element);
            }
            return element;
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), CONST_ERROR, "Error editing new metadata element", e);
            return null;
        }
    }

    public T newMetadataWithEditor(String virtualPath) {
        HopGui hopGui = HopGui.getInstance();
        try {
            IHopMetadata element = (IHopMetadata)this.managedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.initializeElementVariables(element);
            element.setVirtualPath(virtualPath);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)hopGui.getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiMetadataObjectCreateBeforeDialog.id, (Object)element);
            MetadataEditor<IHopMetadata> editor = this.createEditor(element);
            editor.setTitle(BaseMessages.getString(PKG, (String)"MetadataManager.New.Label", (String[])new String[]{TranslateUtil.translate((String)this.getManagedName(), this.managedClass)}));
            MetadataPerspective.getInstance().addEditor(editor);
            return (T)element;
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getActiveShell(), CONST_ERROR, "Error creating new metadata element", e);
            return null;
        }
    }

    public List<String> getNames() throws HopException {
        try {
            List names = this.getSerializer().listObjectNames();
            Collections.sort(names);
            return names;
        }
        catch (Exception e) {
            throw new HopException("Unable to get list of element names in the MetaStore for class " + this.managedClass.getName(), (Throwable)e);
        }
    }

    public String[] getNamesArray() throws HopException {
        try {
            return this.getNames().toArray(new String[0]);
        }
        catch (Exception e) {
            throw new HopException("Unable to get element names array in the MetaStore for class " + this.managedClass.getName(), (Throwable)e);
        }
    }

    public String calculateDialogClassname() {
        Object dialogClassName = this.managedClass.getName();
        dialogClassName = ((String)dialogClassName).replaceFirst("\\.hop\\.", ".hop.ui.");
        dialogClassName = (String)dialogClassName + "Dialog";
        return dialogClassName;
    }

    public String calculateSimpleDialogClassname() {
        Object dialogClassName = this.managedClass.getName();
        dialogClassName = (String)dialogClassName + "Dialog";
        return dialogClassName;
    }

    public MetadataEditor<T> createEditor(T metadata) throws HopException {
        Class<?> editorClass;
        Object className = this.managedClass.getName();
        className = (String)className + "Editor";
        try {
            editorClass = this.classLoader.loadClass((String)className);
        }
        catch (ClassNotFoundException e1) {
            className = this.managedClass.getName();
            className = ((String)className).replaceFirst("\\.hop\\.", ".hop.ui.");
            className = (String)className + "Editor";
            try {
                editorClass = this.classLoader.loadClass((String)className);
            }
            catch (ClassNotFoundException e) {
                throw new HopException("Unable to find editor class (" + (String)className + ")");
            }
        }
        try {
            Class[] constructorArguments = new Class[]{HopGui.class, MetadataManager.class, metadata.getClass()};
            Constructor<?> constructor = editorClass.getDeclaredConstructor(constructorArguments);
            return (MetadataEditor)constructor.newInstance(HopGui.getInstance(), this, metadata);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new HopException("Unable to create editor for class " + this.managedClass.getName(), (Throwable)e);
        }
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<T> getManagedClass() {
        return this.managedClass;
    }

    protected String getManagedName() {
        HopMetadata annotation = this.managedClass.getAnnotation(HopMetadata.class);
        if (annotation != null) {
            return annotation.name();
        }
        return null;
    }

    public void setManagedClass(Class<T> managedClass) {
        this.managedClass = managedClass;
    }

    public T loadElement(String selectedItem) throws HopException {
        IHopMetadata element = this.getSerializer().load(selectedItem);
        this.initializeElementVariables(element);
        return (T)element;
    }
}

