/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.KeyboardShortcut;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarItem;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarItemFilter;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.BaseGuiWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.svg.SvgLabelFacade;
import org.apache.hop.ui.core.widget.svg.SvgLabelListener;
import org.apache.hop.ui.hopgui.TextSizeUtilFacade;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class GuiToolbarWidgets
extends BaseGuiWidgets {
    public static final String CONST_TOOLBAR_ITEM_WITH_ID = "toolbar item with id '";
    private Map<String, GuiToolbarItem> guiToolBarMap = new HashMap<String, GuiToolbarItem>();
    private Map<String, Control> widgetsMap = new HashMap<String, Control>();
    private Map<String, ToolItem> toolItemMap = new HashMap<String, ToolItem>();
    private Color itemBackgroundColor;

    public GuiToolbarWidgets() {
        super(UUID.randomUUID().toString());
    }

    public void createToolbarWidgets(Composite parent, String root) {
        List toolbarItems = GuiRegistry.getInstance().findGuiToolbarItems(root);
        if (toolbarItems.isEmpty()) {
            LogChannel.UI.logError("Create widgets: no GUI toolbar items found for root: " + root);
            return;
        }
        Collections.sort(toolbarItems);
        for (GuiToolbarItem toolbarItem : toolbarItems) {
            boolean add = this.lookupToolbarItemFilter(toolbarItem, root);
            if (!add) continue;
            this.addToolbarWidgets(parent, toolbarItem);
        }
        parent.layout(true, true);
        this.addDeRegisterGuiPluginObjectListener((Control)parent);
    }

    private boolean lookupToolbarItemFilter(GuiToolbarItem toolbarItem, String root) {
        boolean show;
        block3: {
            show = true;
            try {
                Object guiPluginInstance = GuiToolbarWidgets.findGuiPluginInstance(toolbarItem.getClassLoader(), this.guiPluginClassName, this.instanceId);
                List itemFilters = (List)GuiRegistry.getInstance().getToolbarItemFiltersMap().get(root);
                if (itemFilters == null || itemFilters.isEmpty()) break block3;
                for (GuiToolbarItemFilter itemFilter : itemFilters) {
                    Class<?> guiPluginClass = itemFilter.getClassLoader().loadClass(itemFilter.getGuiPluginClassName());
                    Method guiPluginMethod = guiPluginClass.getMethod(itemFilter.getGuiPluginMethodName(), String.class, Object.class);
                    boolean showItem = (Boolean)guiPluginMethod.invoke(null, toolbarItem.getId(), guiPluginInstance);
                    if (showItem) continue;
                    show = false;
                    break;
                }
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error finding GUI plugin instance for class " + toolbarItem.getListenerClass() + " and instanceId=" + this.instanceId, (Throwable)e);
            }
        }
        return show;
    }

    private void addToolbarWidgets(Composite parent, GuiToolbarItem toolbarItem) {
        if (toolbarItem.isIgnored()) {
            return;
        }
        this.guiToolBarMap.put(toolbarItem.getId(), toolbarItem);
        if (!(parent instanceof ToolBar)) {
            throw new RuntimeException("We can only add toolbar items to a toolbar, not class " + parent.getClass().getName());
        }
        ToolBar toolBar = (ToolBar)parent;
        if (toolbarItem.isAddingSeparator() || toolbarItem.getType() != GuiToolbarElementType.BUTTON) {
            new ToolItem(toolBar, 2);
        }
        if (toolbarItem.getType() != GuiToolbarElementType.LABEL && toolbarItem.getType() != GuiToolbarElementType.CHECKBOX && StringUtils.isNotEmpty((String)toolbarItem.getLabel())) {
            ToolItem labelSeparator = new ToolItem(toolBar, 2);
            CLabel label = new CLabel(parent, 0x1000000 | (toolbarItem.isAlignRight() ? 131072 : 16384));
            label.setText(Const.NVL((String)toolbarItem.getLabel(), (String)""));
            label.setToolTipText(Const.NVL((String)toolbarItem.getToolTip(), (String)""));
            PropsUi.setLook((Widget)label, 5);
            label.pack();
            labelSeparator.setWidth(label.getSize().x);
            labelSeparator.setControl((Control)label);
        }
        switch (toolbarItem.getType()) {
            case LABEL: {
                this.addToolbarLabel(parent, toolbarItem, toolBar);
                break;
            }
            case BUTTON: {
                if (EnvironmentUtils.getInstance().isWeb()) {
                    this.addWebToolbarButton(toolbarItem, toolBar);
                    break;
                }
                this.addToolbarButton(toolbarItem, toolBar);
                break;
            }
            case COMBO: {
                this.addToolbarCombo(parent, toolbarItem, toolBar);
                break;
            }
            case CHECKBOX: {
                this.addToolbarCheckbox(parent, toolbarItem, toolBar);
                break;
            }
        }
    }

    private void addToolbarLabel(Composite parent, GuiToolbarItem toolbarItem, ToolBar toolBar) {
        ToolItem labelSeparator = new ToolItem(toolBar, 2);
        CLabel label = new CLabel(parent, 0x1000000 | (toolbarItem.isAlignRight() ? 131072 : 16384));
        label.setText(Const.NVL((String)toolbarItem.getLabel(), (String)""));
        label.setToolTipText(Const.NVL((String)toolbarItem.getToolTip(), (String)""));
        PropsUi.setLook((Widget)label, 5);
        label.pack();
        labelSeparator.setWidth(label.getSize().x);
        labelSeparator.setControl((Control)label);
        this.toolItemMap.put(toolbarItem.getId(), labelSeparator);
        this.widgetsMap.put(toolbarItem.getId(), (Control)label);
        Listener listener = this.getListener(toolbarItem);
        label.addListener(4, listener);
    }

    private void addToolbarCombo(Composite parent, GuiToolbarItem toolbarItem, ToolBar toolBar) {
        ToolItem comboSeparator = new ToolItem(toolBar, 2);
        Combo combo = new Combo(parent, 4 | (toolbarItem.isAlignRight() ? 131072 : 16384));
        combo.setToolTipText(Const.NVL((String)toolbarItem.getToolTip(), (String)""));
        combo.setItems(this.getComboItems(toolbarItem));
        PropsUi.setLook((Widget)combo);
        combo.pack();
        comboSeparator.setWidth(this.calculateComboWidth(combo) + toolbarItem.getExtraWidth());
        comboSeparator.setControl((Control)combo);
        Listener listener = this.getListener(toolbarItem);
        combo.addListener(13, listener);
        combo.addListener(14, listener);
        this.toolItemMap.put(toolbarItem.getId(), comboSeparator);
        this.widgetsMap.put(toolbarItem.getId(), (Control)combo);
        PropsUi.setLook((Widget)combo, 5);
    }

    private void addToolbarCheckbox(Composite parent, GuiToolbarItem toolbarItem, ToolBar toolBar) {
        ToolItem checkboxSeparator = new ToolItem(toolBar, 2);
        Button checkbox = new Button(parent, 0x20 | (toolbarItem.isAlignRight() ? 131072 : 16384));
        checkbox.setToolTipText(Const.NVL((String)toolbarItem.getToolTip(), (String)""));
        checkbox.setText(Const.NVL((String)toolbarItem.getLabel(), (String)""));
        PropsUi.setLook((Widget)checkbox);
        checkbox.pack();
        checkboxSeparator.setWidth(checkbox.getSize().x + toolbarItem.getExtraWidth());
        checkboxSeparator.setControl((Control)checkbox);
        Listener listener = this.getListener(toolbarItem);
        checkbox.addListener(13, listener);
        this.toolItemMap.put(toolbarItem.getId(), checkboxSeparator);
        this.widgetsMap.put(toolbarItem.getId(), (Control)checkbox);
    }

    private void addToolbarButton(GuiToolbarItem toolbarItem, ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 0);
        if (this.itemBackgroundColor != null) {
            item.setBackground(this.itemBackgroundColor);
        }
        String imageLocation = this.findImageFilename(toolbarItem);
        this.setImages(item, toolbarItem.getClassLoader(), imageLocation);
        if (StringUtils.isNotEmpty((String)toolbarItem.getToolTip())) {
            item.setToolTipText(toolbarItem.getToolTip());
        }
        Listener listener = this.getListener(toolbarItem);
        item.addListener(13, listener);
        this.toolItemMap.put(toolbarItem.getId(), item);
        this.setToolItemKeyboardShortcut(item, toolbarItem);
    }

    private String findImageFilename(GuiToolbarItem toolbarItem) {
        String imageLocation;
        if (StringUtils.isEmpty((String)toolbarItem.getImageMethod())) {
            imageLocation = toolbarItem.getImage();
        } else {
            try {
                Class<?> imageMethodClass = toolbarItem.getClassLoader().loadClass(toolbarItem.getListenerClass());
                Method imageMethod = imageMethodClass.getMethod(toolbarItem.getImageMethod(), Object.class);
                Object guiPluginInstance = GuiToolbarWidgets.findGuiPluginInstance(toolbarItem.getClassLoader(), toolbarItem.getListenerClass(), this.instanceId);
                imageLocation = (String)imageMethod.invoke(null, guiPluginInstance);
            }
            catch (Exception e) {
                imageLocation = null;
                LogChannel.UI.logError("Error getting toolbar image filename with method " + toolbarItem.getListenerClass() + "." + toolbarItem.getImageMethod(), (Throwable)e);
            }
        }
        return imageLocation;
    }

    private void addWebToolbarButton(GuiToolbarItem toolbarItem, ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 2);
        Label label = new Label((Composite)toolBar, 0);
        if (StringUtils.isNotEmpty((String)toolbarItem.getToolTip())) {
            label.setToolTipText(toolbarItem.getToolTip());
        }
        Listener listener = SvgLabelListener.getInstance();
        label.addListener(3, listener);
        label.addListener(23, listener);
        label.addListener(22, listener);
        label.addListener(6, listener);
        label.addListener(7, listener);
        label.addListener(3, this.getListener(toolbarItem));
        label.pack();
        int size = (int)(16.0 * PropsUi.getNativeZoomFactor() + (double)toolbarItem.getExtraWidth());
        String imageFilename = this.findImageFilename(toolbarItem);
        SvgLabelFacade.setData(toolbarItem.getId(), label, imageFilename, size);
        item.setWidth(size);
        item.setControl((Control)label);
        this.widgetsMap.put(toolbarItem.getId(), (Control)label);
        this.toolItemMap.put(toolbarItem.getId(), item);
    }

    private void setToolItemKeyboardShortcut(ToolItem toolItem, GuiToolbarItem guiToolbarItem) {
        KeyboardShortcut shortcut = GuiRegistry.getInstance().findKeyboardShortcut(guiToolbarItem.getListenerClass(), guiToolbarItem.getListenerMethod(), Const.isOSX());
        if (shortcut != null) {
            toolItem.setToolTipText(toolItem.getToolTipText() + " (" + shortcut.toString() + ")");
        }
    }

    private void setImages(ToolItem item, ClassLoader classLoader, String location) {
        GuiResource gr = GuiResource.getInstance();
        int width = 16;
        int height = 16;
        if (StringUtils.isNotEmpty((String)location)) {
            Image enabledImage = gr.getImage(location, classLoader, width, height);
            item.setImage(enabledImage);
            Image disabledImage = gr.getImage(location, classLoader, width, height, true);
            item.setDisabledImage(disabledImage);
        }
    }

    private int calculateComboWidth(Combo combo) {
        int maxWidth = combo.getSize().x;
        for (String item : combo.getItems()) {
            int width = TextSizeUtilFacade.textExtent((String)item).x;
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    public void enableToolbarItem(String id, boolean enabled) {
        ToolItem toolItem = this.toolItemMap.get(id);
        if (toolItem == null || toolItem.isDisposed()) {
            return;
        }
        if (EnvironmentUtils.getInstance().isWeb()) {
            Label label = (Label)this.widgetsMap.get(id);
            SvgLabelFacade.enable(toolItem, id, label, enabled);
        } else if (enabled != toolItem.isEnabled()) {
            toolItem.setEnabled(enabled);
        }
    }

    public ToolItem enableToolbarItem(IHopFileType fileType, String id, String permission) {
        return this.enableToolbarItem(fileType, id, permission, true);
    }

    public ToolItem enableToolbarItem(IHopFileType fileType, String id, String permission, boolean active) {
        boolean enabled;
        ToolItem item = this.findToolItem(id);
        if (item == null || item.isDisposed()) {
            return null;
        }
        boolean hasCapability = fileType.hasCapability(permission);
        boolean bl = enabled = hasCapability && active;
        if (enabled != item.isEnabled()) {
            boolean enable;
            boolean bl2 = enable = hasCapability && active;
            if (EnvironmentUtils.getInstance().isWeb()) {
                Label label = (Label)this.widgetsMap.get(id);
                SvgLabelFacade.enable(null, id, label, enable);
            } else {
                item.setEnabled(enable);
            }
        }
        return item;
    }

    public ToolItem findToolItem(String id) {
        return this.toolItemMap.get(id);
    }

    public void refreshComboItemList(String id) {
        GuiToolbarItem item = this.guiToolBarMap.get(id);
        if (item != null) {
            Control control = this.widgetsMap.get(id);
            if (control != null) {
                if (control instanceof Combo) {
                    Combo combo = (Combo)control;
                    combo.setItems(this.getComboItems(item));
                } else {
                    LogChannel.UI.logError(CONST_TOOLBAR_ITEM_WITH_ID + id + "' : widget not of instance Combo");
                }
            } else {
                LogChannel.UI.logError(CONST_TOOLBAR_ITEM_WITH_ID + id + "' : control not found when refreshing combo");
            }
        } else {
            LogChannel.UI.logError(CONST_TOOLBAR_ITEM_WITH_ID + id + "' : not found when refreshing combo");
        }
    }

    public void selectComboItem(String id, String string) {
        Control control;
        GuiToolbarItem item = this.guiToolBarMap.get(id);
        if (item != null && (control = this.widgetsMap.get(id)) instanceof Combo) {
            Combo combo = (Combo)control;
            combo.setText(Const.NVL((String)string, (String)""));
            int index = Const.indexOfString((String)string, (String[])combo.getItems());
            if (index >= 0) {
                combo.select(index);
            }
        }
    }

    protected Listener getListener(GuiToolbarItem toolbarItem) {
        return this.getListener(toolbarItem.getClassLoader(), toolbarItem.getListenerClass(), toolbarItem.getListenerMethod());
    }

    public Map<String, Control> getWidgetsMap() {
        return this.widgetsMap;
    }

    public void setWidgetsMap(Map<String, Control> widgetsMap) {
        this.widgetsMap = widgetsMap;
    }

    public Map<String, ToolItem> getToolItemMap() {
        return this.toolItemMap;
    }

    public void setToolItemMap(Map<String, ToolItem> toolItemMap) {
        this.toolItemMap = toolItemMap;
    }

    public Map<String, GuiToolbarItem> getGuiToolBarMap() {
        return this.guiToolBarMap;
    }

    public void setGuiToolBarMap(Map<String, GuiToolbarItem> guiToolBarMap) {
        this.guiToolBarMap = guiToolBarMap;
    }

    public Color getItemBackgroundColor() {
        return this.itemBackgroundColor;
    }

    public void setItemBackgroundColor(Color itemBackgroundColor) {
        this.itemBackgroundColor = itemBackgroundColor;
    }
}

