/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.implementation.jackson.JacksonDatabind212;
import com.azure.core.implementation.jackson.JacksonVersion;
import com.azure.core.implementation.jackson.ObjectMapperFactory;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import java.lang.reflect.Array;

public final class XmlMapperFactory {
    private static final ClientLogger LOGGER = new ClientLogger(XmlMapperFactory.class);
    private static final String XML_MAPPER = "com.fasterxml.jackson.dataformat.xml.XmlMapper";
    private static final String XML_MAPPER_BUILDER = "com.fasterxml.jackson.dataformat.xml.XmlMapper$Builder";
    private static final String FROM_XML_PARSER = "com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser$Feature";
    private static final String TO_XML_GENERATOR = "com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator$Feature";
    private final ReflectiveInvoker createXmlMapperBuilder;
    private final ReflectiveInvoker defaultUseWrapper;
    private final ReflectiveInvoker enableWriteXmlDeclaration;
    private final Object writeXmlDeclaration;
    private final ReflectiveInvoker enableEmptyElementAsNull;
    private final Object emptyElementAsNull;
    final boolean useJackson212;
    private boolean jackson212IsSafe = true;
    public static final XmlMapperFactory INSTANCE = new XmlMapperFactory();

    private XmlMapperFactory() {
        Object emptyElementAsNull;
        ReflectiveInvoker enableEmptyElementAsNull;
        Object writeXmlDeclaration;
        ReflectiveInvoker enableWriteXmlDeclaration;
        ReflectiveInvoker defaultUseWrapper;
        ReflectiveInvoker createXmlMapperBuilder;
        ClassLoader thisClassLoader = XmlMapperFactory.class.getClassLoader();
        try {
            Class<?> xmlMapper = Class.forName(XML_MAPPER, true, thisClassLoader);
            Class<?> xmlMapperBuilder = Class.forName(XML_MAPPER_BUILDER, true, thisClassLoader);
            Class<?> fromXmlParser = Class.forName(FROM_XML_PARSER, true, thisClassLoader);
            Class<?> toXmlGenerator = Class.forName(TO_XML_GENERATOR, true, thisClassLoader);
            createXmlMapperBuilder = ReflectionUtils.getMethodInvoker(xmlMapper, xmlMapper.getDeclaredMethod("builder", new Class[0]), false);
            defaultUseWrapper = ReflectionUtils.getMethodInvoker(xmlMapperBuilder, xmlMapperBuilder.getDeclaredMethod("defaultUseWrapper", Boolean.TYPE), false);
            enableWriteXmlDeclaration = ReflectionUtils.getMethodInvoker(xmlMapperBuilder, xmlMapperBuilder.getDeclaredMethod("enable", Array.newInstance(toXmlGenerator, 0).getClass()), false);
            writeXmlDeclaration = toXmlGenerator.getDeclaredField("WRITE_XML_DECLARATION").get(null);
            enableEmptyElementAsNull = ReflectionUtils.getMethodInvoker(xmlMapperBuilder, xmlMapperBuilder.getDeclaredMethod("enable", Array.newInstance(fromXmlParser, 0).getClass()), false);
            emptyElementAsNull = fromXmlParser.getDeclaredField("EMPTY_ELEMENT_AS_NULL").get(null);
        }
        catch (Throwable ex) {
            if (ex instanceof Error && !(ex instanceof LinkageError)) {
                throw LOGGER.logThrowableAsError((Error)ex);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Failed to retrieve invoker used to create XmlMapper. XML serialization won't be supported until 'com.fasterxml.jackson.dataformat:jackson-dataformat-xml' is added to the classpath or updated to a supported version. " + JacksonVersion.getHelpInfo(), ex));
        }
        this.createXmlMapperBuilder = createXmlMapperBuilder;
        this.defaultUseWrapper = defaultUseWrapper;
        this.enableWriteXmlDeclaration = enableWriteXmlDeclaration;
        this.writeXmlDeclaration = writeXmlDeclaration;
        this.enableEmptyElementAsNull = enableEmptyElementAsNull;
        this.emptyElementAsNull = emptyElementAsNull;
        this.useJackson212 = PackageVersion.VERSION.getMinorVersion() >= 12;
    }

    public ObjectMapper createXmlMapper() {
        ObjectMapper xmlMapper;
        try {
            MapperBuilder xmlMapperBuilder = ObjectMapperFactory.initializeMapperBuilder((MapperBuilder)this.createXmlMapperBuilder.invokeStatic(new Object[0]));
            this.defaultUseWrapper.invokeWithArguments(xmlMapperBuilder, false);
            this.enableWriteXmlDeclaration.invokeWithArguments(xmlMapperBuilder, this.writeXmlDeclaration);
            this.enableEmptyElementAsNull.invokeWithArguments(xmlMapperBuilder, this.emptyElementAsNull);
            xmlMapper = xmlMapperBuilder.build();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)exception);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Unable to create XmlMapper instance.", exception));
        }
        if (this.useJackson212 && this.jackson212IsSafe) {
            try {
                return JacksonDatabind212.mutateXmlCoercions(xmlMapper);
            }
            catch (Throwable ex) {
                if (ex instanceof LinkageError) {
                    this.jackson212IsSafe = false;
                    LOGGER.log(LogLevel.VERBOSE, JacksonVersion::getHelpInfo, ex);
                }
                throw ex;
            }
        }
        return xmlMapper;
    }
}

