/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.netezza;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="NETEZZA", typeDescription="Netezza", documentationUrl="/database/databases/netezza.html")
@GuiPlugin(id="GUI-NetezzaDatabaseMeta")
public class NetezzaDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static final int MAX_CHAR_LEN = Short.MAX_VALUE;
    public static final String CONST_TIMESTAMP = "TIMESTAMP";

    public String getExtraOptionSeparator() {
        return "&";
    }

    public String getExtraOptionIndicator() {
        return "?";
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 5480;
        }
        return -1;
    }

    public String getDriverClass() {
        return "org.netezza.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:netezza://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return true;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsSynonyms() {
        return false;
    }

    public boolean isSupportsSequences() {
        return true;
    }

    public boolean isSupportsAutoInc() {
        return false;
    }

    public String getLimitClause(int nrRows) {
        return " limit " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + this.getLimitClause(1);
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + this.getLimitClause(1);
    }

    public String getSqlNextSequenceValue(String sequenceName) {
        return "select next value for " + sequenceName;
    }

    public String getSqlCurrentSequenceValue(String sequenceName) {
        return "select last_value from " + sequenceName;
    }

    public String getSqlSequenceExists(String sequenceName) {
        return "SELECT seqname AS sequence_name from _v_sequence where seqname = '" + sequenceName.toLowerCase() + "'";
    }

    public String getSqlListOfSequences() {
        return "SELECT seqname AS sequence_name from _v_sequence";
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return null;
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return null;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        Object retval = "";
        retval = (String)retval + "ALTER TABLE " + tableName + " MODIFY COLUMN " + v.getName() + Const.CR + ";" + Const.CR;
        return retval;
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = (String)retval + "date";
                break;
            }
            case 4: {
                retval = (String)retval + "boolean";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (length <= 0) break;
                if (precision == 0) {
                    if (length <= 2) {
                        retval = (String)retval + "byteint";
                        break;
                    }
                    if (length <= 4) {
                        retval = (String)retval + "smallint";
                        break;
                    }
                    if (length <= 9) {
                        retval = (String)retval + "integer";
                        break;
                    }
                    retval = (String)retval + "bigint";
                    break;
                }
                if (length < 9) {
                    retval = (String)retval + "real";
                    break;
                }
                if (length < 18) {
                    retval = (String)retval + "double";
                    break;
                }
                retval = (String)retval + "numeric(" + length;
                if (precision > 0) {
                    retval = (String)retval + ", " + precision;
                }
                retval = (String)retval + ")";
                break;
            }
            case 2: {
                if (length > Short.MAX_VALUE) {
                    retval = (String)retval + "varchar(32767)";
                    break;
                }
                retval = (String)retval + "varchar(" + length + ")";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String getSqlListOfProcedures() {
        return null;
    }

    public String[] getReservedWords() {
        return new String[]{"ABORT", "ADMIN", "AGGREGATE", "ALIGN", "ALL", "ALLOCATE", "ANALYSE", "ANALYZE", "AND", "ANY", "AS", "ASC", "BETWEEN", "BINARY", "BIT", "BOTH", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "CLUSTER", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "CONSTRAINT", "COPY", "CROSS", "CURRENT", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_DB", "CURRENT_SCHEMA", "CURRENT_SID", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURRENT_USERID", "CURRENT_USEROID", "DEALLOCATE", "DEC", "DECIMAL", "DECODE", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DISTRIBUTE", "DO", "ELSE", "END", "EXCEPT", "EXCLUDE", "EXISTS", "EXPLAIN", "EXPRESS", "EXTEND", "EXTRACT", "FALSE", "FIRST", "FLOAT", "FOLLOWING", "FOR", "FOREIGN", "FROM", "FULL", "FUNCTION", "GENSTATS", "GLOBAL", "GROUP", "HAVING", "ILIKE", "IN", "INDEX", "INITIALLY", "INNER", "INOUT", "INTERSECT", "INTERVAL", "INTO", "IS", "ISNULL", "JOIN", "LAST", "LEADING", "LEFT", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCK", "MATERIALIZED", "MINUS", "MOVE", "NATURAL", "NCHAR", "NEW", "NOT", "NOTNULL", "NULL", "NULLIF", "NULLS", "NUMERIC", "NVL", "NVL2", "OFF", "OFFSET", "OLD", "ON", "ONLINE", "ONLY", "OR", "ORDER", "OTHERS", "OUT", "OUTER", "OVER", "OVERLAPS", "PARTITION", "POSITION", "PRECEDING", "PRECISION", "PRESERVE", "PRIMARY", "PUBLIC", "RANGE", "RECLAIM", "REFERENCES", "RESET", "REUSE", "RIGHT", "ROWS", "ROWSETLIMIT", "RULE", "SEARCH", "SELECT", "SEQUENCE", "SESSION_USER", "SETOF", "SHOW", "SOME", "SUBSTRING", "SYSTEM", "TABLE", "THEN", "TIES", "TIME", CONST_TIMESTAMP, "TO", "TRAILING", "TRANSACTION", "TRIGGER", "TRIM", "TRUE", "UNBOUNDED", "UNION", "UNIQUE", "USER", "USING", "VACUUM", "VARCHAR", "VERBOSE", "VIEW", "WHEN", "WHERE", "WITH", "WRITE", "ABSOLUTE", "ACTION", "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALIAS", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "BEFORE", "BEGIN", "BINARY", "BIT", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHECK", "CLASS", "CLOB", "CLOSE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "COMPLETION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTINUE", "CORRESPONDING", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_", CONST_TIMESTAMP, "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DESTROY", "DESTRUCTOR", "DETERMINISTIC", "DIAGNOSTICS", "DICTIONARY", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELSE", "END_EXEC", "END", "EQUALS", "ESCAPE", "EVERY", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FREE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HAVING", "HOST", "HOUR", "IDENTITY", "IGNORE", "IMMEDIATE", "IN", "INDICATOR", "INITIALIZE", "INITIALLY", "INNER", "INOUT", "INPUT", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "KEY", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "MAP", "MATCH", "MINUTE", "MODIFIES", "MODIFY", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NONE", "NOT", "NULL", "NUMERIC", "OBJECT", "OF", "OFF", "OLD", "ON", "ONLY", "OPEN", "OPERATION", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "PAD", "PARAMETER", "PARAMETERS", "PARTIAL", "PATH", "POSTFIX", "PRECISION", "PREFIX", "PREORDER", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "RELATIVE", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "SAVEPOINT", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECTION", "SELECT", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETS", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STATE", "STATEMENT", "STATIC", "STRUCTURE", "SYSTEM_USER", "TABLE", "TEMPORARY", "TERMINATE", "THAN", "THEN", "TIME", CONST_TIMESTAMP, "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATION", "TREAT", "TRIGGER", "TRUE", "UNDER", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"};
    }

    public String getSqlLockTables(String[] tableNames) {
        return null;
    }

    public String getSqlUnlockTables(String[] tableName) {
        return null;
    }

    public boolean isDefaultingToUppercase() {
        return false;
    }

    public boolean isSupportsTimeStampToDateConversion() {
        return false;
    }

    public boolean isNetezzaVariant() {
        return true;
    }
}

