/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.gencsv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.neo4j.core.data.GraphData;
import org.apache.hop.neo4j.core.data.GraphNodeData;
import org.apache.hop.neo4j.core.data.GraphPropertyData;
import org.apache.hop.neo4j.core.data.GraphRelationshipData;
import org.apache.hop.neo4j.transforms.gencsv.IdType;
import org.apache.hop.neo4j.transforms.gencsv.NodeCollisionListener;
import org.apache.hop.neo4j.transforms.gencsv.RelationshipCollisionListener;
import org.apache.hop.neo4j.transforms.gencsv.UniquenessStrategy;

public class IndexedGraphData
extends GraphData {
    protected UniquenessStrategy nodeUniquenessStrategy = UniquenessStrategy.None;
    protected UniquenessStrategy relationshipUniquenessStrategy = UniquenessStrategy.None;
    protected Map<String, Integer> nodeIdMap = new HashMap<String, Integer>();
    protected Map<String, Integer> relIdMap = new HashMap<String, Integer>();
    protected List<NodeCollisionListener> nodeCollisionListeners = new ArrayList<NodeCollisionListener>();
    protected List<RelationshipCollisionListener> relCollisionListeners = new ArrayList<RelationshipCollisionListener>();
    protected Set<IdType> nodePropertiesSet = new HashSet<IdType>();
    protected Set<IdType> relPropertiesSet = new HashSet<IdType>();

    public IndexedGraphData() {
    }

    public IndexedGraphData(UniquenessStrategy nodeUniquenessStrategy, UniquenessStrategy relationshipUniquenessStrategy) {
        this();
        this.nodeUniquenessStrategy = nodeUniquenessStrategy;
        this.relationshipUniquenessStrategy = relationshipUniquenessStrategy;
    }

    public Integer addAndIndexNode(GraphNodeData node) throws HopException {
        Integer index = this.nodeIdMap.get(node.getId());
        if (index == null) {
            this.getNodes().add(node);
            this.nodeIdMap.put(node.getId(), this.getNodes().size() - 1);
        } else {
            GraphNodeData existingNode = this.getNodes().get(index);
            GraphNodeData updatingNode = node;
            switch (this.nodeUniquenessStrategy) {
                case Last: {
                    this.getNodes().set(index, updatingNode);
                    break;
                }
            }
            for (NodeCollisionListener listener : this.nodeCollisionListeners) {
                listener.handleCollission(this.getNodes().get(index), node);
            }
        }
        for (GraphPropertyData property : node.getProperties()) {
            this.nodePropertiesSet.add(new IdType(property.getId(), property.getType()));
        }
        return index;
    }

    public Integer addAndIndexRelationship(GraphRelationshipData relationship) throws HopException {
        Integer index = this.relIdMap.get(relationship.getId());
        if (index == null) {
            this.getRelationships().add(relationship);
            this.relIdMap.put(relationship.getId(), this.getRelationships().size() - 1);
        } else {
            GraphRelationshipData existingRelationship = this.getRelationships().get(index);
            GraphRelationshipData updatingRelationship = relationship;
            switch (this.relationshipUniquenessStrategy) {
                case Last: {
                    this.getRelationships().set(index, updatingRelationship);
                    break;
                }
            }
            for (RelationshipCollisionListener listener : this.relCollisionListeners) {
                listener.handleCollission(this.getRelationships().get(index), relationship);
            }
        }
        for (GraphPropertyData property : relationship.getProperties()) {
            this.relPropertiesSet.add(new IdType(property.getId(), property.getType()));
        }
        return index;
    }

    public void clearAll() {
        this.nodes.clear();
        this.relationships.clear();
        this.nodeIdMap.clear();
        this.relIdMap.clear();
    }

    public Map<String, Integer> getNodeIdMap() {
        return this.nodeIdMap;
    }

    public void setNodeIdMap(Map<String, Integer> nodeIdMap) {
        this.nodeIdMap = nodeIdMap;
    }

    public Map<String, Integer> getRelIdMap() {
        return this.relIdMap;
    }

    public void setRelIdMap(Map<String, Integer> relIdMap) {
        this.relIdMap = relIdMap;
    }

    public List<NodeCollisionListener> getNodeCollisionListeners() {
        return this.nodeCollisionListeners;
    }

    public void setNodeCollisionListeners(List<NodeCollisionListener> nodeCollisionListeners) {
        this.nodeCollisionListeners = nodeCollisionListeners;
    }

    public List<RelationshipCollisionListener> getRelCollisionListeners() {
        return this.relCollisionListeners;
    }

    public void setRelCollisionListeners(List<RelationshipCollisionListener> relCollisionListeners) {
        this.relCollisionListeners = relCollisionListeners;
    }

    public Set<IdType> getNodePropertiesSet() {
        return this.nodePropertiesSet;
    }

    public void setNodePropertiesSet(Set<IdType> nodePropertiesSet) {
        this.nodePropertiesSet = nodePropertiesSet;
    }

    public Set<IdType> getRelPropertiesSet() {
        return this.relPropertiesSet;
    }

    public void setRelPropertiesSet(Set<IdType> relPropertiesSet) {
        this.relPropertiesSet = relPropertiesSet;
    }
}

