/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.census.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallOptions;
import io.opencensus.contrib.grpc.metrics.RpcMeasureConstants;
import io.opencensus.contrib.grpc.metrics.RpcViewConstants;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.Measure;
import io.opencensus.stats.View;
import io.opencensus.trace.SpanContext;
import java.util.Arrays;

@VisibleForTesting
public final class ObservabilityCensusConstants {
    public static CallOptions.Key<SpanContext> CLIENT_TRACE_SPAN_CONTEXT_KEY = CallOptions.Key.createWithDefault((String)"Client span context for tracing", (Object)SpanContext.INVALID);
    static final Aggregation AGGREGATION_WITH_BYTES_HISTOGRAM = RpcViewConstants.GRPC_CLIENT_SENT_BYTES_PER_RPC_VIEW.getAggregation();
    static final Aggregation AGGREGATION_WITH_MILLIS_HISTOGRAM = RpcViewConstants.GRPC_CLIENT_ROUNDTRIP_LATENCY_VIEW.getAggregation();
    public static final Measure.MeasureDouble API_LATENCY_PER_CALL = Measure.MeasureDouble.create((String)"grpc.io/client/api_latency", (String)"Time taken by gRPC to complete an RPC from application's perspective", (String)"ms");
    public static final View GRPC_CLIENT_API_LATENCY_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/api_latency"), (String)"Time taken by gRPC to complete an RPC from application's perspective", (Measure)API_LATENCY_PER_CALL, (Aggregation)AGGREGATION_WITH_MILLIS_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_CLIENT_METHOD, RpcMeasureConstants.GRPC_CLIENT_STATUS));
    public static final View GRPC_CLIENT_SENT_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/sent_compressed_message_bytes_per_rpc"), (String)"Compressed message bytes sent per client RPC attempt", (Measure)RpcMeasureConstants.GRPC_CLIENT_SENT_BYTES_PER_RPC, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_CLIENT_METHOD, RpcMeasureConstants.GRPC_CLIENT_STATUS));
    public static final View GRPC_CLIENT_RECEIVED_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/client/received_compressed_message_bytes_per_rpc"), (String)"Compressed message bytes received per client RPC attempt", (Measure)RpcMeasureConstants.GRPC_CLIENT_RECEIVED_BYTES_PER_RPC, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_CLIENT_METHOD, RpcMeasureConstants.GRPC_CLIENT_STATUS));
    public static final View GRPC_SERVER_SENT_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/sent_compressed_message_bytes_per_rpc"), (String)"Compressed message bytes sent per server RPC", (Measure)RpcMeasureConstants.GRPC_SERVER_SENT_BYTES_PER_RPC, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_SERVER_METHOD, RpcMeasureConstants.GRPC_SERVER_STATUS));
    public static final View GRPC_SERVER_RECEIVED_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW = View.create((View.Name)View.Name.create((String)"grpc.io/server/received_compressed_message_bytes_per_rpc"), (String)"Compressed message bytes received per server RPC", (Measure)RpcMeasureConstants.GRPC_SERVER_RECEIVED_BYTES_PER_RPC, (Aggregation)AGGREGATION_WITH_BYTES_HISTOGRAM, Arrays.asList(RpcMeasureConstants.GRPC_SERVER_METHOD, RpcMeasureConstants.GRPC_SERVER_STATUS));

    private ObservabilityCensusConstants() {
    }
}

