/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.memgroupby;

import java.util.HashMap;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transforms.memgroupby.Aggregate;

public class MemoryGroupByData
extends BaseTransformData
implements ITransformData {
    public HashMap<HashEntry, Aggregate> map;
    public IRowMeta aggMeta;
    public IRowMeta groupMeta;
    public IRowMeta entryMeta;
    public IRowMeta groupAggMeta;
    public int[] groupnrs;
    public int[] subjectnrs;
    public boolean firstRead;
    public Object[] groupResult;
    public boolean hasOutput;
    public IRowMeta inputRowMeta;
    public IRowMeta outputRowMeta;
    public IValueMeta valueMetaInteger;
    public IValueMeta valueMetaNumber;
    public boolean newBatch;

    public HashEntry getHashEntry(Object[] groupData) {
        return new HashEntry(groupData);
    }

    public void clear() {
        this.map = new HashMap();
    }

    public class HashEntry {
        private Object[] groupData;

        public HashEntry(Object[] groupData) {
            this.groupData = groupData;
        }

        public Object[] getGroupData() {
            return this.groupData;
        }

        public boolean equals(Object obj) {
            HashEntry entry = (HashEntry)obj;
            try {
                return MemoryGroupByData.this.groupMeta.compare(this.groupData, entry.groupData) == 0;
            }
            catch (HopValueException e) {
                throw new RuntimeException(e);
            }
        }

        public int hashCode() {
            try {
                return MemoryGroupByData.this.groupMeta.hashCode(this.getHashValue());
            }
            catch (HopValueException e) {
                throw new RuntimeException(e);
            }
        }

        private Object[] getHashValue() throws HopValueException {
            Object[] groupDataHash = new Object[MemoryGroupByData.this.groupMeta.size()];
            for (int i = 0; i < MemoryGroupByData.this.groupMeta.size(); ++i) {
                IValueMeta valueMeta = MemoryGroupByData.this.groupMeta.getValueMeta(i);
                groupDataHash[i] = valueMeta.convertToNormalStorageType(this.groupData[i]);
            }
            return groupDataHash;
        }
    }
}

