/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class SharedContentRestoreInviteesDetails {
    @Nonnull
    protected final AccessLevel sharedContentAccessLevel;
    @Nonnull
    protected final List<String> invitees;

    public SharedContentRestoreInviteesDetails(@Nonnull AccessLevel sharedContentAccessLevel, @Nonnull List<String> invitees) {
        if (sharedContentAccessLevel == null) {
            throw new IllegalArgumentException("Required value for 'sharedContentAccessLevel' is null");
        }
        this.sharedContentAccessLevel = sharedContentAccessLevel;
        if (invitees == null) {
            throw new IllegalArgumentException("Required value for 'invitees' is null");
        }
        for (String x : invitees) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'invitees' is null");
            }
            if (x.length() <= 255) continue;
            throw new IllegalArgumentException("Stringan item in list 'invitees' is longer than 255");
        }
        this.invitees = invitees;
    }

    @Nonnull
    public AccessLevel getSharedContentAccessLevel() {
        return this.sharedContentAccessLevel;
    }

    @Nonnull
    public List<String> getInvitees() {
        return this.invitees;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharedContentAccessLevel, this.invitees});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedContentRestoreInviteesDetails other = (SharedContentRestoreInviteesDetails)obj;
            return !(this.sharedContentAccessLevel != other.sharedContentAccessLevel && !this.sharedContentAccessLevel.equals((Object)other.sharedContentAccessLevel) || this.invitees != other.invitees && !this.invitees.equals(other.invitees));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedContentRestoreInviteesDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedContentRestoreInviteesDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("shared_content_access_level");
            AccessLevel.Serializer.INSTANCE.serialize(value.sharedContentAccessLevel, g);
            g.writeFieldName("invitees");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.invitees, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedContentRestoreInviteesDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_invitees;
            AccessLevel f_sharedContentAccessLevel;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_sharedContentAccessLevel = null;
                f_invitees = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("shared_content_access_level".equals(field)) {
                        f_sharedContentAccessLevel = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("invitees".equals(field)) {
                        f_invitees = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_sharedContentAccessLevel == null) {
                    throw new JsonParseException(p, "Required field \"shared_content_access_level\" missing.");
                }
                if (f_invitees == null) {
                    throw new JsonParseException(p, "Required field \"invitees\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedContentRestoreInviteesDetails value = new SharedContentRestoreInviteesDetails(f_sharedContentAccessLevel, f_invitees);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

